/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.surface.ellipse;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.List;
import org.cresques.cts.CoordTransRuntimeException;
import org.cresques.cts.ICoordTrans;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.jts.gputils.DefaultGeneralPathX;
import org.gvsig.fmap.geom.jts.primitive.point.Point2D;
import org.gvsig.fmap.geom.jts.primitive.point.PointJTS;
import org.gvsig.fmap.geom.jts.primitive.surface.AbstractSurface;
import org.gvsig.fmap.geom.jts.primitive.surface.ellipse.Ellipse2D;
import org.gvsig.fmap.geom.jts.primitive.surface.ellipse.Ellipse2DM;
import org.gvsig.fmap.geom.jts.primitive.surface.ellipse.Ellipse2DZ;
import org.gvsig.fmap.geom.jts.primitive.surface.ellipse.Ellipse2DZM;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.jts.util.UtilFunctions;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Ring;
import org.gvsig.tools.exception.BaseException;

public abstract class AbstractEllipse
extends AbstractSurface {
    private static final long serialVersionUID = -4218931408628745830L;
    protected Point init;
    protected Point end;
    protected double ydist;

    protected AbstractEllipse(int type, int subtype) {
        super(type, subtype);
    }

    public Geometry force2D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Ellipse2D other = new Ellipse2D();
        other.setPoints(this.init.force2D(), this.end.force2D(), this.ydist);
        other.setProjection(this.getProjection());
        return other;
    }

    @Override
    public Geometry force2DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Ellipse2DM other = new Ellipse2DM();
        other.setProjection(this.getProjection());
        other.setPoints(this.init.force2DM(), this.end.force2DM(), this.ydist);
        return other;
    }

    @Override
    public Geometry force3D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Ellipse2DZ other = new Ellipse2DZ();
        other.setProjection(this.getProjection());
        other.setPoints(this.init.force3D(), this.end.force3D(), this.ydist);
        return other;
    }

    @Override
    public Geometry force3DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Ellipse2DZM other = new Ellipse2DZM();
        other.setProjection(this.getProjection());
        other.setPoints(this.init.force3DM(), this.end.force3DM(), this.ydist);
        return other;
    }

    public int getNumInteriorRings() {
        String message = "Calling deprecated method getInteriorRing of a ellipse";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public Ring getInteriorRing(int index) {
        String message = "Calling deprecated method getInteriorRing of a ellipse";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void addInteriorRing(Ring ring) {
        String message = "Calling unsupported method addInteriorRing of a ellipse";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void addInteriorRing(Line ring) {
        String message = "Calling unsupported method addInteriorRing of a ellipse";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void addInteriorRing(Polygon polygon) {
        String message = "Calling unsupported method addInteriorRing of a ellipse";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void removeInteriorRing(int index) {
        String message = "Calling unsupported method removeInteriorRing of a ellipse";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public List<Ring> getInteriorRings() {
        String message = "Calling method getInteriorRings of a ellipse";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public double getCoordinateAt(int index, int dimension) {
        String message = "Calling deprecated method getCoordinateAt of a ellipse";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive setCoordinateAt(int index, int dimension, double value) {
        String message = "Calling deprecated method setCoordinateAt of a ellipse";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive addVertex(Point point) {
        String message = "Calling deprecated method addVertex of a ellipse";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive addVertex(double x, double y) {
        String message = "Calling deprecated method addVertex of a ellipse";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive addVertex(double x, double y, double z) {
        String message = "Calling deprecated method addVertex of a ellipse";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void removeVertex(int index) {
        String message = "Calling deprecated method removeVertex of a ellipse";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public Point getVertex(int index) {
        String message = "Calling deprecated method getVertex of a ellipse";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public int getNumVertices() {
        String message = "Calling deprecated method getNumVertices of a ellipse";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive insertVertex(int index, Point p) {
        String message = "Calling deprecated method insertVertex of a ellipse";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive setVertex(int index, Point p) {
        String message = "Calling deprecated method setVertex of a ellipse";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void setGeneralPath(GeneralPathX generalPathX) {
        String message = "Calling deprecated method setGeneralPath of a ellipse";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void addMoveToVertex(Point point) {
        String message = "Calling deprecated method addMoveToVertex of a ellipse";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void closePrimitive() {
        String message = "Calling deprecated method closePrimitive of a ellipse";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive ensureCapacity(int capacity) {
        String message = "Calling deprecated method ensureCapacity of a ellipse";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void reProject(ICoordTrans ct) {
        Point2D aux = new Point2D(this.getProjection(), JTSUtils.getPointAtYAxisInEllipse(this.init, this.end, this.ydist));
        try {
            this.init.reProject(ct);
            this.end.reProject(ct);
            aux.reProject(ct);
            this.setProjection(ct.getPDest());
        }
        catch (CoordTransRuntimeException e) {
            this.init.setX(0.0);
            this.init.setY(0.0);
            this.end.setX(0.0);
            this.end.setY(0.0);
            this.ydist = 0.0;
        }
        try {
            Point2D transformedMiddlePoint = new Point2D(this.getProjection(), JTSUtils.getMidPoint(this.init, this.end));
            this.ydist = transformedMiddlePoint.distance(aux);
        }
        catch (BaseException e) {
            throw new UnsupportedOperationException("Error calculating the radius of the transformed circle.", e);
        }
    }

    public void transform(AffineTransform at) {
        Point2D aux = new Point2D(this.getProjection(), JTSUtils.getPointAtYAxisInEllipse(this.init, this.end, this.ydist));
        this.init.transform(at);
        this.end.transform(at);
        aux.transform(at);
        try {
            Point2D transformedMiddlePoint = new Point2D(this.getProjection(), JTSUtils.getMidPoint(this.init, this.end));
            this.ydist = transformedMiddlePoint.distance(aux);
        }
        catch (BaseException e) {
            throw new UnsupportedOperationException("Error calculating the minor semi-axis of the transformed ellipse.", e);
        }
    }

    public int getDimension() {
        return this.init.getDimension();
    }

    public Shape getShape(AffineTransform affineTransform) {
        return new DefaultGeneralPathX(this.getPathIterator(affineTransform), false, 0.0);
    }

    public Shape getShape() {
        return this.getShape(null);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return this.getPathIterator(at, this.getManager().getFlatness());
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        Point2D.Double p1 = new Point2D.Double(this.init.getX(), this.init.getY());
        Point2D.Double p2 = new Point2D.Double(this.end.getX(), this.end.getY());
        Shape ellipse = UtilFunctions.createEllipse(p1, p2, this.ydist);
        return ellipse.getPathIterator(at, flatness);
    }

    public GeneralPathX getGeneralPath() {
        DefaultGeneralPathX gp = new DefaultGeneralPathX(this.getPathIterator(null, this.getManager().getFlatness()), this.is3D(), 0.0);
        return gp;
    }

    @Override
    public boolean is3D() {
        return ((PointJTS)this.init).is3D();
    }

    protected abstract Point fixPoint(Point var1);

    public void setPoints(Point axis1Start, Point axis1End, double axis2Length) {
        this.init = this.fixPoint(axis1Start);
        this.end = this.fixPoint(axis1End);
        this.ydist = axis2Length;
    }

    public Point getAxis1Start() {
        return this.init;
    }

    public Point getAxis1End() {
        return this.end;
    }

    public double getAxis2Dist() {
        return this.ydist;
    }

    public void flip() throws GeometryOperationNotSupportedException, GeometryOperationException {
    }

    protected double getAxis1Angle() throws GeometryOperationNotSupportedException, GeometryOperationException {
        double angle = Math.acos((this.end.getX() - this.init.getX()) / this.init.distance((Geometry)this.end));
        if (this.init.getY() > this.end.getY()) {
            angle = -angle;
        }
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    public boolean canBeTransformed(AffineTransform at) {
        return false;
    }

    public boolean canBeReprojected(ICoordTrans ct) {
        return false;
    }

    public Geometry offset(int joinStyle, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return this.offset(distance);
    }

    @Override
    public boolean isEmpty() {
        return this.init == null || this.end == null;
    }
}

