/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.surface.ellipticarc;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.geom.PathIterator;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine3D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint3D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon3D;
import org.gvsig.fmap.geom.jts.mgeom.MCoordinate;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line3D;
import org.gvsig.fmap.geom.jts.primitive.point.Point3D;
import org.gvsig.fmap.geom.jts.primitive.point.Point3DM;
import org.gvsig.fmap.geom.jts.primitive.surface.ellipticarc.AbstractEllipticArc;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon3D;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.primitive.Point;

public abstract class BaseEllipticArc2DZM
extends AbstractEllipticArc {
    private double zValue = Double.NaN;
    private double mValue = Double.NaN;

    public BaseEllipticArc2DZM(int type) {
        super(type, 3);
    }

    @Override
    protected Point fixPoint(Point point) {
        if (point instanceof Point3DM) {
            Point3DM point3DM = (Point3DM)point;
            if (Double.isNaN(this.zValue) && !Double.isNaN(point3DM.getZ())) {
                this.zValue = point3DM.getZ();
                if (this.axis1Start != null) {
                    ((Point3DM)this.axis1Start).setZ(this.zValue);
                }
                if (this.axis1End != null) {
                    ((Point3DM)this.axis1End).setZ(this.zValue);
                }
            }
            if (Double.isNaN(this.mValue) && !Double.isNaN(point3DM.getM())) {
                this.mValue = point3DM.getM();
                if (this.axis1Start != null) {
                    ((Point3DM)this.axis1Start).setM(this.mValue);
                }
                if (this.axis1End != null) {
                    ((Point3DM)this.axis1End).setM(this.mValue);
                }
            }
        }
        return new Point3DM(point.getX(), point.getY(), Double.isNaN(this.zValue) ? 0.0 : this.zValue, Double.isNaN(this.mValue) ? 0.0 : this.mValue);
    }

    protected ArrayListCoordinateSequence getJTSCoordinates() {
        PathIterator pi = this.getPathIterator(null);
        ArrayListCoordinateSequence coordinates = new ArrayListCoordinateSequence();
        double[] coords = new double[6];
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    coordinates.add(new MCoordinate(coords[0], coords[1], this.zValue, this.mValue));
                    break;
                }
                case 1: {
                    coordinates.add(new MCoordinate(coords[0], coords[1], this.zValue, this.mValue));
                    break;
                }
                case 2: {
                    coordinates.add(new MCoordinate(coords[0], coords[1], this.zValue, this.mValue));
                    coordinates.add(new MCoordinate(coords[2], coords[3], this.zValue, this.mValue));
                    break;
                }
                case 3: {
                    coordinates.add(new MCoordinate(coords[0], coords[1], this.zValue, this.mValue));
                    coordinates.add(new MCoordinate(coords[2], coords[3], this.zValue, this.mValue));
                    coordinates.add(new MCoordinate(coords[4], coords[5], this.zValue, this.mValue));
                    break;
                }
                case 4: {
                    coordinates.add((Coordinate)((Coordinate)coordinates.get(0)).clone());
                }
            }
            pi.next();
        }
        return coordinates;
    }

    public MultiPoint toPoints() throws GeometryException {
        MultiPoint3D multiPoint = new MultiPoint3D();
        Coordinate[] coordinates = this.getJTS().getCoordinates();
        multiPoint.ensureCapacity(coordinates.length);
        for (int i = 0; i < coordinates.length; ++i) {
            multiPoint.addPoint(new Point3D(this.getProjection(), coordinates[i]));
        }
        return multiPoint;
    }

    public MultiLine toLines() throws GeometryException {
        MultiLine3D multiLine = new MultiLine3D();
        Line3D line = new Line3D(this.getJTS().getCoordinates());
        multiLine.addPrimitive(line);
        return multiLine;
    }

    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon3D multiPolygon = new MultiPolygon3D();
        Polygon3D polygon = new Polygon3D(this.getJTS().getCoordinates());
        multiPolygon.addPrimitive(polygon);
        return multiPolygon;
    }
}

