/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.surface.filledspline;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.List;
import org.cresques.cts.ICoordTrans;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.jts.mgeom.MCoordinate;
import org.gvsig.fmap.geom.jts.primitive.curve.spline.BaseSpline2DM;
import org.gvsig.fmap.geom.jts.primitive.surface.filledspline.FilledSpline2D;
import org.gvsig.fmap.geom.jts.primitive.surface.filledspline.FilledSpline3D;
import org.gvsig.fmap.geom.jts.primitive.surface.filledspline.FilledSpline3DM;
import org.gvsig.fmap.geom.jts.primitive.surface.split.SurfaceSplitOperation;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.FilledSpline;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Ring;
import org.gvsig.fmap.geom.primitive.SurfaceAppearance;

public class FilledSpline2DM
extends BaseSpline2DM
implements FilledSpline {
    private static final long serialVersionUID = 5991348858703093647L;

    public FilledSpline2DM() {
        super(25);
    }

    public FilledSpline2DM(Coordinate[] coordinates) {
        super(25, coordinates);
        this.closePrimitive();
    }

    public FilledSpline2DM(ArrayListCoordinateSequence coordinates) {
        super(25, coordinates);
        this.closePrimitive();
    }

    public void setSurfaceAppearance(SurfaceAppearance app) {
    }

    public SurfaceAppearance getSurfaceAppearance() {
        return null;
    }

    public int getNumInteriorRings() {
        String message = "Calling deprecated method getNumInteriorRings of a filled spline";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public Ring getInteriorRing(int index) {
        String message = "Calling deprecated method getInteriorRing of a filled spline";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void addInteriorRing(Ring ring) {
        String message = "Calling deprecated method addInteriorRing of a filled spline";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void addInteriorRing(Line line) {
        String message = "Calling deprecated method addInteriorRing of a filled spline";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void addInteriorRing(Polygon polygon) {
        String message = "Calling deprecated method addInteriorRing of a filled spline";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void removeInteriorRing(int index) {
        String message = "Calling deprecated method removeInteriorRing of a filled spline";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public List<Ring> getInteriorRings() {
        String message = "Calling method getInteriorRings of a filled spline";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public Geometry cloneGeometry() {
        FilledSpline2DM clone = new FilledSpline2DM(this.cloneCoordinates().toCoordinateArray());
        clone.setProjection(this.getProjection());
        return clone;
    }

    @Override
    public com.vividsolutions.jts.geom.Geometry getJTS() {
        return JTSUtils.createJTSPolygon(this.getProjection(), this.getSplineCoordinates());
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return JTSUtils.createGeometry(this.getProjection(), this.getJTS().buffer(distance));
    }

    public Geometry offset(int jointStyle, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return JTSUtils.createGeometry(this.getProjection(), this.getJTS().buffer(distance, JTSUtils.calculateQuadrantSegments(jointStyle)));
    }

    @Override
    public void reProject(ICoordTrans ct) {
        super.reProject(ct);
        if (this.coordinates.size() >= 2 && !this.isClosed()) {
            this.closePrimitive();
        }
    }

    @Override
    public boolean equals(Object obj) {
        boolean res = super.equals(obj);
        if (res && obj instanceof FilledSpline2DM) {
            FilledSpline2DM other = (FilledSpline2DM)obj;
            if (this.getNumVertices() != other.getNumVertices()) {
                return false;
            }
            for (int i = 0; i < this.getNumVertices(); ++i) {
                if (((Coordinate)other.coordinates.get(i)).getOrdinate(2) == ((Coordinate)this.coordinates.get(i)).getOrdinate(2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Geometry split(Geometry splitter) {
        SurfaceSplitOperation op = new SurfaceSplitOperation();
        return op.split(this, splitter);
    }

    @Override
    public Geometry force2D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates2D = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates2D.add(new Coordinate(coordinate.x, coordinate.y));
        }
        FilledSpline2D s = new FilledSpline2D(coordinates2D);
        s.setProjection(this.getProjection());
        return s;
    }

    @Override
    public Geometry force2DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Geometry geom = this.cloneGeometry();
        return geom;
    }

    @Override
    public Geometry force3D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates3D = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates3D.add(new Coordinate(coordinate.x, coordinate.y, 0.0));
        }
        FilledSpline3D s = new FilledSpline3D(coordinates3D);
        s.setProjection(this.getProjection());
        return s;
    }

    @Override
    public Geometry force3DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates3DM = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates3DM.add(MCoordinate.create3dWithMeasure(coordinate.x, coordinate.y, 0.0, coordinate.getOrdinate(3)));
        }
        FilledSpline3DM s = new FilledSpline3DM(coordinates3DM);
        s.setProjection(this.getProjection());
        return s;
    }
}

