/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.surface.polygon;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.List;
import org.cresques.cts.ICoordTrans;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.GeometryJTS;
import org.gvsig.fmap.geom.jts.GeometryJTS2;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine2D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon2D;
import org.gvsig.fmap.geom.jts.mgeom.MCoordinate;
import org.gvsig.fmap.geom.jts.primitive.curve.line.BaseLine2D;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line2D;
import org.gvsig.fmap.geom.jts.primitive.point.Point2D;
import org.gvsig.fmap.geom.jts.primitive.ring.Ring2D;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon2DM;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon3D;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon3DM;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.PolygonHelper;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.PolygonIterator;
import org.gvsig.fmap.geom.jts.primitive.surface.split.SurfaceSplitOperation;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.jts.util.JTSUtils2;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Ring;
import org.gvsig.fmap.geom.primitive.SurfaceAppearance;

public class Polygon2D
extends BaseLine2D
implements Polygon,
GeometryJTS2 {
    private static final long serialVersionUID = 4927309852756014929L;
    List<Ring> interiorRings = new ArrayList<Ring>();

    public Polygon2D() {
        super(19);
    }

    public Polygon2D(Coordinate[] coordinates) {
        super(19, coordinates);
        this.closePrimitive();
    }

    public Polygon2D(ArrayListCoordinateSequence coordinates) {
        super(19, coordinates);
        this.closePrimitive();
    }

    public Polygon cloneGeometry() {
        Polygon2D cloned = new Polygon2D(this.cloneCoordinates().toCoordinateArray());
        for (int i = 0; i < this.getNumInteriorRings(); ++i) {
            cloned.addInteriorRing((Ring)this.getInteriorRing(i).cloneGeometry());
        }
        cloned.setProjection(this.getProjection());
        return cloned;
    }

    @Override
    public Geometry force2D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates2D = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates2D.add(new Coordinate(coordinate.x, coordinate.y));
        }
        Polygon2D poligon2D = new Polygon2D(coordinates2D);
        poligon2D.setProjection(this.getProjection());
        for (int i = 0; i < this.getNumInteriorRings(); ++i) {
            poligon2D.addInteriorRing((Ring)this.getInteriorRing(i).force2D());
        }
        return poligon2D;
    }

    @Override
    public Geometry force2DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates2DM = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates2DM.add(MCoordinate.create2dWithMeasure(coordinate.x, coordinate.y, 0.0));
        }
        Polygon2DM poligon2DM = new Polygon2DM(coordinates2DM);
        poligon2DM.setProjection(this.getProjection());
        for (int i = 0; i < this.getNumInteriorRings(); ++i) {
            poligon2DM.addInteriorRing((Ring)this.getInteriorRing(i).force2DM());
        }
        return poligon2DM;
    }

    @Override
    public Geometry force3D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates3D = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates3D.add(new Coordinate(coordinate.x, coordinate.y, 0.0));
        }
        Polygon3D poligon3D = new Polygon3D(coordinates3D);
        poligon3D.setProjection(this.getProjection());
        for (int i = 0; i < this.getNumInteriorRings(); ++i) {
            poligon3D.addInteriorRing((Ring)this.getInteriorRing(i).force3D());
        }
        return poligon3D;
    }

    @Override
    public Geometry force3DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates3DM = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates3DM.add(MCoordinate.create3dWithMeasure(coordinate.x, coordinate.y, 0.0, 0.0));
        }
        Polygon3DM poligon3DM = new Polygon3DM(coordinates3DM);
        poligon3DM.setProjection(this.getProjection());
        for (int i = 0; i < this.getNumInteriorRings(); ++i) {
            poligon3DM.addInteriorRing((Ring)this.getInteriorRing(i).force3DM());
        }
        return poligon3DM;
    }

    public Polygon clone() throws CloneNotSupportedException {
        return this.cloneGeometry();
    }

    public void setSurfaceAppearance(SurfaceAppearance app) {
    }

    public SurfaceAppearance getSurfaceAppearance() {
        return null;
    }

    public int getNumInteriorRings() {
        return this.interiorRings.size();
    }

    public Ring getInteriorRing(int index) {
        return this.interiorRings.get(index);
    }

    public void addInteriorRing(Ring ring) {
        this.interiorRings.add(ring);
    }

    public void addInteriorRing(Line line) {
        Ring2D ring = new Ring2D();
        ring.ensureCapacity(line.getNumVertices());
        for (int i = 0; i < line.getNumVertices(); ++i) {
            Point vertex = line.getVertex(i);
            ring.addVertex(new Point2D(vertex.getX(), vertex.getY()));
        }
        ring.closePrimitive();
        this.interiorRings.add(ring);
    }

    public void addInteriorRing(Polygon polygon) {
        Ring2D ring = new Ring2D();
        ring.ensureCapacity(polygon.getNumVertices());
        for (int i = 0; i < polygon.getNumVertices(); ++i) {
            Point vertex = polygon.getVertex(i);
            ring.addVertex(new Point2D(vertex.getX(), vertex.getY()));
        }
        ring.closePrimitive();
        this.interiorRings.add(ring);
    }

    public void removeInteriorRing(int index) {
        this.interiorRings.remove(index);
    }

    public List<Ring> getInteriorRings() {
        return this.interiorRings;
    }

    @Override
    public MultiLine toLines() throws GeometryException {
        MultiLine2D multiLine = new MultiLine2D();
        multiLine.addPrimitive(new Line2D(this.coordinates.toCoordinateArray()));
        return multiLine;
    }

    @Override
    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon2D multiPolygon = new MultiPolygon2D();
        multiPolygon.addPrimitive(this);
        return multiPolygon;
    }

    @Override
    public com.vividsolutions.jts.geom.Geometry getJTS() {
        return JTSUtils.createJTSPolygon(this.getProjection(), this.coordinates, this.interiorRings);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        PolygonIterator pi = new PolygonIterator(this, at);
        return pi;
    }

    @Override
    public boolean ensureOrientation(boolean ccw) throws GeometryOperationNotSupportedException, GeometryOperationException {
        boolean result = super.ensureOrientation(ccw);
        for (GeometryJTS geometryJTS : this.interiorRings) {
            geometryJTS.ensureOrientation(!ccw);
        }
        return result;
    }

    @Override
    public void flip() throws GeometryOperationNotSupportedException, GeometryOperationException {
        super.flip();
        for (GeometryJTS geometryJTS : this.interiorRings) {
            geometryJTS.flip();
        }
    }

    @Override
    public void transform(AffineTransform at) {
        super.transform(at);
        for (GeometryJTS geometryJTS : this.interiorRings) {
            geometryJTS.transform(at);
        }
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return JTSUtils.createGeometry(this.getProjection(), this.getJTS().buffer(distance));
    }

    public Geometry offset(int joinStyle, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return JTSUtils.createGeometry(this.getProjection(), this.getJTS().buffer(distance, JTSUtils.calculateQuadrantSegments(joinStyle)));
    }

    @Override
    public void reProject(ICoordTrans ct) {
        super.reProject(ct);
        for (GeometryJTS geometryJTS : this.interiorRings) {
            geometryJTS.reProject(ct);
        }
        if (this.coordinates.size() >= 2 && !this.isClosed()) {
            this.closePrimitive();
        }
    }

    @Override
    public Shape getShape(AffineTransform affineTransform) {
        return PolygonHelper.getShape(this, affineTransform);
    }

    public Geometry split(Geometry splitter) {
        SurfaceSplitOperation op = new SurfaceSplitOperation();
        return op.split(this, splitter);
    }

    public Ring createRing() {
        return new Ring2D();
    }

    public Ring getExteriorRing() {
        Polygon2D p = new Polygon2D(this.coordinates);
        p.setProjectionIffNull(this.getProjection());
        return p;
    }

    @Override
    public org.locationtech.jts.geom.Geometry getJTS2() {
        return JTSUtils2.createJTSPolygon(this.getProjection(), this.coordinates, this.interiorRings);
    }

    public Geometry validateCoverage(Geometry[] geoms, double gapWidth) {
        return PolygonHelper.validateCoverage(this, geoms, gapWidth);
    }

    public Geometry findGaps(double gapWidth) {
        return PolygonHelper.findGaps(this, gapWidth);
    }
}

