/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.surface.split;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.jts.primitive.surface.split.SplitEdge;
import org.gvsig.fmap.geom.jts.primitive.surface.split.SplitEdgeStar;
import org.gvsig.fmap.geom.jts.primitive.surface.split.SplitGraph;
import org.gvsig.fmap.geom.jts.primitive.surface.split.SplitGraphNode;
import org.gvsig.fmap.geom.operation.GeometryOperationContext;

public class SurfaceSplitOperation {
    public Geometry split(Geometry geometryToBeSplitted, Geometry splitter) {
        try {
            com.vividsolutions.jts.geom.Geometry jtsGeom = (com.vividsolutions.jts.geom.Geometry)geometryToBeSplitted.invokeOperation("toJTS", null);
            com.vividsolutions.jts.geom.Geometry jtsSplitter = (com.vividsolutions.jts.geom.Geometry)splitter.invokeOperation("toJTS", null);
            if (jtsSplitter instanceof MultiLineString && jtsSplitter.getNumGeometries() == 1) {
                jtsSplitter = jtsSplitter.getGeometryN(0);
            }
            com.vividsolutions.jts.geom.Geometry result = null;
            if (jtsSplitter instanceof LineString) {
                if (jtsGeom instanceof Polygon) {
                    result = this.splitPolygon(jtsGeom, jtsSplitter);
                } else if (jtsGeom instanceof MultiPolygon) {
                    result = this.splitMultiPolygon((MultiPolygon)jtsGeom, jtsSplitter);
                }
            }
            if (result != null) {
                GeometryManager manager = GeometryLocator.getGeometryManager();
                GeometryOperationContext params = new GeometryOperationContext();
                params.setAttribute("JTSGeometry", (Object)result);
                return (Geometry)manager.invokeOperation("fromJTS", params);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return null;
    }

    private com.vividsolutions.jts.geom.Geometry splitMultiPolygon(MultiPolygon jtsMultiPoligon, com.vividsolutions.jts.geom.Geometry jtsSplitter) {
        com.vividsolutions.jts.geom.Geometry result;
        GeometryFactory gf = jtsMultiPoligon.getFactory();
        ArrayList<com.vividsolutions.jts.geom.Geometry> splittedGeometries = new ArrayList<com.vividsolutions.jts.geom.Geometry>();
        for (int i = 0; i < jtsMultiPoligon.getNumGeometries(); ++i) {
            com.vividsolutions.jts.geom.Geometry jtsGeom = jtsMultiPoligon.getGeometryN(i);
            com.vividsolutions.jts.geom.Geometry splittedGeometry = jtsGeom instanceof MultiPolygon ? this.splitMultiPolygon((MultiPolygon)jtsGeom, jtsSplitter) : this.splitPolygon(jtsGeom, jtsSplitter);
            if (splittedGeometry instanceof MultiPolygon) {
                for (int j = 0; j < ((MultiPolygon)splittedGeometry).getNumGeometries(); ++j) {
                    splittedGeometries.add(((MultiPolygon)splittedGeometry).getGeometryN(j));
                }
                continue;
            }
            splittedGeometries.add(splittedGeometry);
        }
        if (splittedGeometries.size() == 1) {
            result = (com.vividsolutions.jts.geom.Geometry)splittedGeometries.get(0);
        } else {
            Polygon[] array = splittedGeometries.toArray(new Polygon[splittedGeometries.size()]);
            result = gf.createMultiPolygon(array);
        }
        return result;
    }

    private com.vividsolutions.jts.geom.Geometry splitPolygon(com.vividsolutions.jts.geom.Geometry jtsGeom, com.vividsolutions.jts.geom.Geometry jtsSplitter) {
        com.vividsolutions.jts.geom.Geometry result;
        SplitGraph graph = new SplitGraph((Polygon)jtsGeom, (LineString)jtsSplitter);
        GeometryFactory gf = jtsGeom.getFactory();
        List<LinearRing> unsplittedHoles = this.findUnsplittedHoles(graph, gf);
        List<List<SplitEdge>> allRings = this.findRings(graph);
        List<Polygon> resultingPolygons = this.buildSimplePolygons(allRings, unsplittedHoles, gf);
        if (resultingPolygons.size() == 1) {
            result = (com.vividsolutions.jts.geom.Geometry)resultingPolygons.get(0);
        } else {
            Polygon[] array = resultingPolygons.toArray(new Polygon[resultingPolygons.size()]);
            result = gf.createMultiPolygon(array);
        }
        return result;
    }

    private List<LinearRing> findUnsplittedHoles(SplitGraph graph, GeometryFactory gf) {
        ArrayList<LinearRing> unsplittedHoles = new ArrayList<LinearRing>(2);
        ArrayList<SplitEdge> edges = new ArrayList<SplitEdge>();
        Iterator it = graph.getEdgeIterator();
        while (it.hasNext()) {
            SplitEdge edge = (SplitEdge)((Object)it.next());
            edges.add(edge);
        }
        for (SplitEdge edge : edges) {
            Coordinate end;
            Coordinate[] coordinates;
            Coordinate start;
            boolean isLinearRing;
            if (!edge.isHoleEdge() || !(isLinearRing = (start = (coordinates = edge.getCoordinates())[0]).equals2D(end = coordinates[coordinates.length - 1]))) continue;
            graph.remove(edge);
            LinearRing ring = gf.createLinearRing(coordinates);
            unsplittedHoles.add(ring);
        }
        return unsplittedHoles;
    }

    private List<List<SplitEdge>> findRings(SplitGraph graph) {
        DirectedEdge startEdge;
        ArrayList<List<SplitEdge>> rings = new ArrayList<List<SplitEdge>>();
        while ((startEdge = this.findShellEdge(graph)) != null) {
            List<SplitEdge> ring = this.buildRing(graph, startEdge);
            rings.add(ring);
        }
        return rings;
    }

    private DirectedEdge findShellEdge(SplitGraph graph) {
        Iterator it = graph.getEdgeEnds().iterator();
        DirectedEdge firstShellEdge = null;
        while (it.hasNext()) {
            DirectedEdge de = (DirectedEdge)it.next();
            SplitEdge edge = (SplitEdge)de.getEdge();
            if (!edge.isShellEdge()) continue;
            firstShellEdge = de;
            break;
        }
        return firstShellEdge;
    }

    private List<SplitEdge> buildRing(SplitGraph graph, DirectedEdge startEdge) {
        ArrayList<SplitEdge> ring = new ArrayList<SplitEdge>();
        boolean direction = true;
        DirectedEdge currentDirectedEdge = startEdge;
        DirectedEdge nextDirectedEdge = null;
        while (nextDirectedEdge != startEdge) {
            SplitEdge edge = (SplitEdge)currentDirectedEdge.getEdge();
            if (ring.contains((Object)edge)) {
                throw new IllegalStateException("trying to add edge twice: " + (Object)((Object)edge));
            }
            ring.add(edge);
            DirectedEdge sym = currentDirectedEdge.getSym();
            SplitGraphNode endNode = (SplitGraphNode)sym.getNode();
            SplitEdgeStar nodeEdges = (SplitEdgeStar)endNode.getEdges();
            nextDirectedEdge = nodeEdges.findClosestEdgeInDirection(sym, 1);
            assert (nextDirectedEdge != null);
            currentDirectedEdge = nextDirectedEdge;
        }
        this.removeUnneededEdges(graph, ring);
        return ring;
    }

    private void removeUnneededEdges(SplitGraph graph, List<SplitEdge> ring) {
        for (SplitEdge edge : ring) {
            if (edge.isInteriorEdge()) continue;
            graph.remove(edge);
        }
        for (SplitEdge edge : ring) {
            Node node;
            int degree;
            if (!edge.isInteriorEdge() || (degree = (node = graph.find(edge.getCoordinate())).getEdges().getDegree()) >= 2) continue;
            graph.remove(edge);
        }
    }

    private List<Polygon> buildSimplePolygons(List<List<SplitEdge>> allRings, List<LinearRing> unsplittedHoles, GeometryFactory gf) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(allRings.size());
        for (List<SplitEdge> edgeList : allRings) {
            Polygon poly = this.buildPolygon(edgeList, gf);
            ArrayList<LinearRing> thisPolyHoles = new ArrayList<LinearRing>(unsplittedHoles.size());
            for (LinearRing holeRing : unsplittedHoles) {
                if (!poly.covers((com.vividsolutions.jts.geom.Geometry)holeRing)) continue;
                thisPolyHoles.add(holeRing);
            }
            unsplittedHoles.removeAll(thisPolyHoles);
            int numHoles = thisPolyHoles.size();
            if (numHoles > 0) {
                LinearRing[] holes = thisPolyHoles.toArray(new LinearRing[numHoles]);
                LinearRing shell = gf.createLinearRing(poly.getExteriorRing().getCoordinates());
                poly = gf.createPolygon(shell, holes);
            }
            polygons.add(poly);
        }
        return polygons;
    }

    private Polygon buildPolygon(List<SplitEdge> edgeList, GeometryFactory gf) {
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        Coordinate[] lastCoordinates = null;
        for (SplitEdge edge : edgeList) {
            Coordinate startPoint;
            Coordinate endPoint;
            Coordinate[] coordinates = edge.getCoordinates();
            if (lastCoordinates != null && !(endPoint = lastCoordinates[lastCoordinates.length - 1]).equals2D(startPoint = coordinates[0])) {
                coordinates = CoordinateArrays.copyDeep((Coordinate[])coordinates);
                CoordinateArrays.reverse((Coordinate[])coordinates);
            }
            lastCoordinates = coordinates;
            coords.addAll(Arrays.asList(coordinates));
        }
        Coordinate[] shellCoords = new Coordinate[coords.size()];
        coords.toArray(shellCoords);
        shellCoords = CoordinateArrays.removeRepeatedPoints((Coordinate[])shellCoords);
        LinearRing shell = gf.createLinearRing(shellCoords);
        Polygon poly = gf.createPolygon(shell, (LinearRing[])null);
        return poly;
    }
}

