/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.transform;

import java.awt.geom.AffineTransform;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.jts.transform.EqualUtils;
import org.gvsig.fmap.geom.jts.transform.NonInvertibleTransformException;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.transform.Transform;

public class Transform2D
implements Transform {
    public static final double ACCURACY = 1.0E-12;
    protected double m00;
    protected double m01;
    protected double m02;
    protected double m10;
    protected double m11;
    protected double m12;

    public Transform2D() {
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m10 = 0.0;
        this.m01 = 0.0;
        this.m12 = 0.0;
        this.m02 = 0.0;
    }

    public Transform2D(AffineTransform transform) {
        double[] coefs = new double[6];
        transform.getMatrix(coefs);
        this.m00 = coefs[0];
        this.m10 = coefs[1];
        this.m01 = coefs[2];
        this.m11 = coefs[3];
        this.m02 = coefs[4];
        this.m12 = coefs[5];
    }

    public Transform2D(double[] coefs) {
        if (coefs.length == 4) {
            this.m00 = coefs[0];
            this.m01 = coefs[1];
            this.m10 = coefs[2];
            this.m11 = coefs[3];
        } else {
            this.m00 = coefs[0];
            this.m01 = coefs[1];
            this.m02 = coefs[2];
            this.m10 = coefs[3];
            this.m11 = coefs[4];
            this.m12 = coefs[5];
        }
    }

    public Transform2D(double xx, double yx, double tx, double xy, double yy, double ty) {
        this.m00 = xx;
        this.m01 = yx;
        this.m02 = tx;
        this.m10 = xy;
        this.m11 = yy;
        this.m12 = ty;
    }

    public double[] coefficients() {
        double[] tab = new double[]{this.m00, this.m01, this.m02, this.m10, this.m11, this.m12};
        return tab;
    }

    public double[][] affineMatrix() {
        double[][] tab = new double[][]{{this.m00, this.m01, this.m02}, {this.m10, this.m11, this.m12}, {0.0, 0.0, 1.0}};
        return tab;
    }

    public AffineTransform asAwtTransform() {
        return new AffineTransform(this.m00, this.m10, this.m01, this.m11, this.m02, this.m12);
    }

    public Transform concatenate(Transform other) {
        if (!(other instanceof Transform2D)) {
            throw new IllegalArgumentException("Can't concatenate an AffineTransform2D with a non AffineTransform2D (other " + other.toString() + ")");
        }
        Transform2D that = (Transform2D)other;
        double n00 = this.m00 * that.m00 + this.m01 * that.m10;
        double n01 = this.m00 * that.m01 + this.m01 * that.m11;
        double n02 = this.m00 * that.m02 + this.m01 * that.m12 + this.m02;
        double n10 = this.m10 * that.m00 + this.m11 * that.m10;
        double n11 = this.m10 * that.m01 + this.m11 * that.m11;
        double n12 = this.m10 * that.m02 + this.m11 * that.m12 + this.m12;
        return new Transform2D(n00, n01, n02, n10, n11, n12);
    }

    public Transform chain(Transform other) {
        if (!(other instanceof Transform2D)) {
            throw new IllegalArgumentException("Can't concatenate an AffineTransform2D with a non AffineTransform2D (other " + other.toString() + ")");
        }
        Transform2D that = (Transform2D)other;
        return new Transform2D(that.m00 * this.m00 + that.m01 * this.m10, that.m00 * this.m01 + that.m01 * this.m11, that.m00 * this.m02 + that.m01 * this.m12 + that.m02, that.m10 * this.m00 + that.m11 * this.m10, that.m10 * this.m01 + that.m11 * this.m11, that.m10 * this.m02 + that.m11 * this.m12 + that.m12);
    }

    public Transform preConcatenate(Transform other) {
        return this.chain(other);
    }

    public boolean isSimilarity() {
        double a = this.m00;
        double b = this.m01;
        double d = this.m11;
        double c = this.m10;
        double k2 = Math.abs(a * d - b * c);
        if (Math.abs(a * a + b * b - k2) > 1.0E-12) {
            return false;
        }
        if (Math.abs(c * c + d * d - k2) > 1.0E-12) {
            return false;
        }
        if (Math.abs(a * a + c * c - k2) > 1.0E-12) {
            return false;
        }
        return !(Math.abs(b * b + d * d - k2) > 1.0E-12);
    }

    public boolean isMotion() {
        return this.isIsometry() && this.isDirect();
    }

    public boolean isIsometry() {
        double a = this.m00;
        double b = this.m01;
        double c = this.m10;
        double d = this.m11;
        if (Math.abs(a * a + b * b - 1.0) > 1.0E-12) {
            return false;
        }
        if (Math.abs(c * c + d * d - 1.0) > 1.0E-12) {
            return false;
        }
        return !(Math.abs(a * b + c * d) > 1.0E-12);
    }

    public boolean isDirect() {
        return this.m00 * this.m11 - this.m01 * this.m10 > 0.0;
    }

    public boolean isIdentity() {
        if (Math.abs(this.m00 - 1.0) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.m01) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.m02) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.m10) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.m11 - 1.0) > 1.0E-12) {
            return false;
        }
        return !(Math.abs(this.m12) > 1.0E-12);
    }

    public Transform inverse() {
        double det = this.m00 * this.m11 - this.m10 * this.m01;
        if (Math.abs(det) < 1.0E-12) {
            throw new NonInvertibleTransformException(this);
        }
        return new Transform2D(this.m11 / det, -this.m01 / det, (this.m01 * this.m12 - this.m02 * this.m11) / det, -this.m10 / det, this.m00 / det, (this.m02 * this.m10 - this.m00 * this.m12) / det);
    }

    private Point createPoint2D(double x, double y) {
        try {
            return GeometryLocator.getGeometryManager().createPoint(x, y, 0);
        }
        catch (CreateGeometryException ex) {
            throw new RuntimeException("Can't create Point2D", ex);
        }
    }

    public Point transform(Point p) {
        Point dst = this.createPoint2D(p.getX() * this.m00 + p.getY() * this.m01 + this.m02, p.getX() * this.m10 + p.getY() * this.m11 + this.m12);
        return dst;
    }

    public Point[] transform(Point[] src, Point[] dst) {
        if (dst == null) {
            dst = new Point[src.length];
        }
        for (int i = 0; i < src.length; ++i) {
            double x = src[i].getX();
            double y = src[i].getY();
            dst[i] = this.createPoint2D(x * this.m00 + y * this.m01 + this.m02, x * this.m10 + y * this.m11 + this.m12);
        }
        return dst;
    }

    public String toString() {
        return new String("AffineTransform2D(" + this.m00 + "," + this.m01 + "," + this.m02 + "," + this.m10 + "," + this.m11 + "," + this.m12 + ",");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Transform2D)) {
            return false;
        }
        Transform2D that = (Transform2D)obj;
        if (!EqualUtils.areEqual(this.m00, that.m00)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.m01, that.m01)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.m02, that.m02)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.m00, that.m00)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.m01, that.m01)) {
            return false;
        }
        return EqualUtils.areEqual(this.m02, that.m02);
    }

    public Transform2D clone() {
        return new Transform2D(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12);
    }
}

