/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.core;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class AlgorithmsAndResources {
    private static ArrayList<String> m_ClassNames = new ArrayList();
    private static ArrayList<String> m_PropertiesFiles = new ArrayList();

    public static String[] getAlgorithmClassNames() {
        return m_ClassNames.toArray(new String[m_ClassNames.size()]);
    }

    public static String[] getPropertiesFilenames() {
        return m_PropertiesFiles.toArray(new String[m_PropertiesFiles.size()]);
    }

    public static void addAlgorithm(String sAlgClassName) {
        m_ClassNames.add(sAlgClassName);
    }

    public static void addPropertiesFile(String sName) {
        m_PropertiesFiles.add(sName);
    }

    public static void addAlgorithmsAndPropertiesFromClasspath() {
        StringTokenizer localTokenizer = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator, false);
        while (localTokenizer.hasMoreTokens()) {
            String classpathElement = localTokenizer.nextToken();
            File classpathFile = new File(classpathElement);
            String sFilename = classpathFile.getName();
            if (!classpathFile.exists() || !classpathFile.canRead() || !sFilename.toLowerCase().endsWith(".jar") || !sFilename.toLowerCase().startsWith("org.gvsig.toolbox")) continue;
            AlgorithmsAndResources.addAlgorithmsAndResourcesFromJarFile(classpathElement);
        }
        ClassLoader classloader = AlgorithmsAndResources.class.getClassLoader();
        URL[] webappClasses = new URL[]{};
        if (classloader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classloader;
            webappClasses = urlClassLoader.getURLs();
        }
        AlgorithmsAndResources.addAlgorithmsAndPropertiesFromURLs(webappClasses);
    }

    public static void addAlgorithmsAndPropertiesFromURLs(URL[] urls) {
        for (URL url : urls) {
            File classpathFile = new File(URLDecoder.decode(url.getFile()));
            String sFilename = classpathFile.getName();
            if (!classpathFile.exists() || !classpathFile.canRead() || !sFilename.toLowerCase().endsWith(".jar") || !sFilename.toLowerCase().startsWith("org.gvsig.toolbox")) continue;
            AlgorithmsAndResources.addAlgorithmsAndResourcesFromJarFile(classpathFile.getAbsolutePath());
        }
    }

    public static void addAlgorithmsAndPropertiesFromFolder(String sFolder) {
        File folder = new File(sFolder);
        File[] directoryFiles = folder.listFiles();
        for (int i = 0; i < directoryFiles.length; ++i) {
            String sFilename;
            if (directoryFiles[i].isDirectory() || !(sFilename = directoryFiles[i].getName()).endsWith(".jar") || !sFilename.startsWith("org.gvsig.toolbox")) continue;
            AlgorithmsAndResources.addAlgorithmsAndResourcesFromJarFile(directoryFiles[i].getAbsolutePath());
        }
    }

    private static void addAlgorithmsAndResourcesFromJarFile(String sFilename) {
        try {
            ZipFile zip = new ZipFile(sFilename);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String sName = entry.getName();
                if (entry.isDirectory()) continue;
                if (sName.toLowerCase().endsWith("algorithm.class")) {
                    String sClassName = sName.substring(0, sName.lastIndexOf(46)).replace('/', '.');
                    AlgorithmsAndResources.addAlgorithm(sClassName);
                    continue;
                }
                if (!sName.endsWith(".properties") || sName.indexOf("_") != -1) continue;
                AlgorithmsAndResources.addPropertiesFile(sName.substring(0, sName.lastIndexOf(46)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

