/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.core;

import java.text.SimpleDateFormat;
import java.util.Date;

public class LogElement {
    public static final String ERROR = "ERROR";
    public static final String WARNING = "WARNING";
    public static final String INFO = "INFO";
    private Date date;
    private String text;
    private String type;
    private final String shortText;

    public LogElement(Date date, String text, String type) {
        this.date = date;
        this.text = text;
        this.type = type;
        this.shortText = text;
    }

    public LogElement(Date date, String text, String shortText, String type) {
        this.date = date;
        this.text = text;
        this.type = type;
        this.shortText = shortText;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAsText() {
        SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss");
        String sFormattedDate = formatter.format(this.date);
        return "[" + sFormattedDate + "]-" + this.type + ":\n" + this.text + "\n\n";
    }

    public String toString() {
        SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss");
        String sFormattedDate = formatter.format(this.date);
        return "[" + sFormattedDate + "]-" + this.type + ":" + this.shortText;
    }
}

