/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.core;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.ITaskMonitor;
import es.unex.sextante.dataObjects.I3DRasterLayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import es.unex.sextante.io3d.Default3DRasterLayer;
import es.unex.sextante.outputs.FileOutputChannel;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.Output3DRasterLayer;
import es.unex.sextante.outputs.OutputRasterLayer;
import es.unex.sextante.outputs.OutputTable;
import es.unex.sextante.outputs.OutputVectorLayer;
import java.io.File;
import javax.swing.JDialog;

public abstract class OutputFactory {
    private int m_iCount = 0;
    private double m_dNoDataValue = -99999.0;

    public abstract IVectorLayer getNewVectorLayer(String var1, int var2, Class[] var3, String[] var4, IOutputChannel var5, Object var6) throws UnsupportedOutputChannelException;

    public abstract IVectorLayer getNewVectorLayer(String var1, int var2, Class[] var3, String[] var4, IOutputChannel var5, Object var6, int var7) throws UnsupportedOutputChannelException;

    public abstract IVectorLayer getNewVectorLayer(String var1, int var2, Class[] var3, String[] var4, IOutputChannel var5, Object var6, int[] var7) throws UnsupportedOutputChannelException;

    public abstract IVectorLayer getNewVectorLayer(String var1, int var2, Class[] var3, String[] var4, IOutputChannel var5, Object var6, int[] var7, int var8) throws UnsupportedOutputChannelException;

    public abstract IRasterLayer getNewRasterLayer(String var1, int var2, AnalysisExtent var3, int var4, IOutputChannel var5, Object var6) throws UnsupportedOutputChannelException;

    public I3DRasterLayer getNew3DRasterLayer(String sName, int iDataType, AnalysisExtent extent, IOutputChannel channel, Object crs) throws UnsupportedOutputChannelException {
        if (channel instanceof FileOutputChannel) {
            String sFilename = ((FileOutputChannel)channel).getFilename();
            Default3DRasterLayer layer = new Default3DRasterLayer();
            layer.create(sName, sFilename, extent, crs);
            return layer;
        }
        throw new UnsupportedOutputChannelException();
    }

    public abstract ITable getNewTable(String var1, Class[] var2, String[] var3, IOutputChannel var4) throws UnsupportedOutputChannelException;

    public String getTempVectorLayerFilename() {
        return this.getTempFilenameWithoutExtension() + "." + this.getVectorLayerOutputExtensions()[0];
    }

    public String getTempRasterLayerFilename() {
        return this.getTempFilenameWithoutExtension() + "." + this.getRasterLayerOutputExtensions()[0];
    }

    public String getTemp3DRasterLayerFilename() {
        return this.getTempFilenameWithoutExtension() + "." + this.get3DRasterLayerOutputExtensions()[0];
    }

    public String getTempTableFilename() {
        return this.getTempFilenameWithoutExtension() + "." + this.getTableOutputExtensions()[0];
    }

    public String getTempFoldername() {
        return this.getTempFilenameWithoutExtension();
    }

    public String getTempFilename(Output out) {
        if (out instanceof OutputVectorLayer) {
            return this.getTempVectorLayerFilename();
        }
        if (out instanceof OutputRasterLayer) {
            return this.getTempRasterLayerFilename();
        }
        if (out instanceof OutputTable) {
            return this.getTempTableFilename();
        }
        if (out instanceof Output3DRasterLayer) {
            return this.getTemp3DRasterLayerFilename();
        }
        return null;
    }

    public String getTempFilenameWithoutExtension() {
        return this.getTempFolder() + File.separator + Long.toString(System.currentTimeMillis()) + Integer.toString(this.m_iCount++);
    }

    public abstract String getTempFolder();

    public abstract String[] getRasterLayerOutputExtensions();

    public String[] get3DRasterLayerOutputExtensions() {
        return new String[]{"asc3d"};
    }

    public abstract String[] getVectorLayerOutputExtensions();

    public abstract String[] getTableOutputExtensions();

    public abstract ITaskMonitor getTaskMonitor(String var1, boolean var2, JDialog var3);

    public abstract Object getDefaultCRS();

    public double getDefaultNoDataValue() {
        return this.m_dNoDataValue;
    }

    public void setDefaultNoDataValue(double dValue) {
        this.m_dNoDataValue = dValue;
    }
}

