/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.core;

import es.unex.sextante.additionalInfo.AdditionalInfo3DRasterLayer;
import es.unex.sextante.additionalInfo.AdditionalInfoBand;
import es.unex.sextante.additionalInfo.AdditionalInfoBoolean;
import es.unex.sextante.additionalInfo.AdditionalInfoDataObject;
import es.unex.sextante.additionalInfo.AdditionalInfoFilepath;
import es.unex.sextante.additionalInfo.AdditionalInfoFixedTable;
import es.unex.sextante.additionalInfo.AdditionalInfoMultipleInput;
import es.unex.sextante.additionalInfo.AdditionalInfoNumericalValue;
import es.unex.sextante.additionalInfo.AdditionalInfoPoint;
import es.unex.sextante.additionalInfo.AdditionalInfoRasterLayer;
import es.unex.sextante.additionalInfo.AdditionalInfoSelection;
import es.unex.sextante.additionalInfo.AdditionalInfoString;
import es.unex.sextante.additionalInfo.AdditionalInfoTable;
import es.unex.sextante.additionalInfo.AdditionalInfoTableField;
import es.unex.sextante.additionalInfo.AdditionalInfoTableFilter;
import es.unex.sextante.additionalInfo.AdditionalInfoVectorLayer;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.I3DRasterLayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.exceptions.NullParameterValueException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import es.unex.sextante.exceptions.WrongParameterIDException;
import es.unex.sextante.exceptions.WrongParameterTypeException;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.Parameter3DRasterLayer;
import es.unex.sextante.parameters.ParameterBand;
import es.unex.sextante.parameters.ParameterBoolean;
import es.unex.sextante.parameters.ParameterFilepath;
import es.unex.sextante.parameters.ParameterFixedTable;
import es.unex.sextante.parameters.ParameterMultipleInput;
import es.unex.sextante.parameters.ParameterNumericalValue;
import es.unex.sextante.parameters.ParameterPoint;
import es.unex.sextante.parameters.ParameterRasterLayer;
import es.unex.sextante.parameters.ParameterSelection;
import es.unex.sextante.parameters.ParameterString;
import es.unex.sextante.parameters.ParameterTable;
import es.unex.sextante.parameters.ParameterTableField;
import es.unex.sextante.parameters.ParameterTableFilter;
import es.unex.sextante.parameters.ParameterVectorLayer;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class ParametersSet {
    private final ArrayList m_Parameters = new ArrayList();

    public int getNumberOfParameters() {
        return this.m_Parameters.size();
    }

    public int getNumberOfRasterLayers() {
        return this.getNumberOfRasterLayers(false);
    }

    public int getNumberOfRasterLayers(boolean includeMultipleInputs) {
        int iCount = 0;
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            Parameter parameter = (Parameter)this.m_Parameters.get(i);
            if (parameter.getParameterTypeName().equals("Raster Layer")) {
                ++iCount;
                continue;
            }
            if (!includeMultipleInputs || !(parameter instanceof ParameterMultipleInput)) continue;
            ParameterMultipleInput param = (ParameterMultipleInput)parameter;
            try {
                int ai = ((AdditionalInfoMultipleInput)param.getParameterAdditionalInfo()).getDataType();
                if (ai == 1) {
                    ++iCount;
                    continue;
                }
                if (ai != 7) continue;
                ++iCount;
                continue;
            }
            catch (NullParameterAdditionalInfoException e) {
                e.printStackTrace();
            }
        }
        return iCount;
    }

    public int getNumberOfVectorLayers() {
        return this.getNumberOfVectorLayers(false);
    }

    public int getNumberOfVectorLayers(boolean includeMultiInputs) {
        int iCount = 0;
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            Parameter parameter = (Parameter)this.m_Parameters.get(i);
            if (parameter.getParameterTypeName().equals("Vector Layer")) {
                ++iCount;
                continue;
            }
            if (!includeMultiInputs || !(parameter instanceof ParameterMultipleInput)) continue;
            ParameterMultipleInput param = (ParameterMultipleInput)parameter;
            try {
                int ai = ((AdditionalInfoMultipleInput)param.getParameterAdditionalInfo()).getDataType();
                if (ai != 5 && ai != 3 && ai != 2 && ai != 4) continue;
                ++iCount;
                continue;
            }
            catch (NullParameterAdditionalInfoException e) {
                e.printStackTrace();
            }
        }
        return iCount;
    }

    private int getNumberOfSpecificVectorLayers(int shapeType, int dataType) {
        int iCount = 0;
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            boolean bMandatory;
            if (((Parameter)this.m_Parameters.get(i)).getParameterTypeName().equals("Vector Layer")) {
                try {
                    int iShapeType = ((AdditionalInfoVectorLayer)((Parameter)this.m_Parameters.get(i)).getParameterAdditionalInfo()).getShapeType();
                    bMandatory = ((AdditionalInfoVectorLayer)((Parameter)this.m_Parameters.get(i)).getParameterAdditionalInfo()).getIsMandatory();
                    if (iShapeType != shapeType || !bMandatory) continue;
                    ++iCount;
                }
                catch (NullParameterAdditionalInfoException e) {
                    Sextante.addErrorToLog(e);
                }
                continue;
            }
            if (!((Parameter)this.m_Parameters.get(i)).getParameterTypeName().equals("Multiple Input")) continue;
            try {
                int iDataType = ((AdditionalInfoMultipleInput)((Parameter)this.m_Parameters.get(i)).getParameterAdditionalInfo()).getDataType();
                bMandatory = ((AdditionalInfoMultipleInput)((Parameter)this.m_Parameters.get(i)).getParameterAdditionalInfo()).getIsMandatory();
                if (iDataType != dataType || !bMandatory) continue;
                ++iCount;
                continue;
            }
            catch (NullParameterAdditionalInfoException e) {
                Sextante.addErrorToLog(e);
            }
        }
        return iCount;
    }

    public int getNumberOfPointVectorLayers() {
        return this.getNumberOfSpecificVectorLayers(0, 2);
    }

    public int getNumberOfLineVectorLayers() {
        return this.getNumberOfSpecificVectorLayers(1, 3);
    }

    public int getNumberOfPolygonVectorLayers() {
        return this.getNumberOfSpecificVectorLayers(2, 4);
    }

    public int getNumberOfTables() {
        int iCount = 0;
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            if (!((Parameter)this.m_Parameters.get(i)).getParameterTypeName().equals("Table")) continue;
            ++iCount;
        }
        return iCount;
    }

    public int getNumberOf3DRasterLayers() {
        int iCount = 0;
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            if (!((Parameter)this.m_Parameters.get(i)).getParameterTypeName().equals("3D Raster Layer")) continue;
            ++iCount;
        }
        return iCount;
    }

    public int getNumberOfNoDataParameters() {
        int iCount = 0;
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            Object parameter = this.m_Parameters.get(i);
            if (parameter instanceof ParameterNumericalValue) {
                ++iCount;
                continue;
            }
            if (parameter instanceof ParameterString) {
                ++iCount;
                continue;
            }
            if (parameter instanceof ParameterSelection) {
                ++iCount;
                continue;
            }
            if (parameter instanceof ParameterFixedTable) {
                ++iCount;
                continue;
            }
            if (parameter instanceof ParameterPoint) {
                ++iCount;
                continue;
            }
            if (parameter instanceof ParameterBoolean) {
                ++iCount;
                continue;
            }
            if (!(parameter instanceof ParameterFilepath)) continue;
            ++iCount;
        }
        return iCount;
    }

    public int getNumberOfTableFieldsParameters() {
        int iCount = 0;
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            Object parameter = this.m_Parameters.get(i);
            if (!(parameter instanceof ParameterTableField)) continue;
            ++iCount;
        }
        return iCount;
    }

    public int getNumberOfTableFilterParameters() {
        int iCount = 0;
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            Object parameter = this.m_Parameters.get(i);
            if (!(parameter instanceof ParameterTableFilter)) continue;
            ++iCount;
        }
        return iCount;
    }

    public int getNumberOfBandsParameters() {
        int iCount = 0;
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            Object parameter = this.m_Parameters.get(i);
            if (!(parameter instanceof ParameterBand)) continue;
            ++iCount;
        }
        return iCount;
    }

    public boolean requiresNonDataObjects() {
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            if (((Parameter)this.m_Parameters.get(i)).getParameterTypeName().equals("Table") || ((Parameter)this.m_Parameters.get(i)).getParameterTypeName().equals("Vector Layer") || ((Parameter)this.m_Parameters.get(i)).getParameterTypeName().equals("Raster Layer") || ((Parameter)this.m_Parameters.get(i)).getParameterTypeName().equals("Multiple Input") || ((Parameter)this.m_Parameters.get(i)).getParameterTypeName().equals("Table Field") || ((Parameter)this.m_Parameters.get(i)).getParameterTypeName().equals("3D Raster Layer") || ((Parameter)this.m_Parameters.get(i)).getParameterTypeName().equals("Band")) continue;
            return true;
        }
        return false;
    }

    public boolean requiresRasterLayers() {
        if (this.getNumberOfRasterLayers() > 0) {
            return true;
        }
        return this.requiresMultipleInputOfType(1, true) || this.requiresMultipleInputOfType(7, true);
    }

    public boolean requires3DRasterLayers() {
        return this.getNumberOf3DRasterLayers() > 0;
    }

    public boolean requiresMultipleRasterLayers() {
        return this.requiresMultipleInputOfType(1, false);
    }

    public boolean requiresMultipleVectorLayers() {
        return this.requiresMultipleInputOfType(5, false) || this.requiresMultipleInputOfType(3, false) || this.requiresMultipleInputOfType(2, false) || this.requiresMultipleInputOfType(4, false);
    }

    public boolean requiresMultipleTables() {
        return this.requiresMultipleInputOfType(6, false);
    }

    public boolean requiresMultipleRasterBands() {
        return this.requiresMultipleInputOfType(7, false);
    }

    private boolean requiresMultipleInputOfType(int iType, boolean bOnlyMandatory) {
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            if (!((Parameter)this.m_Parameters.get(i)).getParameterTypeName().equals("Multiple Input")) continue;
            try {
                AdditionalInfoMultipleInput ai = (AdditionalInfoMultipleInput)((Parameter)this.m_Parameters.get(i)).getParameterAdditionalInfo();
                if (ai.getDataType() != iType || !ai.getIsMandatory() && bOnlyMandatory) continue;
                return true;
            }
            catch (NullParameterAdditionalInfoException e) {
                Sextante.addErrorToLog(e);
            }
        }
        return false;
    }

    public boolean requiresRasterBands() {
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            if (!((Parameter)this.m_Parameters.get(i)).getParameterTypeName().equals("Band")) continue;
            return true;
        }
        return false;
    }

    public boolean requiresVectorLayers() {
        if (this.getNumberOfVectorLayers() > 0) {
            return true;
        }
        return this.requiresMultipleInputOfType(5, true);
    }

    public boolean requiresPointVectorLayers() {
        if (this.getNumberOfPointVectorLayers() > 0) {
            return true;
        }
        return this.requiresMultipleInputOfType(2, true);
    }

    public boolean requiresLineVectorLayers() {
        if (this.getNumberOfLineVectorLayers() > 0) {
            return true;
        }
        return this.requiresMultipleInputOfType(3, true);
    }

    public boolean requiresPolygonVectorLayers() {
        if (this.getNumberOfPolygonVectorLayers() > 0) {
            return true;
        }
        return this.requiresMultipleInputOfType(4, true);
    }

    public boolean requiresTables() {
        if (this.getNumberOfTables() > 0) {
            return true;
        }
        return this.requiresMultipleInputOfType(6, true);
    }

    public boolean requiresFixedTables() {
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            if (!((Parameter)this.m_Parameters.get(i)).getParameterTypeName().equals("Fixed Table")) continue;
            return true;
        }
        return false;
    }

    public boolean requiresTableFields() {
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            if (!((Parameter)this.m_Parameters.get(i)).getParameterTypeName().equals("Table Field")) continue;
            return true;
        }
        return false;
    }

    public boolean requiresPoints() {
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            if (!((Parameter)this.m_Parameters.get(i)).getParameterTypeName().equals("Point")) continue;
            return true;
        }
        return false;
    }

    public boolean addParameter(Parameter parameter) throws RepeatedParameterNameException {
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            Parameter param = (Parameter)this.m_Parameters.get(i);
            if (!param.getParameterName().equals(parameter.getParameterName())) continue;
            throw new RepeatedParameterNameException();
        }
        return this.m_Parameters.add(parameter);
    }

    public void removeParameter(Parameter parameter) throws WrongParameterIDException {
        this.removeParameter(parameter.getParameterName());
    }

    public void removeParameter(String sParameterName) throws WrongParameterIDException {
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            if (!((Parameter)this.m_Parameters.get(i)).getParameterName().equals(sParameterName)) continue;
            this.m_Parameters.remove(i);
            return;
        }
        throw new WrongParameterIDException();
    }

    public ArrayList getParametersOfType(Class paramClass) {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            Parameter param = (Parameter)this.m_Parameters.get(i);
            if (!param.getClass().equals(paramClass)) continue;
            list.add(param);
        }
        return list;
    }

    public Parameter getParameter(String sParameterName) throws WrongParameterIDException {
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            if (!((Parameter)this.m_Parameters.get(i)).getParameterName().equals(sParameterName)) continue;
            return (Parameter)this.m_Parameters.get(i);
        }
        throw new WrongParameterIDException();
    }

    public Parameter getParameter(int iIndex) throws ArrayIndexOutOfBoundsException {
        if (iIndex >= 0 && iIndex < this.m_Parameters.size()) {
            return (Parameter)this.m_Parameters.get(iIndex);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public Object getParameterValueAsObject(String sParameterName) throws WrongParameterTypeException, WrongParameterIDException, NullParameterValueException {
        Parameter parameter = this.getParameter(sParameterName);
        return parameter.getParameterValueAsObject();
    }

    public int getParameterValueAsInt(String sParameterName) throws WrongParameterTypeException, WrongParameterIDException, NullParameterValueException {
        Parameter parameter = this.getParameter(sParameterName);
        return parameter.getParameterValueAsInt();
    }

    public double getParameterValueAsDouble(String sParameterName) throws WrongParameterTypeException, WrongParameterIDException, NullParameterValueException {
        Parameter parameter = this.getParameter(sParameterName);
        return parameter.getParameterValueAsDouble();
    }

    public Point2D getParameterValueAsPoint(String sParameterName) throws WrongParameterTypeException, WrongParameterIDException, NullParameterValueException {
        Parameter parameter = this.getParameter(sParameterName);
        return parameter.getParameterValueAsPoint();
    }

    public boolean getParameterValueAsBoolean(String sParameterName) throws WrongParameterTypeException, WrongParameterIDException, NullParameterValueException {
        Parameter parameter = this.getParameter(sParameterName);
        return parameter.getParameterValueAsBoolean();
    }

    public ArrayList getParameterValueAsArrayList(String sParameterName) throws WrongParameterTypeException, WrongParameterIDException, NullParameterValueException {
        Parameter parameter = this.getParameter(sParameterName);
        return parameter.getParameterValueAsArrayList();
    }

    public String getParameterValueAsString(String sParameterName) throws WrongParameterTypeException, WrongParameterIDException, NullParameterValueException, NullParameterAdditionalInfoException {
        Parameter parameter = this.getParameter(sParameterName);
        return parameter.getParameterValueAsString();
    }

    public IVectorLayer getParameterValueAsVectorLayer(String sParameterName) throws WrongParameterTypeException, WrongParameterIDException, NullParameterValueException {
        Parameter parameter = this.getParameter(sParameterName);
        return parameter.getParameterValueAsVectorLayer();
    }

    public IRasterLayer getParameterValueAsRasterLayer(String sParameterName) throws WrongParameterTypeException, WrongParameterIDException, NullParameterValueException {
        Parameter parameter = this.getParameter(sParameterName);
        return parameter.getParameterValueAsRasterLayer();
    }

    public I3DRasterLayer getParameterValueAs3DRasterLayer(String sParameterName) throws WrongParameterTypeException, WrongParameterIDException, NullParameterValueException {
        Parameter parameter = this.getParameter(sParameterName);
        return parameter.getParameterValueAs3DRasterLayer();
    }

    public ITable getParameterValueAsTable(String sParameterName) throws WrongParameterTypeException, WrongParameterIDException, NullParameterValueException {
        Parameter parameter = this.getParameter(sParameterName);
        return parameter.getParameterValueAsTable();
    }

    public void addInputVectorLayer(String sName, String sDescription, int iShapeType, boolean bIsMandatory) throws RepeatedParameterNameException {
        AdditionalInfoVectorLayer additionalInfo = new AdditionalInfoVectorLayer(iShapeType, bIsMandatory);
        this.addInputVectorLayer(sName, sDescription, additionalInfo);
    }

    public void addInputVectorLayer(String sName, String sDescription, AdditionalInfoVectorLayer additionalInfo) throws RepeatedParameterNameException {
        ParameterVectorLayer parameter = new ParameterVectorLayer();
        parameter.setParameterName(sName);
        parameter.setParameterDescription(sDescription);
        parameter.setParameterAdditionalInfo(additionalInfo);
        this.addParameter(parameter);
    }

    public void addInputRasterLayer(String sName, String sDescription, boolean bIsMandatory) throws RepeatedParameterNameException {
        AdditionalInfoRasterLayer additionalInfo = new AdditionalInfoRasterLayer(bIsMandatory);
        ParameterRasterLayer parameter = new ParameterRasterLayer();
        parameter.setParameterName(sName);
        parameter.setParameterDescription(sDescription);
        parameter.setParameterAdditionalInfo(additionalInfo);
        this.addParameter(parameter);
    }

    public void addInput3DRasterLayer(String sName, String sDescription, boolean bIsMandatory) throws RepeatedParameterNameException {
        AdditionalInfo3DRasterLayer additionalInfo = new AdditionalInfo3DRasterLayer(bIsMandatory);
        Parameter3DRasterLayer parameter = new Parameter3DRasterLayer();
        parameter.setParameterName(sName);
        parameter.setParameterDescription(sDescription);
        parameter.setParameterAdditionalInfo(additionalInfo);
        this.addParameter(parameter);
    }

    public void addInputTable(String sName, String sDescription, boolean bIsMandatory) throws RepeatedParameterNameException {
        AdditionalInfoTable additionalInfo = new AdditionalInfoTable(bIsMandatory);
        ParameterTable parameter = new ParameterTable();
        parameter.setParameterName(sName);
        parameter.setParameterDescription(sDescription);
        parameter.setParameterAdditionalInfo(additionalInfo);
        this.addParameter(parameter);
    }

    public void addMultipleInput(String sName, String sDescription, int iDataType, boolean bIsMandatory) throws RepeatedParameterNameException {
        AdditionalInfoMultipleInput additionalInfo = new AdditionalInfoMultipleInput(iDataType, bIsMandatory);
        ParameterMultipleInput parameter = new ParameterMultipleInput();
        parameter.setParameterName(sName);
        parameter.setParameterDescription(sDescription);
        parameter.setParameterAdditionalInfo(additionalInfo);
        this.addParameter(parameter);
    }

    public void addTableField(String sName, String sDescription, String sParentParameterName) throws RepeatedParameterNameException, UndefinedParentParameterNameException, OptionalParentParameterException {
        this.addTableField(sName, sDescription, sParentParameterName, true);
    }

    public void addTableFilter(String sName, String sDescription, String sParentParameterName, boolean bIsMandatory) throws RepeatedParameterNameException, UndefinedParentParameterNameException, OptionalParentParameterException {
        boolean bParentParameterFound = false;
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            if (!((Parameter)this.m_Parameters.get(i)).getParameterName().equals(sParentParameterName) || !((Parameter)this.m_Parameters.get(i)).getParameterTypeName().equals("Table") && !((Parameter)this.m_Parameters.get(i)).getParameterTypeName().equals("Vector Layer")) continue;
            try {
                AdditionalInfoDataObject parentAdditionalInfo = (AdditionalInfoDataObject)((Parameter)this.m_Parameters.get(i)).getParameterAdditionalInfo();
                if (!parentAdditionalInfo.getIsMandatory()) {
                    throw new OptionalParentParameterException();
                }
                AdditionalInfoTableFilter additionalInfo = new AdditionalInfoTableFilter(sParentParameterName, bIsMandatory);
                ParameterTableFilter parameter = new ParameterTableFilter();
                parameter.setParameterName(sName);
                parameter.setParameterDescription(sDescription);
                parameter.setParameterAdditionalInfo(additionalInfo);
                this.addParameter(parameter);
                bParentParameterFound = true;
                continue;
            }
            catch (NullParameterAdditionalInfoException e) {
                Sextante.addErrorToLog(e);
            }
        }
        if (!bParentParameterFound) {
            throw new UndefinedParentParameterNameException();
        }
    }

    public void addTableField(String sName, String sDescription, String sParentParameterName, boolean bIsMandatory) throws RepeatedParameterNameException, UndefinedParentParameterNameException, OptionalParentParameterException {
        boolean bParentParameterFound = false;
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            if (!((Parameter)this.m_Parameters.get(i)).getParameterName().equals(sParentParameterName) || !((Parameter)this.m_Parameters.get(i)).getParameterTypeName().equals("Table") && !((Parameter)this.m_Parameters.get(i)).getParameterTypeName().equals("Vector Layer")) continue;
            try {
                AdditionalInfoDataObject parentAdditionalInfo = (AdditionalInfoDataObject)((Parameter)this.m_Parameters.get(i)).getParameterAdditionalInfo();
                if (!parentAdditionalInfo.getIsMandatory()) {
                    throw new OptionalParentParameterException();
                }
                AdditionalInfoTableField additionalInfo = new AdditionalInfoTableField(sParentParameterName, bIsMandatory);
                ParameterTableField parameter = new ParameterTableField();
                parameter.setParameterName(sName);
                parameter.setParameterDescription(sDescription);
                parameter.setParameterAdditionalInfo(additionalInfo);
                this.addParameter(parameter);
                bParentParameterFound = true;
                continue;
            }
            catch (NullParameterAdditionalInfoException e) {
                Sextante.addErrorToLog(e);
            }
        }
        if (!bParentParameterFound) {
            throw new UndefinedParentParameterNameException();
        }
    }

    public void addBand(String sName, String sDescription, String sParentParameterName) throws RepeatedParameterNameException, UndefinedParentParameterNameException, OptionalParentParameterException {
        boolean bParentParameterFound = false;
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            if (!((Parameter)this.m_Parameters.get(i)).getParameterName().equals(sParentParameterName) || !((Parameter)this.m_Parameters.get(i)).getParameterTypeName().equals("Raster Layer")) continue;
            try {
                AdditionalInfoDataObject parentAdditionalInfo = (AdditionalInfoDataObject)((Parameter)this.m_Parameters.get(i)).getParameterAdditionalInfo();
                if (!parentAdditionalInfo.getIsMandatory()) {
                    throw new OptionalParentParameterException();
                }
                AdditionalInfoBand additionalInfo = new AdditionalInfoBand(sParentParameterName);
                ParameterBand parameter = new ParameterBand();
                parameter.setParameterName(sName);
                parameter.setParameterDescription(sDescription);
                parameter.setParameterAdditionalInfo(additionalInfo);
                this.addParameter(parameter);
                bParentParameterFound = true;
                continue;
            }
            catch (NullParameterAdditionalInfoException e) {
                Sextante.addErrorToLog(e);
            }
        }
        if (!bParentParameterFound) {
            throw new UndefinedParentParameterNameException();
        }
    }

    public void addNumericalValue(String sName, String sDescription, int iType, double dDefaultValue, double dMinValue, double dMaxValue) throws RepeatedParameterNameException {
        AdditionalInfoNumericalValue additionalInfo = new AdditionalInfoNumericalValue(iType, dDefaultValue, dMinValue, dMaxValue);
        ParameterNumericalValue parameter = new ParameterNumericalValue();
        parameter.setParameterName(sName);
        parameter.setParameterDescription(sDescription);
        parameter.setParameterAdditionalInfo(additionalInfo);
        parameter.setParameterValue(new Double(dDefaultValue));
        this.addParameter(parameter);
    }

    public void addNumericalValue(String sName, String sDescription, double dDefaultValue, int iType) throws RepeatedParameterNameException {
        this.addNumericalValue(sName, sDescription, iType, dDefaultValue, Double.NEGATIVE_INFINITY, Double.MAX_VALUE);
    }

    public void addString(String sName, String sDescription) throws RepeatedParameterNameException {
        this.addString(sName, sDescription, "");
    }

    public void addString(String sName, String sDescription, String sDefaultString) throws RepeatedParameterNameException {
        AdditionalInfoString additionalInfo = new AdditionalInfoString();
        additionalInfo.setDefaultString(sDefaultString);
        ParameterString parameter = new ParameterString();
        parameter.setParameterName(sName);
        parameter.setParameterDescription(sDescription);
        parameter.setParameterAdditionalInfo(additionalInfo);
        parameter.setParameterValue(sDefaultString);
        this.addParameter(parameter);
    }

    public void addFilepath(String sName, String sDescription, boolean bFolder, boolean bOpenDialog, boolean bIsVoxel, String[] sExt) throws RepeatedParameterNameException {
        AdditionalInfoFilepath additionalInfo = new AdditionalInfoFilepath(bFolder, bOpenDialog, bIsVoxel, sExt);
        ParameterFilepath parameter = new ParameterFilepath();
        parameter.setParameterName(sName);
        parameter.setParameterDescription(sDescription);
        parameter.setParameterAdditionalInfo(additionalInfo);
        this.addParameter(parameter);
    }

    public void addFilepath(String sName, String sDescription, boolean bFolder, boolean bOpenDialog, boolean bIsVoxel, String sExt) throws RepeatedParameterNameException {
        AdditionalInfoFilepath additionalInfo = new AdditionalInfoFilepath(bFolder, bOpenDialog, bIsVoxel, new String[]{sExt});
        ParameterFilepath parameter = new ParameterFilepath();
        parameter.setParameterName(sName);
        parameter.setParameterDescription(sDescription);
        parameter.setParameterAdditionalInfo(additionalInfo);
        this.addParameter(parameter);
    }

    public void addBoolean(String sName, String sDescription, boolean bDefault) throws RepeatedParameterNameException {
        AdditionalInfoBoolean additionalInfo = new AdditionalInfoBoolean(bDefault);
        ParameterBoolean parameter = new ParameterBoolean();
        parameter.setParameterName(sName);
        parameter.setParameterDescription(sDescription);
        parameter.setParameterAdditionalInfo(additionalInfo);
        parameter.setParameterValue(bDefault);
        this.addParameter(parameter);
    }

    public void addSelection(String sName, String sDescription, String[] sValues) throws RepeatedParameterNameException {
        AdditionalInfoSelection additionalInfo = new AdditionalInfoSelection(sValues);
        ParameterSelection parameter = new ParameterSelection();
        parameter.setParameterName(sName);
        parameter.setParameterDescription(sDescription);
        parameter.setParameterAdditionalInfo(additionalInfo);
        parameter.setParameterValue(new Integer(0));
        this.addParameter(parameter);
    }

    public void addFixedTable(String sName, String sDescription, String[] sColumnNames, int iRows, boolean bIsNumberOfRowsFixed) throws RepeatedParameterNameException {
        AdditionalInfoFixedTable additionalInfo = new AdditionalInfoFixedTable(sColumnNames, iRows, bIsNumberOfRowsFixed);
        ParameterFixedTable parameter = new ParameterFixedTable();
        parameter.setParameterName(sName);
        parameter.setParameterDescription(sDescription);
        parameter.setParameterAdditionalInfo(additionalInfo);
        this.addParameter(parameter);
    }

    public void addPoint(String sName, String sDescription) throws RepeatedParameterNameException {
        AdditionalInfoPoint additionalInfo = new AdditionalInfoPoint();
        ParameterPoint parameter = new ParameterPoint();
        parameter.setParameterName(sName);
        parameter.setParameterDescription(sDescription);
        parameter.setParameterAdditionalInfo(additionalInfo);
        this.addParameter(parameter);
    }

    public ParametersSet getNewInstance() {
        ParametersSet set = new ParametersSet();
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            try {
                Parameter param = (Parameter)this.m_Parameters.get(i);
                set.addParameter(param.getNewInstance());
                continue;
            }
            catch (RepeatedParameterNameException repeatedParameterNameException) {
                // empty catch block
            }
        }
        return set;
    }

    public boolean areParameterValuesCorrect() {
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            Parameter param = (Parameter)this.m_Parameters.get(i);
            if (param.isParameterValueCorrect()) continue;
            return false;
        }
        return true;
    }
}

