/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.dataObjects;

import com.vividsolutions.jts.geom.Envelope;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.IteratorException;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.feature.FeatureStore;

public abstract class AbstractVectorLayer
implements IVectorLayer {
    private int m_iShapesCount;
    private boolean m_bShapesCountAndExtentCalculated = false;
    private Rectangle2D m_Extent;
    private final ArrayList<IVectorLayerFilter> m_Filters = new ArrayList();

    @Override
    public abstract Object getBaseDataObject();

    @Override
    public String[] getFieldNames() {
        String[] names = new String[this.getFieldCount()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.getFieldName(i);
        }
        return names;
    }

    @Override
    public int getFieldIndexByName(String sFieldName) {
        for (int i = 0; i < this.getFieldCount(); ++i) {
            String sName = this.getFieldName(i);
            if (!sName.equalsIgnoreCase(sFieldName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Class[] getFieldTypes() {
        Class[] types = new Class[this.getFieldCount()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.getFieldType(i);
        }
        return types;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void addFeature(IFeature feature) {
        this.addFeature(feature.getGeometry(), feature.getRecord().getValues());
    }

    @Override
    public int getShapesCount() {
        if (!this.m_bShapesCountAndExtentCalculated) {
            this.calculateShapesCountAndExtent();
        }
        return this.m_iShapesCount;
    }

    @Override
    public Rectangle2D getFullExtent() {
        if (!this.m_bShapesCountAndExtentCalculated) {
            this.calculateShapesCountAndExtent();
        }
        return this.m_Extent;
    }

    private void calculateShapesCountAndExtent() {
        Envelope envelope = null;
        IFeatureIterator iter = this.iterator();
        this.m_iShapesCount = 0;
        while (iter.hasNext()) {
            IFeature feature;
            try {
                feature = iter.next();
            }
            catch (IteratorException e) {
                this.m_Extent = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
                this.m_iShapesCount = 0;
                return;
            }
            if (this.m_iShapesCount == 0) {
                envelope = feature.getGeometry().getEnvelopeInternal();
            } else {
                envelope.expandToInclude(feature.getGeometry().getEnvelopeInternal());
            }
            ++this.m_iShapesCount;
        }
        this.m_Extent = this.m_iShapesCount == 0 ? new Rectangle2D.Double() : new Rectangle2D.Double(envelope.getMinX(), envelope.getMinY(), envelope.getWidth(), envelope.getHeight());
        this.m_bShapesCountAndExtentCalculated = true;
    }

    @Override
    public void addFilter(IVectorLayerFilter filter) {
        this.m_Filters.add(filter);
        this.m_bShapesCountAndExtentCalculated = false;
    }

    @Override
    public void removeFilters() {
        this.m_Filters.clear();
        this.m_bShapesCountAndExtentCalculated = false;
    }

    @Override
    public List<IVectorLayerFilter> getFilters() {
        return this.m_Filters;
    }

    @Override
    public FeatureStore getFeatureStore() {
        return null;
    }
}

