/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.dataObjects.vectorFilters;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;

public class BoundingBoxFilter
implements IVectorLayerFilter {
    private final Geometry m_Rect;

    public BoundingBoxFilter(Geometry rect) {
        this.m_Rect = rect;
    }

    public BoundingBoxFilter(AnalysisExtent extent) {
        Coordinate[] coords;
        GeometryFactory gf = new GeometryFactory();
        coords = new Coordinate[]{new Coordinate(extent.getXMin(), extent.getYMin()), new Coordinate(extent.getXMin(), extent.getYMax()), new Coordinate(extent.getXMax(), extent.getYMax()), new Coordinate(extent.getXMax(), extent.getYMin()), coords[0]};
        this.m_Rect = gf.createPolygon(gf.createLinearRing(coords), null);
    }

    public Geometry getBoundingBox() {
        return this.m_Rect;
    }

    @Override
    public boolean accept(IFeature feature, int iIndex) {
        return feature.getGeometry().intersects(this.m_Rect);
    }
}

