/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.io3d;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.dataObjects.I3DRasterLayer;
import es.unex.sextante.io3d.ASCII3DFileTools;
import es.unex.sextante.outputs.FileOutputChannel;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.rasterWrappers.Grid3DCell;
import java.awt.geom.Rectangle2D;
import java.io.File;

public class Default3DRasterLayer
implements I3DRasterLayer {
    private AnalysisExtent m_Extent;
    private double[][][] m_dData;
    private double m_dNoDataValue = -99999.0;
    private String m_sFilename;
    private String m_sName;
    private Object m_CRS;

    public void create(String sName, String sFilename, AnalysisExtent ae, Object crs) {
        this.m_CRS = crs;
        this.m_sName = sName;
        this.m_sFilename = sFilename;
        this.m_Extent = ae;
        this.m_dData = new double[ae.getNX()][ae.getNY()][ae.getNZ()];
    }

    @Override
    public byte getCellValueAsByte(int x, int y, int z) {
        return (byte)this.getCellValueAsDouble(x, y, z);
    }

    @Override
    public double getCellValueAsDouble(int x, int y, int z) {
        try {
            return this.m_dData[x][y][z];
        }
        catch (Exception e) {
            return this.m_dNoDataValue;
        }
    }

    @Override
    public float getCellValueAsFloat(int x, int y, int z) {
        return (float)this.getCellValueAsDouble(x, y, z);
    }

    @Override
    public int getCellValueAsInt(int x, int y, int z) {
        return (int)this.getCellValueAsDouble(x, y, z);
    }

    @Override
    public short getCellValueAsShort(int x, int y, int z) {
        return (short)this.getCellValueAsDouble(x, y, z);
    }

    @Override
    public int getDataType() {
        return 5;
    }

    @Override
    public double getCellSize() {
        return this.m_Extent.getCellSize();
    }

    @Override
    public double getCellSizeZ() {
        return this.m_Extent.getCellSizeZ();
    }

    @Override
    public AnalysisExtent getLayerExtent() {
        return this.m_Extent;
    }

    @Override
    public int getNX() {
        return this.m_dData.length;
    }

    @Override
    public int getNY() {
        return this.m_dData[0].length;
    }

    @Override
    public int getNZ() {
        return this.m_dData[0][0].length;
    }

    @Override
    public double getNoDataValue() {
        return this.m_dNoDataValue;
    }

    @Override
    public double getValueAt(double x, double y, double z) {
        Grid3DCell cell = this.m_Extent.getGridCoordsFromWorldCoords(x, y, z);
        return this.getCellValueAsDouble(cell.getX(), cell.getY(), cell.getZ());
    }

    @Override
    public boolean isInWindow(int x, int y, int z) {
        return x >= 0 && y >= 0 && z >= 0 && x < this.getNX() && y < this.getNY() && z < this.getNZ();
    }

    @Override
    public boolean isNoDataValue(double dNoDataValue) {
        return dNoDataValue == this.m_dNoDataValue;
    }

    @Override
    public void setCellValue(int x, int y, int z, double dValue) {
        try {
            this.m_dData[x][y][z] = dValue;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setNoData(int x, int y, int z) {
        try {
            this.m_dData[x][y][z] = this.m_dNoDataValue;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setNoDataValue(double dNoDataValue) {
        this.m_dNoDataValue = dNoDataValue;
    }

    @Override
    public Object getCRS() {
        return this.m_CRS;
    }

    @Override
    public Rectangle2D getFullExtent() {
        return this.m_Extent.getAsRectangle2D();
    }

    @Override
    public void close() {
    }

    @Override
    public Object getBaseDataObject() {
        return this.m_dData;
    }

    @Override
    public IOutputChannel getOutputChannel() {
        return new FileOutputChannel(this.m_sFilename);
    }

    @Override
    public String getName() {
        return this.m_sName;
    }

    @Override
    public void open() {
    }

    @Override
    public void postProcess() throws Exception {
        ASCII3DFileTools.writeFile(this, new File(this.m_sFilename));
    }

    @Override
    public void setName(String sName) {
        this.m_sName = sName;
    }

    @Override
    public void free() {
        this.m_dData = null;
    }

    @Override
    public String getContextName() {
        return null;
    }
}

