/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.parameters;

import es.unex.sextante.additionalInfo.AdditionalInfo;
import es.unex.sextante.additionalInfo.AdditionalInfoMultipleInput;
import es.unex.sextante.dataObjects.I3DRasterLayer;
import es.unex.sextante.dataObjects.ILayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.exceptions.NullParameterValueException;
import es.unex.sextante.exceptions.WrongParameterTypeException;
import es.unex.sextante.parameters.Parameter;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParserException;

public class ParameterMultipleInput
extends Parameter {
    private static final String TYPE = "type";
    private static final String MANDATORY = "mandatory";

    @Override
    public String getParameterTypeName() {
        return "Multiple Input";
    }

    @Override
    public IRasterLayer getParameterValueAsRasterLayer() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public I3DRasterLayer getParameterValueAs3DRasterLayer() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public ITable getParameterValueAsTable() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public IVectorLayer getParameterValueAsVectorLayer() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public ArrayList getParameterValueAsArrayList() throws NullParameterValueException {
        if (this.m_ParameterValue != null) {
            return (ArrayList)this.m_ParameterValue;
        }
        throw new NullParameterValueException();
    }

    @Override
    public int getParameterValueAsInt() throws NullParameterValueException {
        if (this.m_ParameterValue != null) {
            return ((ArrayList)this.m_ParameterValue).size();
        }
        throw new NullParameterValueException();
    }

    @Override
    public double getParameterValueAsDouble() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public boolean getParameterValueAsBoolean() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public String getParameterValueAsString() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public Point2D getParameterValueAsPoint() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public boolean setParameterAdditionalInfo(AdditionalInfo additionalInfo) {
        if (additionalInfo instanceof AdditionalInfoMultipleInput) {
            this.m_ParameterAdditionalInfo = additionalInfo;
            return true;
        }
        return false;
    }

    @Override
    public boolean setParameterValue(Object value) {
        if (value instanceof ArrayList) {
            this.m_ParameterValue = value;
            return true;
        }
        return false;
    }

    @Override
    public Class getParameterClass() {
        return ArrayList.class;
    }

    @Override
    protected void serializeAttributes(KXmlSerializer serializer) throws NullParameterAdditionalInfoException, IOException {
        AdditionalInfoMultipleInput aimi = (AdditionalInfoMultipleInput)this.m_ParameterAdditionalInfo;
        if (aimi == null) {
            throw new NullParameterAdditionalInfoException();
        }
        serializer.text("\n");
        serializer.text("\t\t\t");
        serializer.startTag(null, "attribute");
        serializer.attribute(null, "name", TYPE);
        serializer.attribute(null, "value", new Integer(aimi.getDataType()).toString());
        serializer.endTag(null, "attribute");
        serializer.text("\n");
        serializer.text("\t\t\t");
        serializer.startTag(null, "attribute");
        serializer.attribute(null, "name", MANDATORY);
        serializer.attribute(null, "value", Boolean.valueOf(aimi.getIsMandatory()).toString());
        serializer.endTag(null, "attribute");
    }

    public static Parameter deserialize(KXmlParser parser) throws XmlPullParserException, IOException {
        int iType = 0;
        boolean bMandatory = false;
        int tag = parser.nextTag();
        boolean bOver = false;
        while (!bOver) {
            switch (tag) {
                case 2: {
                    if (parser.getName().compareTo("attribute") != 0) break;
                    String sName = parser.getAttributeValue("", "name");
                    if (sName.compareTo(TYPE) == 0) {
                        iType = Integer.parseInt(parser.getAttributeValue("", "value"));
                        break;
                    }
                    if (sName.compareTo(MANDATORY) != 0) break;
                    bMandatory = parser.getAttributeValue("", "value").equals("true");
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("input") != 0) break;
                    bOver = true;
                    break;
                }
            }
            if (bOver) continue;
            tag = parser.next();
        }
        ParameterMultipleInput param = new ParameterMultipleInput();
        AdditionalInfoMultipleInput ai = new AdditionalInfoMultipleInput(iType, bMandatory);
        param.setParameterAdditionalInfo(ai);
        return param;
    }

    @Override
    public String getCommandLineParameter() {
        ArrayList list = (ArrayList)this.m_ParameterValue;
        if (list.size() > 0) {
            StringBuffer sb = new StringBuffer("\"");
            for (int i = 0; i < list.size(); ++i) {
                Object obj = list.get(i);
                if (obj instanceof ILayer) {
                    sb.append(((ILayer)obj).getName());
                } else if (obj instanceof ITable) {
                    sb.append(((ITable)obj).getName());
                } else {
                    sb.append(obj.toString());
                }
                if (i >= list.size() - 1) continue;
                sb.append(", ");
            }
            sb.append("\"");
            return sb.toString();
        }
        return "\"#\"";
    }

    @Override
    public boolean isParameterValueCorrect() {
        AdditionalInfoMultipleInput aimi = (AdditionalInfoMultipleInput)this.m_ParameterAdditionalInfo;
        if (this.m_ParameterValue == null) {
            return !aimi.getIsMandatory();
        }
        return true;
    }
}

