/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.parameters;

import es.unex.sextante.additionalInfo.AdditionalInfo;
import es.unex.sextante.additionalInfo.AdditionalInfoString;
import es.unex.sextante.dataObjects.I3DRasterLayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.exceptions.NullParameterValueException;
import es.unex.sextante.exceptions.WrongParameterTypeException;
import es.unex.sextante.parameters.Parameter;
import java.awt.geom.Point2D;
import java.io.IOException;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParserException;

public class ParameterString
extends Parameter {
    private static final String DEFAULT = "default";

    @Override
    public String getParameterTypeName() {
        return "String";
    }

    @Override
    public IRasterLayer getParameterValueAsRasterLayer() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public I3DRasterLayer getParameterValueAs3DRasterLayer() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public ITable getParameterValueAsTable() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public IVectorLayer getParameterValueAsVectorLayer() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public int getParameterValueAsInt() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public double getParameterValueAsDouble() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public boolean getParameterValueAsBoolean() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public String getParameterValueAsString() throws WrongParameterTypeException, NullParameterValueException {
        if (this.m_ParameterValue != null) {
            return (String)this.m_ParameterValue;
        }
        throw new NullParameterValueException();
    }

    @Override
    public Point2D getParameterValueAsPoint() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public boolean setParameterAdditionalInfo(AdditionalInfo additionalInfo) {
        if (additionalInfo instanceof AdditionalInfoString) {
            this.m_ParameterAdditionalInfo = additionalInfo;
            return true;
        }
        return false;
    }

    @Override
    public boolean setParameterValue(Object value) {
        if (value instanceof String) {
            this.m_ParameterValue = value;
            return true;
        }
        return false;
    }

    @Override
    public Class getParameterClass() {
        return String.class;
    }

    @Override
    protected void serializeAttributes(KXmlSerializer serializer) throws NullParameterAdditionalInfoException, IOException {
        AdditionalInfoString ais = (AdditionalInfoString)this.m_ParameterAdditionalInfo;
        if (ais == null) {
            throw new NullParameterAdditionalInfoException();
        }
        serializer.text("\n");
        serializer.text("\t\t\t");
        serializer.startTag(null, "attribute");
        serializer.attribute(null, "name", DEFAULT);
        serializer.attribute(null, "value", ais.getDefaultString());
        serializer.endTag(null, "attribute");
    }

    public static Parameter deserialize(KXmlParser parser) throws XmlPullParserException, IOException {
        String sDefault = null;
        int tag = parser.nextTag();
        boolean bOver = false;
        while (!bOver) {
            switch (tag) {
                case 2: {
                    String sName;
                    if (parser.getName().compareTo("attribute") != 0 || (sName = parser.getAttributeValue("", "name")).compareTo(DEFAULT) != 0) break;
                    sDefault = parser.getAttributeValue("", "value");
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("input") != 0) break;
                    bOver = true;
                    break;
                }
            }
            if (bOver) continue;
            tag = parser.next();
        }
        ParameterString param = new ParameterString();
        AdditionalInfoString ai = new AdditionalInfoString();
        ai.setDefaultString(sDefault);
        param.setParameterAdditionalInfo(ai);
        return param;
    }

    @Override
    public String getCommandLineParameter() {
        return "\"" + (String)this.m_ParameterValue + "\"";
    }

    @Override
    public boolean isParameterValueCorrect() {
        return true;
    }
}

