/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.parameters;

import es.unex.sextante.additionalInfo.AdditionalInfo;
import es.unex.sextante.additionalInfo.AdditionalInfoDataObject;
import es.unex.sextante.additionalInfo.AdditionalInfoVectorLayer;
import es.unex.sextante.dataObjects.I3DRasterLayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.exceptions.NullParameterValueException;
import es.unex.sextante.exceptions.WrongParameterTypeException;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.ParameterDataObject;
import java.io.IOException;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParserException;

public class ParameterVectorLayer
extends ParameterDataObject {
    private static final String TYPE = "shape_type";

    @Override
    public String getParameterTypeName() {
        return "Vector Layer";
    }

    @Override
    public IRasterLayer getParameterValueAsRasterLayer() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public I3DRasterLayer getParameterValueAs3DRasterLayer() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public ITable getParameterValueAsTable() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public IVectorLayer getParameterValueAsVectorLayer() throws NullParameterValueException {
        if (this.m_ParameterValue != null) {
            return (IVectorLayer)this.m_ParameterValue;
        }
        if (((AdditionalInfoVectorLayer)this.m_ParameterAdditionalInfo).getIsMandatory()) {
            throw new NullParameterValueException();
        }
        return null;
    }

    @Override
    public boolean setParameterAdditionalInfo(AdditionalInfo additionalInfo) {
        if (additionalInfo instanceof AdditionalInfoVectorLayer) {
            this.m_ParameterAdditionalInfo = additionalInfo;
            return true;
        }
        return false;
    }

    @Override
    public boolean setParameterValue(Object value) {
        if (value instanceof IVectorLayer) {
            AdditionalInfoVectorLayer ai = (AdditionalInfoVectorLayer)this.m_ParameterAdditionalInfo;
            if (ai.isAvailableForShapeType(((IVectorLayer)value).getShapeType())) {
                this.m_ParameterValue = value;
                return true;
            }
            return false;
        }
        if (value == null) {
            if (((AdditionalInfoVectorLayer)this.m_ParameterAdditionalInfo).getIsMandatory()) {
                return false;
            }
            this.m_ParameterValue = null;
            return true;
        }
        return false;
    }

    @Override
    public Class getParameterClass() {
        return IVectorLayer.class;
    }

    @Override
    protected void serializeAttributes(KXmlSerializer serializer) throws NullParameterAdditionalInfoException, IOException {
        super.serializeAttributes(serializer);
        AdditionalInfoVectorLayer aivl = (AdditionalInfoVectorLayer)this.m_ParameterAdditionalInfo;
        if (aivl == null) {
            throw new NullParameterAdditionalInfoException();
        }
        serializer.text("\n");
        serializer.text("\t\t\t");
        serializer.startTag(null, "attribute");
        serializer.attribute(null, "name", TYPE);
        serializer.attribute(null, "value", new Integer(aivl.getShapeType()).toString());
        serializer.endTag(null, "attribute");
    }

    public static Parameter deserialize(KXmlParser parser) throws XmlPullParserException, IOException {
        boolean bMandatory = false;
        int iShapeType = 0;
        int tag = parser.nextTag();
        boolean bOver = false;
        while (!bOver) {
            switch (tag) {
                case 2: {
                    if (parser.getName().compareTo("attribute") != 0) break;
                    String sName = parser.getAttributeValue("", "name");
                    if (sName.compareTo("mandatory") == 0) {
                        bMandatory = parser.getAttributeValue("", "value").equals("true");
                        break;
                    }
                    if (sName.compareTo(TYPE) != 0) break;
                    iShapeType = Integer.parseInt(parser.getAttributeValue("", "value"));
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("input") != 0) break;
                    bOver = true;
                    break;
                }
            }
            if (bOver) continue;
            tag = parser.next();
        }
        ParameterVectorLayer param = new ParameterVectorLayer();
        AdditionalInfoVectorLayer ai = new AdditionalInfoVectorLayer(iShapeType, bMandatory);
        param.setParameterAdditionalInfo(ai);
        return param;
    }

    @Override
    public String getCommandLineParameter() {
        IVectorLayer layer = (IVectorLayer)this.m_ParameterValue;
        if (layer == null) {
            return "\"#\"";
        }
        return "\"" + layer.getName() + "\"";
    }

    @Override
    public boolean isParameterValueCorrect() {
        AdditionalInfoDataObject aido = (AdditionalInfoDataObject)this.m_ParameterAdditionalInfo;
        if (this.m_ParameterValue == null) {
            return !aido.getIsMandatory();
        }
        return true;
    }
}

