/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.rasterWrappers;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.rasterWrappers.GridWrapper;

public class GridWrapperInterpolated
extends GridWrapper {
    public double m_dCellsize;

    public GridWrapperInterpolated(IRasterLayer layer, AnalysisExtent windowExtent) {
        super(layer, windowExtent);
        this.m_dCellsize = windowExtent.getCellSize();
    }

    @Override
    public byte getCellValueAsByte(int x, int y) {
        return (byte)this.getCellValue(x, y, 0);
    }

    @Override
    public byte getCellValueAsByte(int x, int y, int band) {
        return (byte)this.getCellValue(x, y, band);
    }

    @Override
    public short getCellValueAsShort(int x, int y) {
        return (short)this.getCellValue(x, y, 0);
    }

    @Override
    public short getCellValueAsShort(int x, int y, int band) {
        return (short)this.getCellValue(x, y, band);
    }

    @Override
    public int getCellValueAsInt(int x, int y) {
        return (int)this.getCellValue(x, y, 0);
    }

    @Override
    public int getCellValueAsInt(int x, int y, int band) {
        return (int)this.getCellValue(x, y, band);
    }

    @Override
    public float getCellValueAsFloat(int x, int y) {
        return (float)this.getCellValue(x, y, 0);
    }

    @Override
    public float getCellValueAsFloat(int x, int y, int band) {
        return (float)this.getCellValue(x, y, band);
    }

    @Override
    public double getCellValueAsDouble(int x, int y) {
        return this.getCellValue(x, y, 0);
    }

    @Override
    public double getCellValueAsDouble(int x, int y, int band) {
        return this.getCellValue(x, y, band);
    }

    private double getCellValue(int x, int y, int band) {
        double dX = this.m_WindowExtent.getXMin() + this.m_dCellsize * ((double)x + 0.5);
        double dY = this.m_WindowExtent.getYMax() - this.m_dCellsize * ((double)y + 0.5);
        double dValue = this.getValueAt(dX, dY, band);
        return dValue;
    }
}

