/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.osm.downloader;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.raster.cache.tile.Tile;
import org.gvsig.raster.cache.tile.exception.TileGettingException;
import org.gvsig.raster.impl.provider.tile.BaseTileDownloader;
import org.gvsig.raster.osm.io.OSMDataParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileDownloaderForOSM
extends BaseTileDownloader {
    private String server = null;
    private String suffix = null;
    private final String slash = "/";
    private static final Logger LOGGER = LoggerFactory.getLogger(TileDownloaderForOSM.class);

    public TileDownloaderForOSM(RasterDataStore store, int tileSize) {
        super(store, tileSize, tileSize);
        this.server = ((OSMDataParameters)store.getParameters()).getURI().toString();
        this.suffix = ((OSMDataParameters)store.getParameters()).getTileSuffix();
    }

    public synchronized Tile downloadTile(Tile tile) throws TileGettingException {
        int level = tile.getLevel();
        int y = tile.getRow();
        int x = tile.getCol();
        try {
            String stringUri = this.server + (this.server.endsWith("/") ? "" : "/") + level + "/" + x + "/" + y + "." + this.suffix;
            URI uri = new URI(stringUri);
            URL url = uri.toURL();
            this.downloadFile(url, tile.getFile(), tile.getCancelled());
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new TileGettingException((Throwable)e);
        }
        this.readTileFromDisk(tile);
        return tile;
    }

    public synchronized void downloadFile(URL url, final File file, ICancellable cancel) throws TileGettingException {
        int timeout = 30000;
        try {
            HttpGet request = new HttpGet(url.toURI());
            request.setHeader("User-Agent", "gvSIG-desktop");
            request.setHeader("Referer", "http://www.gvsig.com");
            RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
            httpClient.execute((HttpUriRequest)request, (ResponseHandler)new ResponseHandler<Object>(){

                /*
                 * Loose catch block
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Object handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    FileOutputStream fs = null;
                    try {
                        fs = new FileOutputStream(file);
                        InputStream content = response.getEntity().getContent();
                        IOUtils.copy((InputStream)content, (OutputStream)fs);
                    }
                    catch (IOException ex) {
                        try {
                            throw ex;
                            catch (Exception ex2) {
                                throw new IOException(ex2);
                            }
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(fs);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((OutputStream)fs);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new TileGettingException((Throwable)e);
        }
    }
}

