/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.osm.io;

import org.gvsig.fmap.dal.coverage.store.RasterDataServerExplorer;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.raster.impl.store.AbstractRasterDataParameters;
import org.gvsig.raster.osm.io.OSMDataParameters;
import org.gvsig.raster.osm.io.OSMProvider;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DelegatedDynObject;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;

public class OSMDataParametersImpl
extends AbstractRasterDataParameters
implements OSMDataParameters {
    private DelegatedDynObject delegatedDynObject = null;
    private static final String FIELD_WIDTH = "width";
    private static final String FIELD_HEIGHT = "height";
    private static final String FIELD_MAX_RES_LEVEL = "maxResolutionLevel";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_SUFFIX = "suffix";

    public OSMDataParametersImpl() {
        this.initialize();
    }

    protected void initialize() {
        this.delegatedDynObject = (DelegatedDynObject)ToolsLocator.getDynObjectManager().createDynObject(OSMDataParametersImpl.registerDynClass());
    }

    public static DynStruct registerDynClass() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition("OSMDataParameters_Persistent");
        if (definition == null) {
            definition = manager.addDefinition(OSMDataParametersImpl.class, "OSMDataParameters_Persistent", "OSM DataParameters Persistency", null, null);
        }
        AbstractRasterDataParameters.registerDynClass((DynStruct)definition);
        definition.addDynFieldInt(FIELD_MAX_RES_LEVEL).setDescription("Maximun levels of resolution").setMandatory(false);
        definition.addDynFieldInt(FIELD_WIDTH).setDescription("Width").setMandatory(false);
        definition.addDynFieldInt(FIELD_HEIGHT).setDescription("Height").setMandatory(false);
        definition.addDynFieldString(FIELD_NAME).setDescription("Layer name").setMandatory(false);
        definition.addDynFieldString(FIELD_SUFFIX).setDescription("Field suffix").setMandatory(false);
        return definition;
    }

    public void assignFields(RasterDataParameters par, RasterDataServerExplorer explorer) {
        super.assignFields(par, explorer);
        OSMDataParameters p = null;
        if (!(par instanceof OSMDataParameters)) {
            return;
        }
        p = (OSMDataParameters)par;
        this.setTileSuffix(p.getTileSuffix());
        this.setOSMLayerName(p.getOSMLayerName());
        this.setWidth(p.getWidth());
        this.setHeight(p.getHeight());
        this.setNumberOfLevels(p.getNumberOfLevels());
    }

    public String getDataStoreName() {
        return OSMProvider.NAME;
    }

    public String getDescription() {
        return OSMProvider.DESCRIPTION;
    }

    protected DelegatedDynObject getDelegatedDynObject() {
        return this.delegatedDynObject;
    }

    public boolean isOverridingHost() {
        return false;
    }

    public void setOverrideHost(boolean over) {
    }

    @Override
    public void setWidth(int w) {
        this.setDynValue(FIELD_WIDTH, new Integer(w));
    }

    @Override
    public void setHeight(int h) {
        this.setDynValue(FIELD_HEIGHT, new Integer(h));
    }

    @Override
    public int getWidth() {
        Integer b = (Integer)this.getDynValue(FIELD_WIDTH);
        if (b != null) {
            return b;
        }
        return 0;
    }

    @Override
    public int getHeight() {
        Integer b = (Integer)this.getDynValue(FIELD_HEIGHT);
        if (b != null) {
            return b;
        }
        return 0;
    }

    @Override
    public String getOSMLayerName() {
        String b = (String)this.getDynValue(FIELD_NAME);
        if (b != null) {
            return b;
        }
        return null;
    }

    @Override
    public void setOSMLayerName(String name) {
        this.setDynValue(FIELD_NAME, name);
    }

    @Override
    public int getNumberOfLevels() {
        Integer b = (Integer)this.getDynValue(FIELD_MAX_RES_LEVEL);
        if (b != null) {
            return b;
        }
        return 0;
    }

    @Override
    public void setNumberOfLevels(int levels) {
        this.setDynValue(FIELD_MAX_RES_LEVEL, new Integer(levels));
    }

    @Override
    public String getTileSuffix() {
        String b = (String)this.getDynValue(FIELD_SUFFIX);
        if (b != null) {
            return b;
        }
        return null;
    }

    @Override
    public void setTileSuffix(String suffix) {
        this.setDynValue(FIELD_SUFFIX, suffix);
    }
}

