/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.osm.io;

import java.awt.geom.AffineTransform;
import java.io.File;
import java.net.URI;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.exception.BandAccessException;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSetViewException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSourceException;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.metadata.MetadataLocator;
import org.gvsig.raster.cache.tile.provider.TileServer;
import org.gvsig.raster.impl.buffer.SpiRasterQuery;
import org.gvsig.raster.impl.datastruct.ExtentImpl;
import org.gvsig.raster.impl.provider.AbstractRasterProvider;
import org.gvsig.raster.impl.provider.RasterProvider;
import org.gvsig.raster.impl.store.AbstractRasterDataParameters;
import org.gvsig.raster.impl.store.DefaultRasterStore;
import org.gvsig.raster.impl.store.DefaultStoreFactory;
import org.gvsig.raster.impl.store.properties.DataStoreColorInterpretation;
import org.gvsig.raster.impl.store.properties.DataStoreTransparency;
import org.gvsig.raster.osm.cachestruct.OSMCacheStruct;
import org.gvsig.raster.osm.downloader.OSMTileServer;
import org.gvsig.raster.osm.io.OSMDataParameters;
import org.gvsig.raster.osm.io.OSMDataParametersImpl;
import org.gvsig.tools.ToolsLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSMProvider
extends AbstractRasterProvider {
    public static String NAME = "OSM Raster";
    public static String DESCRIPTION = "OSM Raster Server";
    public final String METADATA_DEFINITION_NAME = NAME;
    private Extent viewRequest = null;
    private TileServer tileServer = null;
    private boolean open = false;
    private DataStoreTransparency fileTransparency = null;
    private static final Logger logger = LoggerFactory.getLogger(OSMProvider.class);

    public static void register() {
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        if (dataman != null && !dataman.getStoreProviders().contains(NAME)) {
            dataman.registerStoreProvider(NAME, OSMProvider.class, OSMDataParametersImpl.class);
        }
        dataman.registerStoreFactory(NAME, DefaultStoreFactory.class);
    }

    public OSMProvider() {
    }

    public OSMProvider(String params) throws NotSupportedExtensionException, OpenException {
        super(params);
    }

    public OSMProvider(OSMDataParametersImpl params, DataStoreProviderServices storeServices) throws NotSupportedExtensionException, OpenException {
        super((AbstractRasterDataParameters)params, storeServices, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition("DataProvider")));
        this.init(params, storeServices);
    }

    public void init(OSMDataParametersImpl params, DataStoreProviderServices storeServices) throws NotSupportedExtensionException, OpenException {
        this.setParam(storeServices, (DataStoreParameters)params);
        this.setDataType(new int[]{0, 0, 0, 0});
        this.bandCount = 4;
        super.init();
        this.fileSize = (long)(this.getWidth() * this.getHeight() * 3.0);
        Extent ext = this.getExtent();
        this.ownTransformation = new AffineTransform(ext.width() / this.getWidth(), 0.0, 0.0, -(ext.height() / this.getHeight()), this.getExtent().getMin().getX(), this.getExtent().getMax().getY());
        this.externalTransformation = (AffineTransform)this.ownTransformation.clone();
        this.open = true;
    }

    public IProjection getProjection() {
        if (this.proj == null) {
            try {
                this.proj = CRSFactory.getCRS((String)"EPSG:3857");
            }
            catch (Exception e) {
                logger.info("Projection not loaded", (Throwable)e);
            }
        }
        return this.proj;
    }

    public Extent getExtent() {
        return ((OSMCacheStruct)this.getTileServer().getStruct()).getWorldExtent();
    }

    private void reloadMetadataFromGrid() {
        this.externalTransformation = (AffineTransform)this.ownTransformation.clone();
        this.bandCount = 3;
        this.setDataType(new int[]{0, 0, 0});
    }

    public RasterProvider load() {
        return this;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void close() {
    }

    public URI translateURI(URI uri) {
        return uri;
    }

    public NoData getNoDataValue() {
        NoData nodata = super.getNoDataValue();
        if (nodata != null) {
            nodata.setNoDataTransparent(false);
        }
        return this.noData;
    }

    public void setView(Extent e) {
        this.viewRequest = new ExtentImpl(e);
    }

    public Extent getView() {
        return this.viewRequest;
    }

    public double getWidth() {
        int n = this.getTileServer().getStruct().getNumberOfLevels() - 1;
        return this.getExtent().width() / this.getTileServer().getStruct().getPixelSizeByLevel(n);
    }

    public double getHeight() {
        int n = this.getTileServer().getStruct().getNumberOfLevels() - 1;
        return this.getExtent().width() / this.getTileServer().getStruct().getPixelSizeByLevel(n);
    }

    public Object readBlock(int pos, int blockHeight, double scale) throws InvalidSetViewException, FileNotOpenException, RasterDriverException, ProcessInterruptedException {
        return null;
    }

    public Object getData(int x, int y, int band) throws InvalidSetViewException, FileNotOpenException, RasterDriverException {
        return null;
    }

    public int getBlockSize() {
        return 0;
    }

    public boolean isSupersampling() {
        return false;
    }

    public void setAffineTransform(AffineTransform t) {
        super.setAffineTransform(t);
    }

    public int getOverviewCount(int band) throws BandAccessException, RasterDriverException {
        if (band >= this.getBandCount()) {
            throw new BandAccessException("Wrong band");
        }
        return 0;
    }

    public int getOverviewWidth(int band, int overview) throws BandAccessException, RasterDriverException {
        if (band >= this.getBandCount()) {
            throw new BandAccessException("Wrong band");
        }
        return 0;
    }

    public int getOverviewHeight(int band, int overview) throws BandAccessException, RasterDriverException {
        if (band >= this.getBandCount()) {
            throw new BandAccessException("Wrong band");
        }
        return 0;
    }

    public boolean isOverviewsSupported() {
        return true;
    }

    public boolean isReproyectable() {
        return true;
    }

    public String getProviderName() {
        return NAME;
    }

    public String getName() {
        return this.getParameters().getOSMLayerName();
    }

    public String getFullName() {
        return this.uri.toString();
    }

    public OSMDataParameters getParameters() {
        return (OSMDataParameters)this.param;
    }

    public DataStoreTransparency getTransparency() {
        if (this.fileTransparency == null) {
            this.fileTransparency = new DataStoreTransparency(this.getColorInterpretation());
        }
        return this.fileTransparency;
    }

    public ColorInterpretation getColorInterpretation() {
        if (super.getColorInterpretation() == null) {
            super.setColorInterpretation((ColorInterpretation)DataStoreColorInterpretation.createRGBInterpretation());
        }
        return super.getColorInterpretation();
    }

    public void setStatus(RasterProvider provider) {
        if (provider instanceof OSMProvider) {
            // empty if block
        }
    }

    public boolean isTimeSupported() {
        return true;
    }

    public boolean isTiled() {
        return true;
    }

    public TileServer getTileServer() {
        if (this.tileServer == null) {
            DefaultRasterStore store = new DefaultRasterStore();
            store.setProvider((RasterProvider)this);
            this.tileServer = new OSMTileServer((RasterDataStore)store, ((OSMDataParameters)this.param).getTileSuffix(), ((OSMDataParameters)this.param).getNumberOfLevels());
        }
        return this.tileServer;
    }

    public void loadBuffer(SpiRasterQuery query) throws ProcessInterruptedException, RasterDriverException {
    }

    public void addFile(File file) throws InvalidSourceException {
    }

    public void removeFile(File file) {
    }

    public String getFileSuffix() {
        return ((OSMDataParameters)this.getDataParameters()).getTileSuffix();
    }
}

