/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.topology.swing.impl;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.topology.lib.api.TopologyDataSet;
import org.gvsig.topology.swing.api.TopologySwingLocator;
import org.gvsig.topology.swing.api.TopologySwingServices;
import org.gvsig.topology.swing.impl.SelectDataSetDialogView;

public class SelectDataSetDialog
extends SelectDataSetDialogView {
    private final TopologySwingServices services = TopologySwingLocator.getTopologySwingManager().getDefaultServices();
    private Dialog dialog = null;

    SelectDataSetDialog() {
        this.initComponents();
    }

    private void initComponents() {
        this.lstTables.setModel(this.services.getTablesListModel());
        this.lstTables.setSelectedIndex(-1);
        this.lstTables.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SelectDataSetDialog.this.performTableSelected();
            }
        });
        this.treeDataSets.setModel(this.services.getDataSetTreeModel());
        this.expandAll(this.treeDataSets);
        this.treeDataSets.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                SelectDataSetDialog.this.performDataSetSelected();
            }
        });
        this.treeDataSets.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                ImageIcon icon = SelectDataSetDialog.this.services.getTreeIcon(tree.getModel(), value);
                label.setIcon(icon);
                label.setText(Objects.toString(value, ""));
                return label;
            }
        });
        this.setPreferredSize(new Dimension(350, 400));
        this.translate();
    }

    private void expandAll(JTree tree) {
        for (int r = 0; r < tree.getRowCount(); ++r) {
            tree.expandRow(r);
        }
    }

    private void translate() {
        ToolsSwingManager tsm = ToolsSwingLocator.getToolsSwingManager();
        tsm.translate(this.lblName);
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
    }

    private void setOkButtonEnabled(boolean enabled) {
        if (this.dialog == null) {
            return;
        }
        this.dialog.setButtonEnabled(1, enabled);
    }

    private List<TopologyDataSet> getSelectedDataSets() {
        List tables;
        ArrayList<TopologyDataSet> datasets = new ArrayList<TopologyDataSet>();
        TreePath[] paths = this.treeDataSets.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                Object element = path.getLastPathComponent();
                if (!(element instanceof TopologyDataSet)) continue;
                TopologyDataSet dataSet = (TopologyDataSet)element;
                datasets.add(dataSet);
            }
        }
        if ((tables = this.lstTables.getSelectedValuesList()) != null) {
            datasets.addAll(tables);
        }
        return datasets;
    }

    public List<TopologyDataSet> getDataSets() {
        String name;
        List<TopologyDataSet> dataSets = this.getSelectedDataSets();
        if (dataSets == null || dataSets.isEmpty()) {
            return null;
        }
        if (dataSets.size() == 1 && !StringUtils.isEmpty((CharSequence)(name = this.txtName.getText()))) {
            dataSets.get(0).setName(name);
        }
        return dataSets;
    }

    public void performDataSetSelected() {
        List<TopologyDataSet> dataSets = this.getSelectedDataSets();
        if (dataSets == null || dataSets.isEmpty()) {
            this.txtName.setText("");
            this.setOkButtonEnabled(false);
        } else {
            this.txtName.setText(dataSets.get(0).getName());
            this.setOkButtonEnabled(true);
        }
    }

    public void performTableSelected() {
        TopologyDataSet dataset = (TopologyDataSet)this.lstTables.getSelectedValue();
        if (dataset == null) {
            return;
        }
        this.txtName.setText(dataset.getName());
        this.setOkButtonEnabled(true);
    }
}

