/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.tools.Listeners;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionUtils;
import org.gvsig.featureform.swing.CreateJFeatureFormException;
import org.gvsig.featureform.swing.JFeaturesForm;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Circle;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.layers.vectorial.SpatialEvaluatorsFactory;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.EnvelopeEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.AbstractToolListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.RectangleListener;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.identitymanagement.IdentityUtils;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.service.ServiceException;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeEditorPointListener
extends AbstractToolListener
implements RectangleListener {
    private static Logger LOGGER = LoggerFactory.getLogger(AttributeEditorPointListener.class);
    public static final String ATTRIBUTE_EDITOR_TOOL_NAME = "attributeEditorTool";
    private static final String ATTRIBUTE_EDITOR_FORM_NAME = "attributeEditorForm";
    private final MapControl mapControl;
    private JFeaturesForm form;
    private Predicate<FeatureStore> refreshCallback;
    private Observer refreshFormObserver;
    private WindowManager.MODE windowMode;

    public AttributeEditorPointListener(MapControl mapControl, JFeaturesForm form) {
        this.mapControl = mapControl;
        this.form = form;
        this.windowMode = WindowManager.MODE.TOOL;
        this.refreshFormObserver = (o, o1) -> this.doRefreshFormObserver(o, o1);
    }

    public AttributeEditorPointListener(MapControl mapControl) {
        this.mapControl = mapControl;
        this.windowMode = WindowManager.MODE.TOOL;
        this.refreshFormObserver = (o, o1) -> this.doRefreshFormObserver(o, o1);
    }

    private void toggleWindowMode() {
        if (this.form == null) {
            this.windowMode = this.windowMode == WindowManager.MODE.SDIWINDOW ? WindowManager.MODE.TOOL : WindowManager.MODE.SDIWINDOW;
        }
    }

    private FLyrVect getLayer() {
        FLayer[] layers = this.mapControl.getMapContext().getLayers().getActives();
        if (layers == null || layers.length != 1) {
            return null;
        }
        return (FLyrVect)layers[0];
    }

    public void showOrUpdateForm(boolean externalWindow) {
        this.windowMode = externalWindow ? WindowManager.MODE.SDIWINDOW : WindowManager.MODE.TOOL;
        this.showOrUpdateForm();
    }

    public void showOrUpdateForm() {
        String layerName = "";
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        try {
            FLyrVect layer = this.getLayer();
            if (layer == null) {
                return;
            }
            layerName = layer.getName();
            FeatureStore store = layer.getFeatureStore();
            if (store.isFeatureSelectionEmpty()) {
                return;
            }
            FeatureSelection selection = store.getFeatureSelectionQuietly();
            Expression filter = selection.makeFilter(100);
            if (filter == null) {
                String msg = i18nManager.getTranslation("_Unable_to_get_filter_for_XlayernameX_layer_selection", new String[]{layerName});
                ToolsSwingLocator.getThreadSafeDialogsManager().message(msg, 2);
                return;
            }
            if (selection.size() > 100) {
                String msg = i18nManager.getTranslation("_Too_many_items_selected_Only_the_first_100_will_be_displayed", new String[]{layerName});
                ToolsSwingLocator.getThreadSafeDialogsManager().message(msg, 2);
            }
            FeatureQuery query = store.createFeatureQuery(filter);
            this.showOrUpdateForm(layer, query);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't show attribute information from selection on the layer " + layerName, (Throwable)ex);
            String msg = i18nManager.getTranslation("_Cant_show_attribute_information_for_layer_XlayernameX_on_selection", new String[]{layerName});
            ToolsSwingLocator.getThreadSafeDialogsManager().messageDialog(msg, i18nManager.getTranslation("attribute_editor"), 2);
        }
    }

    private void showOrUpdateForm(FLyrVect layer, FeatureQuery query) {
        if (layer == null || query == null) {
            return;
        }
        String layerName = layer.getName();
        if (layerName == null) {
            layerName = "";
        }
        this.showOrUpdateForm(layerName, layer.getFeatureStore(), query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showOrUpdateForm(String storeName, FeatureStore featureStore, FeatureQuery query) {
        if (featureStore == null || query == null) {
            return;
        }
        if (!IdentityUtils.isAuthorized((String)"attribute-editor", (Object)featureStore, (String)featureStore.getFullName())) {
            return;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        try {
            FeatureStore featureStore2 = featureStore;
            synchronized (featureStore2) {
                boolean needshow = true;
                if (StringUtils.isBlank((CharSequence)storeName)) {
                    storeName = featureStore.getLabel();
                }
                System.out.println("form " + Objects.toString(this.form));
                if (this.form == null) {
                    this.form = this.getForm(featureStore, query);
                    needshow = true;
                } else if (this.form.getFeatureStore() != featureStore) {
                    this.disposeForm();
                    this.form = this.getForm(featureStore, query);
                    needshow = true;
                } else {
                    this.form.setQuery(query);
                    needshow = false;
                }
                List values = this.form.getFormset().getValues();
                FeatureSelection selection = (FeatureSelection)featureStore.getSelection();
                selection.deselectAll();
                FeatureSelection selectionTmp = featureStore.createFeatureSelection();
                for (Feature fof : values) {
                    selectionTmp.select(fof);
                }
                selection.select((FeatureSet)selectionTmp);
                if (needshow) {
                    this.form.showForm(this.makeTitle("attribute_editor", storeName, featureStore.getName()), this.windowMode);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't show attribute information from point on the layer " + storeName, (Throwable)ex);
            String msg = i18n.getTranslation("Cant_show_attribute_information_for_layer_%1_on_point", new String[]{storeName});
            ToolsSwingLocator.getThreadSafeDialogsManager().messageDialog(msg, i18n.getTranslation("attribute_editor"), 2);
            this.disposeForm();
        }
    }

    private void disposeForm() {
        FeatureStore store;
        if (this.form != null && (store = this.form.getFeatureStore()) != null) {
            store.deleteObserver(this.refreshFormObserver);
        }
        DisposeUtils.disposeQuietly((Object)this.form);
        this.form = null;
    }

    public void setRefreshCallback(Predicate<FeatureStore> refreshCallback) {
        this.refreshCallback = refreshCallback;
    }

    private JFeaturesForm getForm(FeatureStore store, FeatureQuery query) throws CreateJFeatureFormException, ServiceException, DataException {
        if (this.form == null) {
            JFeaturesForm theForm;
            DataSwingManager swingManager = DALSwingLocator.getSwingManager();
            this.form = theForm = swingManager.createJFeaturesForm(store, query);
            this.form.setTerminateEditingOnClose(false);
            this.form.asJComponent().setName(ATTRIBUTE_EDITOR_FORM_NAME);
            this.form.asJComponent().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    AttributeEditorPointListener.this.disposeForm();
                }
            });
            this.form.addActionListener(e -> {
                switch (e.getActionCommand()) {
                    case "formAfterSave": 
                    case "formAfterDelete": {
                        if (this.refreshCallback == null) break;
                        this.refreshCallback.test(store);
                    }
                }
            });
            store.addObserver(this.refreshFormObserver);
        }
        return this.form;
    }

    private void doRefreshFormObserver(Observable o, Object o1) {
        if (this.form == null || !(o instanceof FeatureStore) || !(o1 instanceof FeatureStoreNotification)) {
            return;
        }
        try {
            Action refreshAction;
            FeatureStoreNotification n = (FeatureStoreNotification)o1;
            if (n.getType().equalsIgnoreCase("after_refresh") && (refreshAction = this.form.getFormset().getAction("refreshForm")) != null) {
                refreshAction.actionPerformed(null);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't refresh attribute editor", (Throwable)ex);
        }
    }

    private FeatureQuery queryByPoint(Point point, double tol) throws CreateGeometryException, DataException {
        GeometryManager manager = GeometryLocator.getGeometryManager();
        Circle circle = (Circle)manager.create(11, 0);
        circle.setPoints(point, tol);
        FLyrVect currentLayer = this.getLayer();
        if (currentLayer == null) {
            return null;
        }
        FeatureStore featureStore = currentLayer.getFeatureStore();
        FeatureQuery featureQuery = featureStore.createFeatureQuery();
        FeatureType featureType = featureStore.getDefaultFeatureType();
        featureQuery.setFeatureType(featureType);
        Geometry query_geo = currentLayer.transformToSourceCRS((Geometry)circle, true);
        IProjection query_proj = currentLayer.getMapContext().getProjection();
        if (currentLayer.getCoordTrans() != null) {
            query_proj = currentLayer.getCoordTrans().getPOrig();
        }
        Evaluator iee = SpatialEvaluatorsFactory.getInstance().intersects(query_geo, query_proj, featureStore);
        featureQuery.setFilter(iee);
        featureQuery.retrievesAllAttributes();
        return featureQuery;
    }

    public void rectangle(EnvelopeEvent e) throws BehaviorException {
        MouseEvent mouseEvent = e.getEvent();
        if (!((mouseEvent.getModifiersEx() & 0x40) != 0 && SwingUtilities.isLeftMouseButton(mouseEvent) || (mouseEvent.getModifiersEx() & 0x23C0) == 0 && SwingUtilities.isLeftMouseButton(mouseEvent))) {
            return;
        }
        String layerName = "";
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        try {
            FeatureQuery query;
            FLyrVect layer = this.getLayer();
            if (layer == null) {
                String msg = i18nManager.getTranslation("There_is_no_one_and_only_one_active_layer");
                ToolsSwingLocator.getThreadSafeDialogsManager().messageDialog(msg, i18nManager.getTranslation("attribute_editor"), 1);
                return;
            }
            layerName = layer.getName();
            Geometry geom = e.getWorldCoordRect().getGeometry();
            if (geom instanceof Point) {
                ViewPort vp = this.mapControl.getViewPort();
                double tolerance = vp.toMapDistance(layer.getDefaultTolerance());
                query = this.queryByPoint((Point)geom, tolerance);
            } else {
                FeatureStore store = layer.getFeatureStore();
                FeatureType featureType = store.getDefaultFeatureTypeQuietly();
                GeometryExpressionBuilder builder = GeometryExpressionUtils.createExpressionBuilder();
                String filter = builder.ST_Intersects((ExpressionBuilder.Value)builder.column(featureType.getDefaultGeometryAttributeName()), (ExpressionBuilder.Value)builder.geometry(e.getWorldCoordRect().getGeometry())).toString();
                query = store.createFeatureQuery(filter);
            }
            this.showOrUpdateForm(layer, query);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't show attribute information from point on the layer " + layerName, (Throwable)ex);
            String msg = i18nManager.getTranslation("Cant_show_attribute_information_for_layer_%1_on_point", new String[]{layerName});
            ToolsSwingLocator.getThreadSafeDialogsManager().messageDialog(msg, i18nManager.getTranslation("attribute_editor"), 2);
        }
    }

    public String makeTitle(String base, String docname, String docname2) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        base = i18n.getTranslation(base);
        String title = base + ": " + docname;
        if (StringUtils.isNotBlank((CharSequence)docname2) && !StringUtils.equals((CharSequence)docname, (CharSequence)docname2)) {
            title = title + " (" + docname2 + ")";
        }
        return title;
    }
}

