/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl;

import java.awt.geom.AffineTransform;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Set;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.coverage.BufferFactory;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.RasterService;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.DataStructFactory;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.datastruct.RasterLegend;
import org.gvsig.fmap.dal.coverage.exception.FileNotExistsException;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.exception.ROIException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.exception.RasterLegendIONotFound;
import org.gvsig.fmap.dal.coverage.filter.FilterLoader;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.grid.render.ImageDrawer;
import org.gvsig.fmap.dal.coverage.process.TaskEventManager;
import org.gvsig.fmap.dal.coverage.process.overview.OverviewBuilder;
import org.gvsig.fmap.dal.coverage.process.vector.Vectorization;
import org.gvsig.fmap.dal.coverage.store.DataServerWriter;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.fmap.dal.coverage.store.RasterWriter;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.fmap.dal.coverage.util.CRSUtils;
import org.gvsig.fmap.dal.coverage.util.ColorConversion;
import org.gvsig.fmap.dal.coverage.util.FileUtils;
import org.gvsig.fmap.dal.coverage.util.Historical;
import org.gvsig.fmap.dal.coverage.util.MathUtils;
import org.gvsig.fmap.dal.coverage.util.ProviderServices;
import org.gvsig.fmap.dal.coverage.util.RasterUtils;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.raster.impl.BufferFactoryImpl;
import org.gvsig.raster.impl.DefaultRasterService;
import org.gvsig.raster.impl.buffer.DefaultDataServerWriter;
import org.gvsig.raster.impl.buffer.DefaultRasterQuery;
import org.gvsig.raster.impl.buffer.RasterBuffer;
import org.gvsig.raster.impl.buffer.RasterMemoryBuffer;
import org.gvsig.raster.impl.buffer.cache.RasterCache;
import org.gvsig.raster.impl.buffer.cache.RasterReadOnlyBuffer;
import org.gvsig.raster.impl.datastruct.DefaultDataStructFactory;
import org.gvsig.raster.impl.datastruct.legend.GimpGradients;
import org.gvsig.raster.impl.datastruct.legend.GimpPalettes;
import org.gvsig.raster.impl.datastruct.legend.LegendgvSIG;
import org.gvsig.raster.impl.datastruct.legend.RasterLegendIO;
import org.gvsig.raster.impl.grid.filter.DefaultRasterFilterList;
import org.gvsig.raster.impl.grid.filter.FilterLoaderImpl;
import org.gvsig.raster.impl.grid.render.ImageDrawerImpl;
import org.gvsig.raster.impl.grid.roi.ROIStatistic;
import org.gvsig.raster.impl.grid.roi.VectorialROIImpl;
import org.gvsig.raster.impl.grid.roi.VectorialROIsReader;
import org.gvsig.raster.impl.grid.roi.VectorialROIsWriter;
import org.gvsig.raster.impl.process.DefaultTaskEventManager;
import org.gvsig.raster.impl.process.RasterTask;
import org.gvsig.raster.impl.process.RasterTaskQueue;
import org.gvsig.raster.impl.process.vector.PotraceVectorization;
import org.gvsig.raster.impl.store.ParamsImpl;
import org.gvsig.raster.impl.store.QueryableRaster;
import org.gvsig.raster.impl.store.writer.DefaultRasterWriter;
import org.gvsig.raster.roi.AbstractROI;
import org.gvsig.raster.roi.ROIReader;
import org.gvsig.raster.roi.ROIWriter;
import org.gvsig.raster.roi.VectorialROI;
import org.gvsig.raster.util.DefaultColorConversion;
import org.gvsig.raster.util.DefaultFileUtils;
import org.gvsig.raster.util.DefaultHistorical;
import org.gvsig.raster.util.DefaultMathUtils;
import org.gvsig.raster.util.DefaultProviderServices;
import org.gvsig.raster.util.DefaultRasterUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.service.ServiceException;

public class DefaultRasterManager
implements RasterManager {
    private static DefaultRasterManager internalInstance = new DefaultRasterManager();
    private FileUtils file = null;
    private MathUtils math = null;
    private RasterUtils util = null;
    private ProviderServices pInfo = null;
    private DefaultColorConversion colorConversion = null;
    private DataStructFactory dataStructFactory = null;
    public static HashMap<String, OverviewBuilder> overviewBuilderRegistry = new HashMap();
    public static CRSUtils crsUtilRegistry = null;

    public static DefaultRasterManager getInstance() {
        return internalInstance;
    }

    public DataStructFactory getDataStructFactory() {
        if (this.dataStructFactory == null) {
            this.dataStructFactory = new DefaultDataStructFactory();
        }
        return this.dataStructFactory;
    }

    public ProviderServices getProviderServices() {
        if (this.pInfo == null) {
            this.pInfo = new DefaultProviderServices();
        }
        return this.pInfo;
    }

    public boolean isCRSUtilSupported() {
        return crsUtilRegistry != null;
    }

    public CRSUtils getCRSUtils() {
        return crsUtilRegistry;
    }

    public FileUtils getFileUtils() {
        if (this.file == null) {
            this.file = new DefaultFileUtils();
        }
        return this.file;
    }

    public RasterUtils getRasterUtils() {
        if (this.util == null) {
            this.util = new DefaultRasterUtils();
        }
        return this.util;
    }

    public MathUtils getMathUtils() {
        if (this.math == null) {
            this.math = new DefaultMathUtils();
        }
        return this.math;
    }

    public RasterService getRasterService() throws ServiceException {
        DefaultRasterService fc = new DefaultRasterService(this);
        return fc;
    }

    public String[] getLegendFormats() {
        return RasterLegendIO.formats;
    }

    public RasterLegend getRasterLegendIO(String formatName) throws RasterLegendIONotFound {
        if (formatName.equals(RasterLegendIO.formats[0])) {
            return new LegendgvSIG();
        }
        if (formatName.equals(RasterLegendIO.formats[1])) {
            return new GimpGradients();
        }
        if (formatName.equals(RasterLegendIO.formats[2])) {
            return new GimpPalettes();
        }
        throw new RasterLegendIONotFound();
    }

    public DataServerWriter createDataServerWriter() {
        return new DefaultDataServerWriter();
    }

    public RasterQuery createQuery() {
        return new DefaultRasterQuery();
    }

    public Buffer createBuffer(int dataType, int width, int height, int bandNr, boolean malloc) {
        if (RasterBuffer.forceToLoadInCache) {
            return new RasterCache(dataType, width, height, bandNr);
        }
        if (RasterBuffer.forceToLoadInReadOnlyCache) {
            return new RasterReadOnlyBuffer(dataType, width, height, bandNr);
        }
        if (RasterBuffer.cacheOn) {
            long ms1;
            long size = (long)this.getRasterUtils().getBytesFromRasterBufType(dataType) * (long)width * (long)height * (long)bandNr / 1024L;
            if (size <= (ms1 = RasterLibrary.cacheSize * 1024L)) {
                return new RasterMemoryBuffer(dataType, width, height, bandNr, malloc);
            }
            return new RasterCache(dataType, width, height, bandNr);
        }
        return new RasterMemoryBuffer(dataType, width, height, bandNr, malloc);
    }

    public Buffer createReadOnlyBuffer(int dataType, int width, int height, int bandNr) {
        return new RasterReadOnlyBuffer(dataType, width, height, bandNr);
    }

    public Buffer createMemoryBuffer(int dataType, int width, int height, int bandNr, boolean malloc) {
        return new RasterMemoryBuffer(dataType, width, height, bandNr, malloc);
    }

    public RasterWriter createWriter(String fName) throws NotSupportedExtensionException, RasterDriverException {
        String ext = this.getFileUtils().getExtensionFromFileName(fName);
        DefaultRasterWriter grw = null;
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.get("RasterWriter");
        if (!point.has(ext)) {
            return grw;
        }
        Class clase = point.get(ext).getExtension();
        Class[] args = new Class[]{String.class};
        try {
            Constructor hazNuevo = clase.getConstructor(args);
            Object[] args2 = new Object[]{fName};
            grw = (DefaultRasterWriter)hazNuevo.newInstance(args2);
        }
        catch (SecurityException e) {
            throw new RasterDriverException("Error SecurityException in open", (Exception)e);
        }
        catch (NoSuchMethodException e) {
            throw new RasterDriverException("Error NoSuchMethodException in open", (Exception)e);
        }
        catch (IllegalArgumentException e) {
            throw new RasterDriverException("Error IllegalArgumentException in open", (Exception)e);
        }
        catch (InstantiationException e) {
            throw new RasterDriverException("Error InstantiationException in open", (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new RasterDriverException("Error IllegalAccessException in open", (Exception)e);
        }
        catch (InvocationTargetException e) {
            throw new NotSupportedExtensionException("Error in open", (Exception)e);
        }
        return grw;
    }

    public RasterWriter createWriter(DataServerWriter dataWriter, String outFileName, int nBands, AffineTransform at, int outSizeX, int outSizeY, int dataType, Params params, IProjection proj) throws NotSupportedExtensionException, RasterDriverException {
        return this.createWriter(dataWriter, outFileName, nBands, at, outSizeX, outSizeY, dataType, params, proj, true);
    }

    public RasterWriter createWriter(DataServerWriter dataWriter, String outFileName, int nBands, AffineTransform at, int outSizeX, int outSizeY, int dataType, Params params, IProjection proj, boolean geo) throws NotSupportedExtensionException, RasterDriverException {
        String ext = outFileName.toLowerCase().substring(outFileName.lastIndexOf(46) + 1);
        DefaultRasterWriter grw = null;
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.get("RasterWriter");
        if (!point.has(ext)) {
            return grw;
        }
        Class clase = point.get(ext).getExtension();
        Class[] args = new Class[]{DataServerWriter.class, String.class, Integer.class, AffineTransform.class, Integer.class, Integer.class, Integer.class, Params.class, IProjection.class, Boolean.class};
        try {
            Constructor hazNuevo = clase.getConstructor(args);
            Object[] args2 = new Object[]{dataWriter, outFileName, new Integer(nBands), at, new Integer(outSizeX), new Integer(outSizeY), new Integer(dataType), params, proj, new Boolean(geo)};
            grw = (DefaultRasterWriter)hazNuevo.newInstance(args2);
        }
        catch (SecurityException e) {
            throw new RasterDriverException("Error SecurityException in open", (Exception)e);
        }
        catch (NoSuchMethodException e) {
            throw new RasterDriverException("Error NoSuchMethodException in open", (Exception)e);
        }
        catch (IllegalArgumentException e) {
            throw new RasterDriverException("Error IllegalArgumentException in open", (Exception)e);
        }
        catch (InstantiationException e) {
            throw new RasterDriverException("Error InstantiationException in open", (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new RasterDriverException("Error IllegalAccessException in open", (Exception)e);
        }
        catch (InvocationTargetException e) {
            throw new NotSupportedExtensionException("Error in open. Problemas con las librer\u00edas nativas.", (Exception)e);
        }
        return grw;
    }

    public Params createWriterParams(String fileName) {
        try {
            return this.createWriter(fileName).getParams();
        }
        catch (NotSupportedExtensionException e) {
            return null;
        }
        catch (RasterDriverException e) {
            return null;
        }
    }

    public Vectorization getVectorizeObject(QueryableRaster queryable) throws QueryException, ProcessInterruptedException {
        return new PotraceVectorization(queryable);
    }

    public OverviewBuilder getOverviewBuilder(String id) {
        return overviewBuilderRegistry.get(id);
    }

    public boolean isOverviewBuilderSupported() {
        return overviewBuilderRegistry.size() > 0;
    }

    public Set<String> getOverviewBuilderKeyList() {
        return overviewBuilderRegistry.keySet();
    }

    public FilterLoader createFilterLoader(int dataType) {
        return new FilterLoaderImpl(dataType);
    }

    public FilterLoader createFilterLoader(RasterFilterList filterList) {
        return new FilterLoaderImpl(filterList);
    }

    public Historical createHistoricalService() {
        return new DefaultHistorical();
    }

    public ColorConversion getColorConversion() {
        if (this.colorConversion == null) {
            this.colorConversion = new DefaultColorConversion();
        }
        return this.colorConversion;
    }

    public Statistics createROIStatistics(AbstractROI roi) {
        return new ROIStatistic(roi);
    }

    public RasterFilterList createEmptyFilterList(int type) {
        DefaultRasterFilterList fl = new DefaultRasterFilterList();
        fl.setInitDataType(type);
        return fl;
    }

    public TaskEventManager getRasterTask() {
        return DefaultTaskEventManager.get();
    }

    public TaskEventManager createRasterTask(Object process) {
        RasterTask task = RasterTaskQueue.getRasterTask(Thread.currentThread().getId() + "");
        if (task != null) {
            DefaultTaskEventManager man = new DefaultTaskEventManager();
            man.setTask(task);
            return man;
        }
        DefaultTaskEventManager man = new DefaultTaskEventManager(process);
        return man;
    }

    public Params createParams(String id, Object value, int type, String[] list) {
        ParamsImpl params = new ParamsImpl();
        params.setParam(id, value, type, list);
        return params;
    }

    public ImageDrawer createImageDrawerService() {
        return new ImageDrawerImpl();
    }

    public BufferFactory getBufferFactory() {
        return new BufferFactoryImpl();
    }

    public ROIReader createROIReader(String filename, RasterDataStore store, IProjection projection) throws ROIException, FileNotExistsException {
        return new VectorialROIsReader(filename, store, projection);
    }

    public ROIWriter createROIWriter(String filename, IProjection projection) {
        return new VectorialROIsWriter(filename, projection);
    }

    public VectorialROI createVectorialROI(RasterDataStore store) {
        return new VectorialROIImpl(store);
    }

    public ROIReader createVectorialROIReader(FeatureStore roiStore, RasterDataStore store, IProjection projection) {
        return new VectorialROIsReader(roiStore, store, projection);
    }
}

