/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.buffer;

import org.gvsig.fmap.dal.coverage.dataset.BufferParam;
import org.gvsig.fmap.dal.coverage.datastruct.BandList;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;

public class BufferParamImpl
implements BufferParam {
    private int accessType = -1;
    private int dataType = 32;
    private int bandCount = 0;
    private int width = 0;
    private int height = 0;
    private int x = 0;
    private int y = 0;
    private boolean malloc = true;
    private RasterDataStore roDataSource = null;
    private BandList bandList = null;
    private int[] roWindow = null;
    private Extent roWindowExtent = null;

    public BufferParamImpl(int w, int h, int bandCount, int dataType, boolean malloc, int accessType) {
        this.width = w;
        this.height = h;
        this.bandCount = bandCount;
        this.dataType = dataType;
        this.setMalloc(malloc);
        this.accessType = accessType;
    }

    public BufferParamImpl(RasterDataStore roDataSource, int[] window, BandList bandList) {
        this.accessType = 1;
        this.setRoWindow(window);
        this.width = window[2] - window[0];
        this.height = window[3] - window[1];
        this.bandCount = bandList.getDrawableBandsCount();
        this.roDataSource = roDataSource;
    }

    public void setAccessType(int accessType) {
        this.accessType = accessType;
    }

    public int getAccessType() {
        return this.accessType;
    }

    public void setBandList(BandList bandList) {
        this.bandList = bandList;
    }

    public BandList getBandList() {
        return this.bandList;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public int getBandCount() {
        return this.bandCount;
    }

    public void setBandCount(int bandCount) {
        this.bandCount = bandCount;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setDataStore(RasterDataStore roDataSource) {
        this.roDataSource = roDataSource;
    }

    public RasterDataStore getDataStore() {
        return this.roDataSource;
    }

    public void setMalloc(boolean malloc) {
        this.malloc = malloc;
    }

    public boolean isMalloc() {
        return this.malloc;
    }

    public void setRoWindow(int[] roWindow) {
        this.roWindow = roWindow;
    }

    public int[] getRoWindow() {
        return this.roWindow;
    }

    public void setRoWindowExtent(Extent roWindow) {
        this.roWindowExtent = roWindow;
    }

    public Extent getRoWindowExtent() {
        return this.roWindowExtent;
    }
}

