/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.buffer.cache;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.fmap.dal.coverage.store.RasterWriter;
import org.gvsig.fmap.dal.coverage.util.FileUtils;
import org.gvsig.raster.impl.DefaultRasterManager;
import org.gvsig.raster.impl.buffer.cache.ICacheDataSource;
import org.gvsig.raster.impl.buffer.cache.PageBandBuffer;
import org.gvsig.raster.impl.buffer.cache.WriterBufferCompleteServer;
import org.gvsig.raster.impl.provider.AbstractRasterProvider;
import org.gvsig.raster.impl.store.DefaultRasterStore;
import org.gvsig.raster.impl.store.ParamImpl;

public class CacheDataServer
implements ICacheDataSource {
    private String tempDirectoryPath = null;
    private String id = null;
    private FileUtils file = RasterLocator.getManager().getFileUtils();

    public CacheDataServer(String id, int numBand, int numPag) {
        this.tempDirectoryPath = this.file.getTemporalPath();
        this.setName(id, numBand, numPag);
    }

    public void setName(String id, int numBand, int numPag) {
        String oldFileName = this.tempDirectoryPath + File.separator + this.id;
        this.id = id == null ? Long.toString(System.currentTimeMillis()) + "-" + numPag + "-" + numBand : id + "-" + numPag + "-" + numBand;
        String newFileName = this.tempDirectoryPath + File.separator + this.id;
        File newFile = new File(newFileName);
        File oldFile = new File(oldFileName);
        if (oldFile.exists()) {
            oldFile.renameTo(newFile);
        }
    }

    @Override
    public void loadPage(PageBandBuffer pageBuffer) {
        String inFileName = this.tempDirectoryPath + File.separator + this.id;
        File file = new File(inFileName);
        if (!file.exists()) {
            return;
        }
        try {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            this.read(dis, pageBuffer);
            dis.close();
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
    }

    @Override
    public void savePage(PageBandBuffer pageBuffer) throws IOException {
        this.tempDirectoryPath = this.file.getTemporalPath();
        String fileName = this.tempDirectoryPath + File.separator + this.id;
        File f = new File(fileName);
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
        this.save(dos, pageBuffer);
        dos.close();
    }

    @Override
    public void delete() {
        String fileName = this.tempDirectoryPath + File.separator + this.id;
        File f = new File(fileName);
        if (f.exists()) {
            f.delete();
        }
    }

    @Override
    public String getPath() {
        return this.tempDirectoryPath + File.separator + this.id;
    }

    public void cachear(String fileName, int pageLines) throws IOException, NotSupportedExtensionException, RasterDriverException, ProcessInterruptedException, QueryException {
        if (this.id == null) {
            this.id = Long.toString(System.currentTimeMillis());
        }
        AbstractRasterProvider provider = AbstractRasterProvider.singleDatasetInstance(null, fileName);
        int pages = (int)Math.ceil(provider.getHeight() / (double)pageLines);
        this.tempDirectoryPath = this.file.getTemporalPath();
        Buffer pageBuffer = null;
        DefaultRasterStore store = new DefaultRasterStore();
        store.setProvider(provider);
        int y = 0;
        for (int i = 0; i < pages; ++i) {
            RasterQuery q = RasterLocator.getManager().createQuery();
            q.setAreaOfInterest(new Rectangle(0, y, (int)provider.getWidth(), pageLines));
            q.setAllDrawableBands();
            pageBuffer = store.query(q);
            String outFileName = this.tempDirectoryPath + File.separator + this.id + "-" + i;
            File f = new File(outFileName);
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
            this.save(dos, pageBuffer);
            dos.close();
            y += pageLines;
        }
    }

    public void convertFromByteFileToTif(AbstractRasterProvider grf, PageBandBuffer pageBuffer, int pageLines) throws IOException, ProcessInterruptedException {
        int w = pageBuffer.getWidth();
        int h = pageBuffer.getHeight();
        int pages = (int)Math.ceil(grf.getHeight() / (double)pageLines);
        RasterWriter grw = null;
        PageBandBuffer pageBuffer2 = new PageBandBuffer(grf.getDataType()[0], (int)grf.getWidth(), pageLines, grf.getBandCount(), true, 0);
        for (int i = 0; i < pages; ++i) {
            String inFileName = this.tempDirectoryPath + File.separator + this.id + "-" + i;
            File f = new File(inFileName);
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(f)));
            switch (pageBuffer.getDataType()) {
                case 0: {
                    byte[] b = new byte[pageBuffer.getWidth() * pageBuffer.getHeight() * pageBuffer.getBandCount()];
                    dis.readFully(b);
                    for (int iBand = 0; iBand < pageBuffer.getBandCount(); ++iBand) {
                        for (int line = 0; line < pageBuffer.getHeight(); ++line) {
                            byte[] linea = new byte[w];
                            for (int d = 0; d < linea.length; ++d) {
                                linea[d] = b[iBand * w * h + line * w + d];
                            }
                            pageBuffer2.setLineInBandByte(linea, line, iBand);
                        }
                    }
                    break;
                }
            }
            dis.close();
            WriterBufferCompleteServer dataWriter1 = new WriterBufferCompleteServer(pageBuffer2);
            try {
                RasterWriter writer = DefaultRasterManager.getInstance().createWriter(inFileName + ".tif");
                Params params = writer.getParams();
                int newPosBlockSize = 7;
                ParamImpl p = (ParamImpl)params.getParamById("blocksize");
                for (int j = 0; j < p.getList().length; ++j) {
                    if (!p.getList()[i].equals(String.valueOf(pageLines))) continue;
                    newPosBlockSize = j;
                }
                params.changeParamValue("blocksize", (Object)new Integer(newPosBlockSize));
                grw = DefaultRasterManager.getInstance().createWriter(dataWriter1, inFileName + ".tif", pageBuffer2.getBandCount(), new AffineTransform(), pageBuffer2.getWidth(), pageBuffer2.getHeight(), pageBuffer2.getDataType(), params, null);
            }
            catch (NotSupportedExtensionException e) {
                e.printStackTrace();
            }
            catch (RasterDriverException e) {
                e.printStackTrace();
            }
            grw.dataWrite();
            grw.writeClose();
        }
    }

    private void save(DataOutputStream dos, Buffer pageBuffer) throws IOException {
        switch (pageBuffer.getDataType()) {
            case 0: {
                for (int iBand = 0; iBand < pageBuffer.getBandCount(); ++iBand) {
                    for (int line = 0; line < pageBuffer.getHeight(); ++line) {
                        dos.write(pageBuffer.getLineFromBandByte(line, iBand));
                    }
                }
                break;
            }
            case 2: {
                for (int iBand = 0; iBand < pageBuffer.getBandCount(); ++iBand) {
                    for (int line = 0; line < pageBuffer.getHeight(); ++line) {
                        for (int col = 0; col < pageBuffer.getWidth(); ++col) {
                            dos.writeShort(pageBuffer.getElemShort(line, col, iBand));
                        }
                    }
                }
                break;
            }
            case 3: {
                for (int iBand = 0; iBand < pageBuffer.getBandCount(); ++iBand) {
                    for (int line = 0; line < pageBuffer.getHeight(); ++line) {
                        for (int col = 0; col < pageBuffer.getWidth(); ++col) {
                            dos.writeInt(pageBuffer.getElemInt(line, col, iBand));
                        }
                    }
                }
                break;
            }
            case 4: {
                for (int iBand = 0; iBand < pageBuffer.getBandCount(); ++iBand) {
                    for (int line = 0; line < pageBuffer.getHeight(); ++line) {
                        for (int col = 0; col < pageBuffer.getWidth(); ++col) {
                            dos.writeFloat(pageBuffer.getElemFloat(line, col, iBand));
                        }
                    }
                }
                break;
            }
            case 5: {
                for (int iBand = 0; iBand < pageBuffer.getBandCount(); ++iBand) {
                    for (int line = 0; line < pageBuffer.getHeight(); ++line) {
                        for (int col = 0; col < pageBuffer.getWidth(); ++col) {
                            dos.writeDouble(pageBuffer.getElemDouble(line, col, iBand));
                        }
                    }
                }
                break;
            }
        }
    }

    private void read(DataInputStream dis, PageBandBuffer pageBuffer) throws IOException {
        int w = pageBuffer.getWidth();
        int h = pageBuffer.getHeight();
        int wxh = w * h;
        switch (pageBuffer.getDataType()) {
            case 0: {
                byte[] b = new byte[pageBuffer.getWidth() * pageBuffer.getHeight() * pageBuffer.getBandCount()];
                dis.readFully(b);
                for (int iBand = 0; iBand < pageBuffer.getBandCount(); ++iBand) {
                    for (int line = 0; line < pageBuffer.getHeight(); ++line) {
                        byte[] linea = new byte[w];
                        for (int d = 0; d < linea.length; ++d) {
                            linea[d] = b[iBand * wxh + line * w + d];
                        }
                        pageBuffer.setLineInBandByte(linea, line, iBand);
                    }
                }
                break;
            }
            case 2: {
                int j;
                short[] s = new short[pageBuffer.getWidth() * pageBuffer.getHeight() * pageBuffer.getBandCount()];
                for (j = 0; j < s.length; ++j) {
                    s[j] = dis.readShort();
                }
                for (int iBand = 0; iBand < pageBuffer.getBandCount(); ++iBand) {
                    for (int line = 0; line < pageBuffer.getHeight(); ++line) {
                        short[] linea = new short[w];
                        for (int x = 0; x < linea.length; ++x) {
                            linea[x] = s[iBand * wxh + line * w + x];
                        }
                        pageBuffer.setLineInBandShort(linea, line, iBand);
                    }
                }
                break;
            }
            case 3: {
                int j;
                int[] i = new int[pageBuffer.getWidth() * pageBuffer.getHeight() * pageBuffer.getBandCount()];
                while (j < i.length) {
                    i[j] = dis.readInt();
                    ++j;
                }
                for (int iBand = 0; iBand < pageBuffer.getBandCount(); ++iBand) {
                    for (int line = 0; line < pageBuffer.getHeight(); ++line) {
                        int[] linea = new int[w];
                        for (int x = 0; x < linea.length; ++x) {
                            linea[x] = i[iBand * wxh + line * w + x];
                        }
                        pageBuffer.setLineInBandInt(linea, line, iBand);
                    }
                }
                break;
            }
            case 4: {
                int j;
                float[] f = new float[pageBuffer.getWidth() * pageBuffer.getHeight() * pageBuffer.getBandCount()];
                while (j < f.length) {
                    f[j] = dis.readFloat();
                    ++j;
                }
                for (int iBand = 0; iBand < pageBuffer.getBandCount(); ++iBand) {
                    for (int line = 0; line < pageBuffer.getHeight(); ++line) {
                        float[] linea = new float[w];
                        for (int x = 0; x < linea.length; ++x) {
                            linea[x] = f[iBand * wxh + line * w + x];
                        }
                        pageBuffer.setLineInBandFloat(linea, line, iBand);
                    }
                }
                break;
            }
            case 5: {
                int j;
                double[] d = new double[pageBuffer.getWidth() * pageBuffer.getHeight() * pageBuffer.getBandCount()];
                while (j < d.length) {
                    d[j] = dis.readDouble();
                    ++j;
                }
                for (int iBand = 0; iBand < pageBuffer.getBandCount(); ++iBand) {
                    for (int line = 0; line < pageBuffer.getHeight(); ++line) {
                        double[] linea = new double[w];
                        for (int x = 0; x < linea.length; ++x) {
                            linea[x] = d[iBand * wxh + line * w + x];
                        }
                        pageBuffer.setLineInBandDouble(linea, line, iBand);
                    }
                }
                break;
            }
        }
    }
}

