/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.buffer.cache;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.coverage.dataset.AbstractBuffer;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.Band;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.process.IncrementableTask;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.props.HistogramComputer;
import org.gvsig.raster.impl.buffer.BufferHistogramComputer;
import org.gvsig.raster.impl.buffer.BufferInterpolation;
import org.gvsig.raster.impl.buffer.cache.HddPage;
import org.gvsig.raster.impl.buffer.cache.PageBandBuffer;
import org.gvsig.raster.impl.process.RasterTask;
import org.gvsig.raster.impl.process.RasterTaskQueue;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.visitor.Visitor;

public class PageBuffer
extends AbstractBuffer
implements Buffer {
    private PageBandBuffer[] pageBandBuffer = null;
    private double[] limits = null;
    private HistogramComputer histogramComputer = null;
    private BufferInterpolation interp = null;

    public PageBuffer(int dataType, int width, int height, int bandNr, boolean malloc, int nHddPags) {
        this.pageBandBuffer = new PageBandBuffer[bandNr];
        for (int i = 0; i < this.pageBandBuffer.length; ++i) {
            this.pageBandBuffer[i] = new PageBandBuffer(dataType, width, height, 1, malloc, i);
        }
    }

    public boolean isBandSwitchable() {
        return false;
    }

    public void setHddPages(HddPage[] hddList) {
        for (int i = 0; i < this.pageBandBuffer.length; ++i) {
            this.pageBandBuffer[i].setHddPages(hddList);
        }
    }

    public void loadPage(int nPag) {
        for (int i = 0; i < this.pageBandBuffer.length; ++i) {
            try {
                this.pageBandBuffer[i].loadPage(nPag);
                continue;
            }
            catch (ProcessInterruptedException e) {
                break;
            }
        }
    }

    public void savePage(int nPag) throws IOException {
        for (int i = 0; i < this.pageBandBuffer.length; ++i) {
            this.pageBandBuffer[i].savePage(nPag);
        }
    }

    public void assign(int band, byte value) {
        this.pageBandBuffer[band].assign(0, value);
    }

    public void assign(int band, short value) {
        this.pageBandBuffer[band].assign(0, value);
    }

    public void assign(int band, int value) {
        this.pageBandBuffer[band].assign(0, value);
    }

    public void assign(int band, float value) {
        this.pageBandBuffer[band].assign(0, value);
    }

    public void assign(int band, double value) {
        this.pageBandBuffer[band].assign(0, value);
    }

    public void assignBand(int nBand, Band band) {
    }

    public void assignBandToNotValid(int Band2) {
    }

    public Buffer cloneBuffer() {
        return null;
    }

    public void copyBand(int nBand, Band band) {
    }

    public Band createBand(byte defaultValue) {
        return null;
    }

    public Band getBand(int nBand) {
        return null;
    }

    public Buffer getBandBuffer(int nBand) {
        return null;
    }

    public int getBandCount() {
        return this.pageBandBuffer[0].getBandCount();
    }

    public int getDataType() {
        return this.pageBandBuffer[0].getDataType();
    }

    public void setDataType(int dataType) {
    }

    public int getBlockHeight() {
        return this.pageBandBuffer[0].getHeight();
    }

    public int getHeight() {
        return this.pageBandBuffer[0].getHeight();
    }

    public int getWidth() {
        return this.pageBandBuffer[0].getWidth();
    }

    public NoData getNoDataValue() {
        return this.pageBandBuffer[0].getNoDataValue();
    }

    public double getNotValidValue() {
        return this.pageBandBuffer[0].getNotValidValue();
    }

    public byte getElemByte(int line, int col, int band) {
        return this.pageBandBuffer[band].getElemByte(line, col, 0);
    }

    public short getElemShort(int line, int col, int band) {
        return this.pageBandBuffer[band].getElemShort(line, col, 0);
    }

    public int getElemInt(int line, int col, int band) {
        return this.pageBandBuffer[band].getElemInt(line, col, 0);
    }

    public float getElemFloat(int line, int col, int band) {
        return this.pageBandBuffer[band].getElemFloat(line, col, 0);
    }

    public double getElemDouble(int line, int col, int band) {
        return this.pageBandBuffer[band].getElemDouble(line, col, 0);
    }

    public void getElemByte(int line, int col, byte[] data) {
        for (int i = 0; i < this.pageBandBuffer.length; ++i) {
            data[i] = this.pageBandBuffer[i].getElemByte(line, col, 0);
        }
    }

    public void getElemShort(int line, int col, short[] data) {
        for (int i = 0; i < this.pageBandBuffer.length; ++i) {
            data[i] = this.pageBandBuffer[i].getElemShort(line, col, 0);
        }
    }

    public void getElemInt(int line, int col, int[] data) {
        for (int i = 0; i < this.pageBandBuffer.length; ++i) {
            data[i] = this.pageBandBuffer[i].getElemInt(line, col, 0);
        }
    }

    public void getElemFloat(int line, int col, float[] data) {
        for (int i = 0; i < this.pageBandBuffer.length; ++i) {
            data[i] = this.pageBandBuffer[i].getElemFloat(line, col, 0);
        }
    }

    public void getElemDouble(int line, int col, double[] data) {
        for (int i = 0; i < this.pageBandBuffer.length; ++i) {
            data[i] = this.pageBandBuffer[i].getElemDouble(line, col, 0);
        }
    }

    public byte[][] getLineByte(int line) {
        byte[][] b = new byte[this.pageBandBuffer.length][];
        for (int i = 0; i < this.pageBandBuffer.length; ++i) {
            b[i] = this.pageBandBuffer[i].getLineByte(line)[0];
        }
        return b;
    }

    public double[][] getLineDouble(int line) {
        double[][] d = new double[this.pageBandBuffer.length][];
        for (int i = 0; i < this.pageBandBuffer.length; ++i) {
            d[i] = this.pageBandBuffer[i].getLineDouble(line)[0];
        }
        return d;
    }

    public float[][] getLineFloat(int line) {
        float[][] f = new float[this.pageBandBuffer.length][];
        for (int i = 0; i < this.pageBandBuffer.length; ++i) {
            f[i] = this.pageBandBuffer[i].getLineFloat(line)[0];
        }
        return f;
    }

    public int[][] getLineInt(int line) {
        int[][] in = new int[this.pageBandBuffer.length][];
        for (int i = 0; i < this.pageBandBuffer.length; ++i) {
            in[i] = this.pageBandBuffer[i].getLineInt(line)[0];
        }
        return in;
    }

    public short[][] getLineShort(int line) {
        short[][] s = new short[this.pageBandBuffer.length][];
        for (int i = 0; i < this.pageBandBuffer.length; ++i) {
            s[i] = this.pageBandBuffer[i].getLineShort(line)[0];
        }
        return s;
    }

    public byte[] getLineFromBandByte(int line, int band) {
        return this.pageBandBuffer[band].getLineFromBandByte(line, 0);
    }

    public double[] getLineFromBandDouble(int line, int band) {
        return this.pageBandBuffer[band].getLineFromBandDouble(line, 0);
    }

    public float[] getLineFromBandFloat(int line, int band) {
        return this.pageBandBuffer[band].getLineFromBandFloat(line, 0);
    }

    public int[] getLineFromBandInt(int line, int band) {
        return this.pageBandBuffer[band].getLineFromBandInt(line, 0);
    }

    public short[] getLineFromBandShort(int line, int band) {
        return this.pageBandBuffer[band].getLineFromBandShort(line, 0);
    }

    public void interchangeBands(int band1, int band2) {
    }

    public void mallocOneBand(int dataType, int width, int height, int band) {
    }

    public void replicateBand(int orig, int dest) {
    }

    public void setElem(int line, int col, int band, byte data) {
        this.pageBandBuffer[band].setElem(line, col, 0, data);
    }

    public void setElem(int line, int col, int band, short data) {
        this.pageBandBuffer[band].setElem(line, col, 0, data);
    }

    public void setElem(int line, int col, int band, int data) {
        this.pageBandBuffer[band].setElem(line, col, 0, data);
    }

    public void setElem(int line, int col, int band, float data) {
        this.pageBandBuffer[band].setElem(line, col, 0, data);
    }

    public void setElem(int line, int col, int band, double data) {
        this.pageBandBuffer[band].setElem(line, col, 0, data);
    }

    public void setElemByte(int line, int col, byte[] data) {
        byte[] b = new byte[1];
        for (int i = 0; i < this.pageBandBuffer.length; ++i) {
            b[0] = data[i];
            this.pageBandBuffer[i].setElemByte(line, col, b);
        }
    }

    public void setElemDouble(int line, int col, double[] data) {
        double[] b = new double[1];
        for (int i = 0; i < this.pageBandBuffer.length; ++i) {
            b[0] = data[i];
            this.pageBandBuffer[i].setElemDouble(line, col, b);
        }
    }

    public void setElemFloat(int line, int col, float[] data) {
        float[] b = new float[1];
        for (int i = 0; i < this.pageBandBuffer.length; ++i) {
            b[0] = data[i];
            this.pageBandBuffer[i].setElemFloat(line, col, b);
        }
    }

    public void setElemInt(int line, int col, int[] data) {
        int[] b = new int[1];
        for (int i = 0; i < this.pageBandBuffer.length; ++i) {
            b[0] = data[i];
            this.pageBandBuffer[i].setElemInt(line, col, b);
        }
    }

    public void setElemShort(int line, int col, short[] data) {
        short[] b = new short[1];
        for (int i = 0; i < this.pageBandBuffer.length; ++i) {
            b[0] = data[i];
            this.pageBandBuffer[i].setElemShort(line, col, b);
        }
    }

    public void setLineByte(byte[][] data, int line) {
        byte[][] bAux = new byte[1][];
        for (int i = 0; i < this.pageBandBuffer.length; ++i) {
            bAux[0] = data[i];
            this.pageBandBuffer[i].setLineByte(bAux, line);
        }
    }

    public void setLineDouble(double[][] data, int line) {
        double[][] bAux = new double[1][];
        for (int i = 0; i < this.pageBandBuffer.length; ++i) {
            bAux[0] = data[i];
            this.pageBandBuffer[i].setLineDouble(bAux, line);
        }
    }

    public void setLineFloat(float[][] data, int line) {
        float[][] bAux = new float[1][];
        for (int i = 0; i < this.pageBandBuffer.length; ++i) {
            bAux[0] = data[i];
            this.pageBandBuffer[i].setLineFloat(bAux, line);
        }
    }

    public void setLineInt(int[][] data, int line) {
        int[][] bAux = new int[1][];
        for (int i = 0; i < this.pageBandBuffer.length; ++i) {
            bAux[0] = data[i];
            this.pageBandBuffer[i].setLineInt(bAux, line);
        }
    }

    public void setLineShort(short[][] data, int line) {
        short[][] bAux = new short[1][];
        for (int i = 0; i < this.pageBandBuffer.length; ++i) {
            bAux[0] = data[i];
            this.pageBandBuffer[i].setLineShort(bAux, line);
        }
    }

    public void setLineInBandByte(byte[] data, int line, int band) {
        this.pageBandBuffer[band].setLineInBandByte(data, line, 0);
    }

    public void setLineInBandDouble(double[] data, int line, int band) {
        this.pageBandBuffer[band].setLineInBandDouble(data, line, 0);
    }

    public void setLineInBandFloat(float[] data, int line, int band) {
        this.pageBandBuffer[band].setLineInBandFloat(data, line, 0);
    }

    public void setLineInBandInt(int[] data, int line, int band) {
        this.pageBandBuffer[band].setLineInBandInt(data, line, 0);
    }

    public void setLineInBandShort(short[] data, int line, int band) {
        this.pageBandBuffer[band].setLineInBandShort(data, line, 0);
    }

    public void setNoDataValue(NoData nd) {
        for (int i = 0; i < this.pageBandBuffer.length; ++i) {
            this.pageBandBuffer[0].setNoDataValue(nd);
        }
    }

    public void setNotValidValue(double value) {
    }

    public void switchBands(int[] bands) {
    }

    public double getMinimum() {
        if (this.limits == null) {
            try {
                this.limits = this.getLimits();
            }
            catch (ProcessInterruptedException e) {
                return 0.0;
            }
        }
        return this.limits[0];
    }

    public double getMaximum() {
        if (this.limits == null) {
            try {
                this.limits = this.getLimits();
            }
            catch (ProcessInterruptedException e) {
                return 0.0;
            }
        }
        return this.limits[1];
    }

    public double[] getLimits() throws ProcessInterruptedException {
        double min;
        double max;
        RasterTask task = RasterTaskQueue.get(Thread.currentThread().getId() + "");
        double secondMax = max = Double.NEGATIVE_INFINITY;
        double secondMin = min = Double.MAX_VALUE;
        double value = 0.0;
        switch (this.getDataType()) {
            case 0: {
                int i;
                for (i = 0; i < this.getBandCount(); ++i) {
                    for (int r = 0; r < this.getHeight(); ++r) {
                        for (int c = 0; c < this.getWidth(); ++c) {
                            value = this.getElemByte(r, c, i) & 0xFF;
                            if (value > max) {
                                if (max != value) {
                                    secondMax = max;
                                }
                                max = value;
                            }
                            if (!(value < min)) continue;
                            if (min != value) {
                                secondMin = min;
                            }
                            min = value;
                        }
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
            case 2: {
                int i;
                for (i = 0; i < this.getBandCount(); ++i) {
                    for (int r = 0; r < this.getHeight(); ++r) {
                        for (int c = 0; c < this.getWidth(); ++c) {
                            value = this.getElemShort(r, c, i);
                            if (value > max) {
                                if (max != value) {
                                    secondMax = max;
                                }
                                max = value;
                            }
                            if (!(value < min)) continue;
                            if (min != value) {
                                secondMin = min;
                            }
                            min = value;
                        }
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
            case 3: {
                int i;
                for (i = 0; i < this.getBandCount(); ++i) {
                    for (int r = 0; r < this.getHeight(); ++r) {
                        for (int c = 0; c < this.getWidth(); ++c) {
                            value = this.getElemInt(r, c, i);
                            if (value > max) {
                                if (max != value) {
                                    secondMax = max;
                                }
                                max = value;
                            }
                            if (!(value < min)) continue;
                            if (min != value) {
                                secondMin = min;
                            }
                            min = value;
                        }
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
            case 4: {
                int i;
                for (i = 0; i < this.getBandCount(); ++i) {
                    for (int r = 0; r < this.getHeight(); ++r) {
                        for (int c = 0; c < this.getWidth(); ++c) {
                            value = this.getElemFloat(r, c, i);
                            if (value > max) {
                                if (max != value) {
                                    secondMax = max;
                                }
                                max = value;
                            }
                            if (!(value < min)) continue;
                            if (min != value) {
                                secondMin = min;
                            }
                            min = value;
                        }
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
            case 5: {
                int i;
                for (i = 0; i < this.getBandCount(); ++i) {
                    for (int r = 0; r < this.getHeight(); ++r) {
                        for (int c = 0; c < this.getWidth(); ++c) {
                            value = this.getElemDouble(r, c, i);
                            if (value > max) {
                                if (max != value) {
                                    secondMax = max;
                                }
                                max = value;
                            }
                            if (!(value < min)) continue;
                            if (min != value) {
                                secondMin = min;
                            }
                            min = value;
                        }
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
        }
        if (secondMax == Double.NEGATIVE_INFINITY) {
            secondMax = max;
        }
        if (secondMin == Double.MAX_VALUE) {
            secondMin = min;
        }
        double[] values = new double[]{min, max};
        values[2] = secondMin;
        values[3] = secondMax;
        return values;
    }

    public double[][] getAllBandsLimits() throws ProcessInterruptedException {
        int i;
        RasterTask task = RasterTaskQueue.get(Thread.currentThread().getId() + "");
        double[] max = new double[this.getBandCount()];
        double[] min = new double[this.getBandCount()];
        double value = 0.0;
        for (i = 0; i < this.getBandCount(); ++i) {
            max[i] = Double.NEGATIVE_INFINITY;
            min[i] = Double.MAX_VALUE;
        }
        switch (this.getDataType()) {
            case 0: {
                int c;
                int r;
                for (i = 0; i < this.getBandCount(); ++i) {
                    for (r = 0; r < this.getHeight(); ++r) {
                        for (c = 0; c < this.getWidth(); ++c) {
                            value = this.getElemByte(r, c, i) & 0xFF;
                            if (value > max[i]) {
                                max[i] = value;
                            }
                            if (!(value < min[i])) continue;
                            min[i] = value;
                        }
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
            case 2: {
                int c;
                int r;
                for (i = 0; i < this.getBandCount(); ++i) {
                    for (r = 0; r < this.getHeight(); ++r) {
                        for (c = 0; c < this.getWidth(); ++c) {
                            value = this.getElemShort(r, c, i);
                            if (value > max[i]) {
                                max[i] = value;
                            }
                            if (!(value < min[i])) continue;
                            min[i] = value;
                        }
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
            case 3: {
                int c;
                int r;
                for (i = 0; i < this.getBandCount(); ++i) {
                    for (r = 0; r < this.getHeight(); ++r) {
                        for (c = 0; c < this.getWidth(); ++c) {
                            value = this.getElemInt(r, c, i);
                            if (value > max[i]) {
                                max[i] = value;
                            }
                            if (!(value < min[i])) continue;
                            min[i] = value;
                        }
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
            case 4: {
                int c;
                int r;
                for (i = 0; i < this.getBandCount(); ++i) {
                    for (r = 0; r < this.getHeight(); ++r) {
                        for (c = 0; c < this.getWidth(); ++c) {
                            value = this.getElemFloat(r, c, i);
                            if (value > max[i]) {
                                max[i] = value;
                            }
                            if (!(value < min[i])) continue;
                            min[i] = value;
                        }
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
            case 5: {
                int c;
                int r;
                for (i = 0; i < this.getBandCount(); ++i) {
                    for (r = 0; r < this.getHeight(); ++r) {
                        for (c = 0; c < this.getWidth(); ++c) {
                            value = this.getElemDouble(r, c, i);
                            if (value > max[i]) {
                                max[i] = value;
                            }
                            if (!(value < min[i])) continue;
                            min[i] = value;
                        }
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
        }
        double[][] values = new double[2][this.getBandCount()];
        for (int i2 = 0; i2 < this.getBandCount(); ++i2) {
            values[0][i2] = min[i2];
            values[1][i2] = max[i2];
        }
        return values;
    }

    public HistogramComputer getHistogramComputer() {
        if (this.histogramComputer == null) {
            this.histogramComputer = new BufferHistogramComputer(this);
        }
        return this.histogramComputer;
    }

    public boolean isInside(int x, int y) {
        return x >= 0 && y >= 0 && x < this.getWidth() && y < this.getHeight();
    }

    public boolean isReadOnlyBuffer() {
        return false;
    }

    public boolean isCached() {
        return false;
    }

    public IncrementableTask getIncrementableTask(int type) {
        switch (type) {
            case 0: {
                return this.getBufferInterpolation();
            }
            case 1: {
                return this.getHistogramComputer();
            }
        }
        return null;
    }

    private BufferInterpolation getBufferInterpolation() {
        if (this.interp == null) {
            this.interp = new BufferInterpolation(this);
        }
        return this.interp;
    }

    public Buffer getAdjustedWindow(int w, int h, int interpolationMethod) throws ProcessInterruptedException {
        this.getBufferInterpolation();
        if (w == this.getWidth() && h == this.getHeight()) {
            return this;
        }
        Buffer rasterBuf = null;
        switch (interpolationMethod) {
            case 1: {
                rasterBuf = this.interp.adjustRasterNearestNeighbourInterpolation(w, h);
                break;
            }
            case 2: {
                rasterBuf = this.interp.adjustRasterBilinearInterpolation(w, h);
                break;
            }
            case 3: {
                rasterBuf = this.interp.adjustRasterInverseDistanceInterpolation(w, h);
                break;
            }
            case 4: {
                rasterBuf = this.interp.adjustRasterBicubicSplineInterpolation(w, h);
                break;
            }
            case 5: {
                rasterBuf = this.interp.adjustRasterBSplineInterpolation(w, h);
            }
        }
        if (rasterBuf != null) {
            return rasterBuf;
        }
        return this;
    }

    public Rectangle2D getDataExtent() {
        return null;
    }

    public void setDataExtent(Rectangle2D r) {
    }

    public RasterDataStore getStore() {
        return null;
    }

    public void setStore(RasterDataStore store) {
    }

    public void addDrawableBands(int[] db) {
    }

    public boolean isFromStore(DataStore store) {
        return false;
    }

    public void accept(Visitor visitor) throws BaseException {
    }

    public void dispose() {
        if (this.pageBandBuffer != null) {
            for (int i = 0; i < this.pageBandBuffer.length; ++i) {
                this.pageBandBuffer[i].dispose();
            }
        }
        try {
            this.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.limits = null;
        this.histogramComputer = null;
        if (this.pageBandBuffer != null) {
            for (int i = 0; i < this.pageBandBuffer.length; ++i) {
                this.pageBandBuffer[i] = null;
            }
            this.pageBandBuffer = null;
        }
        this.limits = null;
        super.finalize();
    }
}

