/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.buffer.cache;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.Band;
import org.gvsig.fmap.dal.coverage.util.FileUtils;
import org.gvsig.raster.impl.buffer.RasterBand;
import org.gvsig.raster.impl.buffer.RasterBuffer;
import org.gvsig.raster.impl.buffer.cache.Cache;
import org.gvsig.raster.impl.buffer.cache.CacheDataServer;
import org.gvsig.raster.impl.buffer.cache.CacheStruct;
import org.gvsig.raster.impl.buffer.cache.ICacheDataSource;
import org.gvsig.raster.impl.buffer.cache.InvalidPageNumberException;
import org.gvsig.raster.impl.buffer.cache.LRUAlgorithm;
import org.gvsig.raster.impl.buffer.cache.PageBandBuffer;

public class RasterCache
extends RasterBuffer {
    private Cache cache = null;
    private LRUAlgorithm lru = null;
    private int lastLine = -1;

    public RasterCache(int dataType, int width, int height, int nBands) {
        this.cache = new Cache(nBands, dataType, width, height);
        this.lru = new LRUAlgorithm(this.cache);
        this.dataType = dataType;
        this.width = width;
        this.height = height;
        this.nBands = nBands;
    }

    public void clearCache() throws IOException {
        this.cache.clearCache(this.nBands);
    }

    public boolean isBandSwitchable() {
        return true;
    }

    @Override
    public void malloc(int dataType, int width, int height, int bandNr) {
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
        this.lru.setCache(cache);
    }

    public byte[][] getLineByte(int line) {
        if (this.exists(line)) {
            return this.cache.getAccessPage().getLineByte(line & this.cache.getOffset());
        }
        return null;
    }

    public short[][] getLineShort(int line) {
        if (this.exists(line)) {
            return this.cache.getAccessPage().getLineShort(line & this.cache.getOffset());
        }
        return null;
    }

    public int[][] getLineInt(int line) {
        if (this.exists(line)) {
            return this.cache.getAccessPage().getLineInt(line & this.cache.getOffset());
        }
        return null;
    }

    public float[][] getLineFloat(int line) {
        if (this.exists(line)) {
            return this.cache.getAccessPage().getLineFloat(line & this.cache.getOffset());
        }
        return null;
    }

    public double[][] getLineDouble(int line) {
        if (this.exists(line)) {
            return this.cache.getAccessPage().getLineDouble(line & this.cache.getOffset());
        }
        return null;
    }

    public void setLineByte(byte[][] data, int line) {
        if (this.exists(line)) {
            this.cache.getAccessPage().setLineByte(data, line & this.cache.getOffset());
        }
    }

    public void setLineShort(short[][] data, int line) {
        if (this.exists(line)) {
            this.cache.getAccessPage().setLineShort(data, line & this.cache.getOffset());
        }
    }

    public void setLineInt(int[][] data, int line) {
        if (this.exists(line)) {
            this.cache.getAccessPage().setLineInt(data, line & this.cache.getOffset());
        }
    }

    public void setLineFloat(float[][] data, int line) {
        if (this.exists(line)) {
            this.cache.getAccessPage().setLineFloat(data, line & this.cache.getOffset());
        }
    }

    public void setLineDouble(double[][] data, int line) {
        if (this.exists(line)) {
            this.cache.getAccessPage().setLineDouble(data, line & this.cache.getOffset());
        }
    }

    public byte[] getLineFromBandByte(int line, int band) {
        if (this.exists(line)) {
            return this.cache.getAccessPage().getLineFromBandByte(line & this.cache.getOffset(), band);
        }
        return null;
    }

    public short[] getLineFromBandShort(int line, int band) {
        if (this.exists(line)) {
            return this.cache.getAccessPage().getLineFromBandShort(line & this.cache.getOffset(), band);
        }
        return null;
    }

    public int[] getLineFromBandInt(int line, int band) {
        if (this.exists(line)) {
            return this.cache.getAccessPage().getLineFromBandInt(line & this.cache.getOffset(), band);
        }
        return null;
    }

    public float[] getLineFromBandFloat(int line, int band) {
        if (this.exists(line)) {
            return this.cache.getAccessPage().getLineFromBandFloat(line & this.cache.getOffset(), band);
        }
        return null;
    }

    public double[] getLineFromBandDouble(int line, int band) {
        if (this.exists(line)) {
            return this.cache.getAccessPage().getLineFromBandDouble(line & this.cache.getOffset(), band);
        }
        return null;
    }

    public void setLineInBandByte(byte[] data, int line, int band) {
        if (this.exists(line)) {
            this.cache.getAccessPage().setLineInBandByte(data, line & this.cache.getOffset(), band);
        }
    }

    public void setLineInBandShort(short[] data, int line, int band) {
        if (this.exists(line)) {
            this.cache.getAccessPage().setLineInBandShort(data, line & this.cache.getOffset(), band);
        }
    }

    public void setLineInBandInt(int[] data, int line, int band) {
        if (this.exists(line)) {
            this.cache.getAccessPage().setLineInBandInt(data, line & this.cache.getOffset(), band);
        }
    }

    public void setLineInBandFloat(float[] data, int line, int band) {
        if (this.exists(line)) {
            this.cache.getAccessPage().setLineInBandFloat(data, line & this.cache.getOffset(), band);
        }
    }

    public void setLineInBandDouble(double[] data, int line, int band) {
        if (this.exists(line)) {
            this.cache.getAccessPage().setLineInBandDouble(data, line & this.cache.getOffset(), band);
        }
    }

    public byte getElemByte(int line, int col, int band) {
        if (this.exists(line)) {
            return this.cache.getAccessPage().getElemByte(line & this.cache.getOffset(), col, band);
        }
        return this.getNoDataValue().isDefined() ? this.getNoDataValue().getValue().byteValue() : RasterLibrary.defaultByteNoDataValue;
    }

    public short getElemShort(int line, int col, int band) {
        if (this.exists(line)) {
            return this.cache.getAccessPage().getElemShort(line & this.cache.getOffset(), col, band);
        }
        return this.getNoDataValue().isDefined() ? this.getNoDataValue().getValue().shortValue() : RasterLibrary.defaultShortNoDataValue;
    }

    public int getElemInt(int line, int col, int band) {
        if (this.exists(line)) {
            return this.cache.getAccessPage().getElemInt(line & this.cache.getOffset(), col, band);
        }
        return this.getNoDataValue().isDefined() ? this.getNoDataValue().getValue().intValue() : RasterLibrary.defaultIntegerNoDataValue;
    }

    public float getElemFloat(int line, int col, int band) {
        if (this.exists(line)) {
            return this.cache.getAccessPage().getElemFloat(line & this.cache.getOffset(), col, band);
        }
        return this.getNoDataValue().isDefined() ? this.getNoDataValue().getValue().floatValue() : RasterLibrary.defaultFloatNoDataValue;
    }

    public double getElemDouble(int line, int col, int band) {
        if (this.exists(line)) {
            return this.cache.getAccessPage().getElemDouble(line & this.cache.getOffset(), col, band);
        }
        return this.getNoDataValue().isDefined() ? this.getNoDataValue().getValue().doubleValue() : RasterLibrary.defaultDoubleNoDataValue;
    }

    public void setElem(int line, int col, int band, byte data) {
        if (this.exists(line)) {
            this.cache.getAccessPage().setElem(line & this.cache.getOffset(), col, band, data);
        }
    }

    public void setElem(int line, int col, int band, short data) {
        if (this.exists(line)) {
            this.cache.getAccessPage().setElem(line & this.cache.getOffset(), col, band, data);
        }
    }

    public void setElem(int line, int col, int band, int data) {
        if (this.exists(line)) {
            this.cache.getAccessPage().setElem(line & this.cache.getOffset(), col, band, data);
        }
    }

    public void setElem(int line, int col, int band, float data) {
        if (this.exists(line)) {
            this.cache.getAccessPage().setElem(line & this.cache.getOffset(), col, band, data);
        }
    }

    public void setElem(int line, int col, int band, double data) {
        if (this.exists(line)) {
            this.cache.getAccessPage().setElem(line & this.cache.getOffset(), col, band, data);
        }
    }

    public void getElemByte(int line, int col, byte[] data) {
        if (!this.exists(line)) {
            for (int iBand = 0; iBand < data.length; ++iBand) {
                data[iBand] = this.getNoDataValue().isDefined() ? this.getNoDataValue().getValue().byteValue() : RasterLibrary.defaultByteNoDataValue;
            }
        }
        this.cache.getAccessPage().getElemByte(line & this.cache.getOffset(), col, data);
    }

    public void getElemShort(int line, int col, short[] data) {
        if (!this.exists(line)) {
            for (int iBand = 0; iBand < data.length; ++iBand) {
                data[iBand] = this.getNoDataValue().isDefined() ? this.getNoDataValue().getValue().shortValue() : RasterLibrary.defaultShortNoDataValue;
            }
        }
        this.cache.getAccessPage().getElemShort(line & this.cache.getOffset(), col, data);
    }

    public void getElemInt(int line, int col, int[] data) {
        if (!this.exists(line)) {
            for (int iBand = 0; iBand < data.length; ++iBand) {
                data[iBand] = this.getNoDataValue().isDefined() ? this.getNoDataValue().getValue().intValue() : RasterLibrary.defaultIntegerNoDataValue;
            }
        }
        this.cache.getAccessPage().getElemInt(line & this.cache.getOffset(), col, data);
    }

    public void getElemFloat(int line, int col, float[] data) {
        if (!this.exists(line)) {
            for (int iBand = 0; iBand < data.length; ++iBand) {
                data[iBand] = this.getNoDataValue().isDefined() ? this.getNoDataValue().getValue().floatValue() : RasterLibrary.defaultFloatNoDataValue;
            }
        }
        this.cache.getAccessPage().getElemFloat(line & this.cache.getOffset(), col, data);
    }

    public void getElemDouble(int line, int col, double[] data) {
        if (!this.exists(line)) {
            for (int iBand = 0; iBand < data.length; ++iBand) {
                data[iBand] = this.getNoDataValue().isDefined() ? this.getNoDataValue().getValue().doubleValue() : RasterLibrary.defaultDoubleNoDataValue;
            }
        }
        this.cache.getAccessPage().getElemDouble(line & this.cache.getOffset(), col, data);
    }

    private boolean exists(int line) {
        if (line != this.lastLine) {
            try {
                this.lru.cacheAccess(line, false);
                this.lastLine = line;
            }
            catch (InvalidPageNumberException e) {
                return false;
            }
        }
        return true;
    }

    public void setElemByte(int line, int col, byte[] data) {
        if (this.exists(line)) {
            this.cache.getAccessPage().setElemByte(line & this.cache.getOffset(), col, data);
        }
    }

    public void setElemShort(int line, int col, short[] data) {
        if (this.exists(line)) {
            this.cache.getAccessPage().setElemShort(line & this.cache.getOffset(), col, data);
        }
    }

    public void setElemInt(int line, int col, int[] data) {
        if (this.exists(line)) {
            this.cache.getAccessPage().setElemInt(line & this.cache.getOffset(), col, data);
        }
    }

    public void setElemFloat(int line, int col, float[] data) {
        if (this.exists(line)) {
            this.cache.getAccessPage().setElemFloat(line & this.cache.getOffset(), col, data);
        }
    }

    public void setElemDouble(int line, int col, double[] data) {
        if (this.exists(line)) {
            this.cache.getAccessPage().setElemDouble(line & this.cache.getOffset(), col, data);
        }
    }

    public Buffer getBandBuffer(int Band2) {
        RasterCache rasterCache = new RasterCache(this.getDataType(), this.getWidth(), this.getHeight(), 1);
        CacheStruct cs = new CacheStruct();
        cs.setHPag(this.cache.getCacheStruct().getHPag());
        cs.setOffset(this.cache.getCacheStruct().getOffset());
        cs.setNPags(this.cache.getCacheStruct().getNPags());
        cs.setNBands(1);
        cs.setNGroups(this.cache.getCacheStruct().getNGroups());
        cs.setBitsPag(this.cache.getCacheStruct().getBitsPag());
        cs.setNTotalPags(this.getHeight() / this.cache.getCacheStruct().getHPag());
        cs.setDataType(this.cache.getCacheStruct().getDataType());
        Cache c = new Cache(cs, this.getWidth());
        rasterCache.setCache(c);
        Band band = this.getBand(Band2);
        rasterCache.assignBand(0, band);
        return rasterCache;
    }

    @Override
    public void replicateBand(int orig, int dest) {
    }

    @Override
    public void switchBands(int[] bandPosition) {
    }

    public void assign(int band, byte value) {
        for (int line = 0; line < this.height; ++line) {
            boolean beginLine = true;
            for (int col = 0; col < this.width; ++col) {
                try {
                    if (beginLine) {
                        this.lru.cacheAccess(line, false);
                        beginLine = false;
                    }
                }
                catch (InvalidPageNumberException e) {
                    return;
                }
                this.cache.getAccessPage().setElem(line & this.cache.getOffset(), col, band, value);
            }
        }
    }

    public void assign(int band, short value) {
        for (int line = 0; line < this.height; ++line) {
            boolean beginLine = true;
            for (int col = 0; col < this.width; ++col) {
                try {
                    if (beginLine) {
                        this.lru.cacheAccess(line, false);
                        beginLine = false;
                    }
                }
                catch (InvalidPageNumberException e) {
                    return;
                }
                this.cache.getAccessPage().setElem(line & this.cache.getOffset(), col, band, value);
            }
        }
    }

    public void assign(int band, int value) {
        for (int line = 0; line < this.height; ++line) {
            boolean beginLine = true;
            for (int col = 0; col < this.width; ++col) {
                try {
                    if (beginLine) {
                        this.lru.cacheAccess(line, false);
                        beginLine = false;
                    }
                }
                catch (InvalidPageNumberException e) {
                    return;
                }
                this.cache.getAccessPage().setElem(line & this.cache.getOffset(), col, band, value);
            }
        }
    }

    public void assign(int band, float value) {
        for (int line = 0; line < this.height; ++line) {
            boolean beginLine = true;
            for (int col = 0; col < this.width; ++col) {
                try {
                    if (beginLine) {
                        this.lru.cacheAccess(line, false);
                        beginLine = false;
                    }
                }
                catch (InvalidPageNumberException e) {
                    return;
                }
                this.cache.getAccessPage().setElem(line & this.cache.getOffset(), col, band, value);
            }
        }
    }

    public void assign(int band, double value) {
        for (int line = 0; line < this.height; ++line) {
            boolean beginLine = true;
            for (int col = 0; col < this.width; ++col) {
                try {
                    if (beginLine) {
                        this.lru.cacheAccess(line, false);
                        beginLine = false;
                    }
                }
                catch (InvalidPageNumberException e) {
                    return;
                }
                this.cache.getAccessPage().setElem(line & this.cache.getOffset(), col, band, value);
            }
        }
    }

    @Override
    public Buffer cloneBuffer() {
        return null;
    }

    public void interchangeBands(int band1, int band2) {
        Band b1 = this.getBand(band1);
        Band b2 = this.getBand(band2);
        try {
            this.cache.assignBand(band2, ((CacheBand)b1).cacheDataServer);
            this.cache.assignBand(band1, ((CacheBand)b2).cacheDataServer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void mallocOneBand(int dataType, int width, int height, int band) {
    }

    public Band getBand(int band) {
        CacheBand cb = new CacheBand(this.getHeight(), this.getWidth());
        cb.cacheDataServer = new CacheDataServer[this.cache.getNTotalPags()];
        try {
            this.cache.resetCache();
        }
        catch (IOException e) {
            return null;
        }
        for (int iPage = 0; iPage < this.cache.getNTotalPags(); ++iPage) {
            cb.cacheDataServer[iPage] = this.cache.getHddPage(iPage, band);
        }
        return cb;
    }

    public void copyBand(int nBand, Band band) {
        FileUtils fileUtils = RasterLocator.getManager().getFileUtils();
        if (band instanceof CacheBand) {
            CacheBand cb = new CacheBand(band.getHeight(), band.getWidth());
            cb.cacheDataServer = new CacheDataServer[((CacheBand)band).cacheDataServer.length];
            for (int iPage = 0; iPage < cb.cacheDataServer.length; ++iPage) {
                cb.cacheDataServer[iPage] = new CacheDataServer(null, nBand, iPage);
                String path = ((CacheBand)band).cacheDataServer[iPage].getPath();
                File f = new File(path);
                if (!f.exists()) continue;
                try {
                    fileUtils.copyFile(path, cb.cacheDataServer[iPage].getPath());
                    continue;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                this.cache.deleteBand(nBand);
                this.cache.assignBand(nBand, cb.cacheDataServer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void assignBand(int nBand, Band band) {
        if (band instanceof CacheBand) {
            try {
                this.cache.deleteBand(nBand);
                this.cache.assignBand(nBand, ((CacheBand)band).cacheDataServer);
            }
            catch (IOException e) {
                return;
            }
        }
    }

    public Band createBand(byte defaultValue) {
        PageBandBuffer pageBuffer = new PageBandBuffer(this.getDataType(), this.getWidth(), this.cache.getHPag(), 1, true, 0);
        Band band = null;
        try {
            band = this.createBand(pageBuffer);
        }
        catch (IOException e) {
            return null;
        }
        this.loadPage(new Byte(defaultValue), pageBuffer);
        return band;
    }

    public void assignBandToNotValid(int Band2) {
        PageBandBuffer pageBuffer = new PageBandBuffer(this.getDataType(), this.getWidth(), this.cache.getHPag(), 1, true, 0);
        switch (this.getDataType()) {
            case 0: {
                this.loadPage(new Byte((byte)this.getNotValidValue()), pageBuffer);
                break;
            }
            case 2: {
                this.loadPage(new Short((short)this.getNotValidValue()), pageBuffer);
                break;
            }
            case 3: {
                this.loadPage(new Integer((int)this.getNotValidValue()), pageBuffer);
                break;
            }
            case 4: {
                this.loadPage(new Float((float)this.getNotValidValue()), pageBuffer);
                break;
            }
            case 5: {
                this.loadPage(new Double(this.getNotValidValue()), pageBuffer);
            }
        }
        try {
            CacheBand cb = (CacheBand)this.createBand(pageBuffer);
            cb.setFileName(Band2);
            this.assignBand(Band2, cb);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Band createBand(PageBandBuffer pageBuffer) throws IOException {
        CacheDataServer[] ds = new CacheDataServer[this.cache.getNTotalPags()];
        for (int i = 0; i < this.cache.getNTotalPags(); ++i) {
            ds[i] = new CacheDataServer(null, 0, i);
            ds[i].savePage(pageBuffer);
        }
        CacheBand band = new CacheBand(this.getHeight(), this.getWidth());
        band.cacheDataServer = ds;
        return band;
    }

    private void loadPage(Object value, PageBandBuffer pageBuffer) {
        switch (this.getDataType()) {
            case 0: {
                for (int i = 0; i < this.getWidth(); ++i) {
                    for (int j = 0; j < this.cache.getHPag(); ++j) {
                        pageBuffer.setElem(j, i, 0, (Byte)value);
                    }
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.getWidth(); ++i) {
                    for (int j = 0; j < this.cache.getHPag(); ++j) {
                        pageBuffer.setElem(j, i, 0, (Short)value);
                    }
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.getWidth(); ++i) {
                    for (int j = 0; j < this.cache.getHPag(); ++j) {
                        pageBuffer.setElem(j, i, 0, (Integer)value);
                    }
                }
                break;
            }
            case 4: {
                for (int i = 0; i < this.getWidth(); ++i) {
                    for (int j = 0; j < this.cache.getHPag(); ++j) {
                        pageBuffer.setElem(j, i, 0, ((Float)value).floatValue());
                    }
                }
                break;
            }
            case 5: {
                for (int i = 0; i < this.getWidth(); ++i) {
                    for (int j = 0; j < this.cache.getHPag(); ++j) {
                        pageBuffer.setElem(j, i, 0, (Double)value);
                    }
                }
                break;
            }
        }
    }

    public boolean isReadOnlyBuffer() {
        return false;
    }

    @Override
    public boolean isCached() {
        return true;
    }

    @Override
    public int getBlockHeight() {
        return this.cache.getHPag();
    }

    public void dispose() {
        if (this.cache != null) {
            if (this.cache.getAccessPage() != null) {
                this.cache.getAccessPage().dispose();
            }
            for (int i = 0; i < this.cache.getNPags(); ++i) {
                if (this.cache.getPageBufferFromNumberCachePage(i) == null) continue;
                this.cache.getPageBufferFromNumberCachePage(i).dispose();
            }
            try {
                this.clearCache();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.cache = null;
        }
        this.lru = null;
    }

    @Override
    protected void finalize() throws Throwable {
        this.cache = null;
        this.lru = null;
        super.finalize();
    }

    public class CacheBand
    extends RasterBand {
        public ICacheDataSource[] cacheDataServer;

        public CacheBand(int height, int width) {
            super(height, width);
            this.cacheDataServer = null;
        }

        public Object getLine(int line) {
            return null;
        }

        public void setLine(int line, Object value) {
        }

        public Object getBuf() {
            return null;
        }

        public void setFileName(int numBand) {
            for (int i = 0; i < this.cacheDataServer.length; ++i) {
                ((CacheDataServer)this.cacheDataServer[i]).setName(null, numBand, i);
            }
        }

        public void dispose() {
            for (int i = 0; i < this.cacheDataServer.length; ++i) {
                this.cacheDataServer[i] = null;
            }
            this.cacheDataServer = null;
        }
    }
}

