/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.datastruct;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.compat.CompatLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.ViewPortData;
import org.gvsig.raster.impl.datastruct.ExtentImpl;
import org.gvsig.timesupport.Time;

public class DefaultViewPortData
implements ViewPortData {
    IProjection proj = null;
    IProjection cs = null;
    Extent extent = null;
    Dimension2D viewSize = null;
    public AffineTransform mat = null;
    public Point2D pxSize = null;
    private Time time = null;
    int dpi = CompatLocator.getGraphicsUtils().getScreenDPI();

    public DefaultViewPortData() {
        this.mat = new AffineTransform();
        this.mat.scale(1.0, -1.0);
    }

    public DefaultViewPortData(IProjection proj, Extent extent, Dimension2D size) {
        this.proj = proj;
        this.extent = extent;
        this.viewSize = size;
        this.mat = new AffineTransform();
        this.mat.scale(1.0, -1.0);
    }

    public IProjection getProjection() {
        return this.proj;
    }

    public void setProjection(IProjection proj) {
        this.proj = proj;
    }

    public void reProject(ICoordTrans rp) {
    }

    public void setCoordSys(IProjection cs) {
        this.cs = cs;
    }

    public AffineTransform getMat() {
        return this.mat;
    }

    public void setMat(AffineTransform mat) {
        this.mat = mat;
    }

    public Object clone() {
        DefaultViewPortData vp = new DefaultViewPortData();
        if (this.mat != null) {
            vp.mat = new AffineTransform(this.mat);
        }
        if (this.extent != null) {
            vp.extent = new ExtentImpl(this.extent);
        }
        vp.proj = this.proj;
        vp.viewSize = this.viewSize;
        vp.dpi = this.dpi;
        return vp;
    }

    public double getWidth() {
        return this.viewSize.getWidth();
    }

    public double getHeight() {
        return this.viewSize.getHeight();
    }

    public Dimension2D getSize() {
        return this.viewSize;
    }

    public void setSize(double w, double h) {
        this.setSize(new Dimension((int)w, (int)h));
    }

    public void setSize(Dimension2D sz) {
        this.viewSize = sz;
        this.reExtent();
    }

    public Extent getExtent() {
        return this.extent;
    }

    public void setExtent(Dimension2D sz) {
        Point2D.Double pt0 = new Point2D.Double(0.0, 0.0);
        Point2D.Double ptSz = new Point2D.Double(sz.getWidth(), sz.getHeight());
        try {
            this.mat.inverseTransform(pt0, pt0);
            this.mat.inverseTransform(ptSz, ptSz);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.extent = new ExtentImpl(pt0, ptSz);
    }

    public void setExtent(Extent ext) {
        this.extent = ext;
    }

    public void reExtent() {
        this.setExtent(this.viewSize);
    }

    public void setDPI(int dpi) {
        this.dpi = dpi;
    }

    public int getDPI() {
        return this.dpi;
    }

    public void zoom(Extent extent) {
        double[] scale = extent.getScale(this.getWidth(), this.getHeight());
        double escala = Math.min(scale[0], scale[1]);
        this.mat.setToIdentity();
        this.mat.scale(escala, -escala);
        this.mat.translate(-extent.minX(), -extent.maxY());
        this.extent = extent;
        this.reExtent();
    }

    public void zoom(double zoom, Point2D pt) {
        this.zoom(zoom, zoom, pt);
    }

    public void zoom(double zx, double zy, Point2D pt) {
        this.centerAt(pt);
        this.mat.scale(zx, zy);
        this.centerAt(pt);
        this.reExtent();
    }

    public void zoomToCenter(double f) {
        Point2D.Double ptCenter = new Point2D.Double(this.getWidth() / 2.0, this.getHeight() / 2.0);
        try {
            this.mat.inverseTransform(ptCenter, ptCenter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.zoom(f, ptCenter);
    }

    public void centerAt(Point2D pt) {
        Point2D.Double ptCenter = new Point2D.Double(this.getWidth() / 2.0, this.getHeight() / 2.0);
        try {
            this.mat.inverseTransform(ptCenter, ptCenter);
            this.mat.translate(ptCenter.x - pt.getX(), ptCenter.y - pt.getY());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.reExtent();
    }

    public void pan(Point2D ptIni, Point2D ptFin) {
        this.mat.translate(ptFin.getX() - ptIni.getX(), ptFin.getY() - ptIni.getY());
        this.reExtent();
    }

    public Point2D getCenter() {
        Point2D.Double ptCenter = new Point2D.Double(this.getWidth() / 2.0, this.getHeight() / 2.0);
        try {
            this.mat.inverseTransform(ptCenter, ptCenter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ptCenter;
    }

    public void calculateAffineTransform() {
        if (this.viewSize == null || this.extent == null || this.viewSize.getWidth() <= 0.0 || this.viewSize.getHeight() <= 0.0) {
            return;
        }
        AffineTransform escalado = new AffineTransform();
        AffineTransform translacion = new AffineTransform();
        double escalaX = this.viewSize.getWidth() / this.extent.width();
        double escalaY = this.viewSize.getHeight() / this.extent.height();
        double xCenter = this.extent.getCenterX();
        double yCenter = this.extent.getCenterY();
        Rectangle2D.Double adjustedExtent = new Rectangle2D.Double();
        double scale = 0.0;
        if (escalaX < escalaY) {
            scale = escalaX;
            double newHeight = this.viewSize.getHeight() / scale;
            ((Rectangle2D)adjustedExtent).setRect(xCenter - this.extent.width() / 2.0, yCenter - newHeight / 2.0, this.extent.width(), newHeight);
        } else {
            scale = escalaY;
            double newWidth = this.viewSize.getWidth() / scale;
            ((Rectangle2D)adjustedExtent).setRect(xCenter - newWidth / 2.0, yCenter - this.extent.height() / 2.0, newWidth, this.extent.height());
        }
        escalado.setToScale(scale, -scale);
        translacion.setToTranslation(-this.extent.getULX(), -this.extent.getULY());
        this.mat.setToIdentity();
        this.mat.concatenate(escalado);
        this.mat.concatenate(translacion);
    }

    public Time getTime() {
        return this.time;
    }

    public void setTime(Time time) {
        this.time = time;
    }
}

