/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.datastruct;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import org.gvsig.fmap.dal.coverage.datastruct.GeoPoint;
import org.gvsig.raster.impl.datastruct.DefaultViewPortData;

public class GeoPointImpl
implements GeoPoint {
    private Point2D pixelPoint = null;
    private Point2D mapPoint = null;
    private boolean active = true;
    private double errorX = 0.0;
    private double errorY = 0.0;
    private double rms = 0.0;
    private double xEvaluate = 0.0;
    private double yEvaluate = 0.0;
    private int number = 0;
    private String label = null;
    public static int WIDTH_WINDOW = 140;
    public static int HEIGHT_WINDOW = 140;
    public DefaultViewPortData leftViewPort = null;
    public DefaultViewPortData rightViewPort = null;
    public Point2D leftCenterPoint = null;
    public Point2D rightCenterPoint = null;
    public double zoomLeft = 1.0;
    public double zoomRight = 1.0;

    public GeoPointImpl() {
    }

    public GeoPointImpl(Point2D p, Point2D m) {
        this.pixelPoint = p;
        this.mapPoint = m;
    }

    public void resetErrors() {
        this.xEvaluate = 0.0;
        this.yEvaluate = 0.0;
        this.errorX = 0.0;
        this.errorY = 0.0;
        this.rms = 0.0;
    }

    public double getEvaluateX() {
        return this.xEvaluate;
    }

    public void setEvaluateX(double xEvaluate) {
        this.xEvaluate = xEvaluate;
    }

    public double getEvaluateY() {
        return this.yEvaluate;
    }

    public void setEvaluateY(double yEvaluate) {
        this.yEvaluate = yEvaluate;
    }

    public double getErrorX() {
        return this.errorX;
    }

    public void setErrorX(double errorX) {
        this.errorX = errorX;
    }

    public double getErrorY() {
        return this.errorY;
    }

    public void setErrorY(double errorY) {
        this.errorY = errorY;
    }

    public double getRms() {
        return this.rms;
    }

    public void setRms(double rms) {
        this.rms = rms;
    }

    public Point2D getPixelPoint() {
        return this.pixelPoint;
    }

    public void setPixelPoint(Point2D pixelPoint) {
        this.pixelPoint = pixelPoint;
    }

    public Point2D getMapPoint() {
        return this.mapPoint;
    }

    public void setMapPoint(Point2D mapPoint) {
        this.mapPoint = mapPoint;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public double getxEvaluate() {
        return this.xEvaluate;
    }

    public void setxEvaluate(double xEvaluate) {
        this.xEvaluate = xEvaluate;
    }

    public double getyEvaluate() {
        return this.yEvaluate;
    }

    public void setyEvaluate(double yEvaluate) {
        this.yEvaluate = yEvaluate;
    }

    public int getNumber() {
        return this.number;
    }

    public String getLabel() {
        return this.label;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public GeoPointImpl cloneGeoPoint() {
        Point2D pixel = null;
        Point2D map = null;
        if (this.pixelPoint != null) {
            pixel = (Point2D)this.pixelPoint.clone();
        }
        if (this.mapPoint != null) {
            map = (Point2D)this.mapPoint.clone();
        }
        GeoPointImpl gp = new GeoPointImpl(pixel, map);
        gp.setErrorX(this.getErrorX());
        gp.setErrorY(this.getErrorY());
        gp.setRms(this.getRms());
        if (this.leftViewPort != null) {
            gp.leftViewPort = new DefaultViewPortData();
            gp.leftViewPort.setProjection(this.leftViewPort.getProjection());
            gp.leftViewPort.setExtent(this.leftViewPort.getExtent());
            gp.leftViewPort.setSize((Dimension)this.leftViewPort.getSize().clone());
            gp.leftViewPort.reExtent();
        }
        if (this.rightViewPort != null) {
            gp.rightViewPort = new DefaultViewPortData();
            gp.rightViewPort.setProjection(this.rightViewPort.getProjection());
            gp.rightViewPort.setExtent(this.rightViewPort.getExtent());
            gp.rightViewPort.setSize((Dimension)this.rightViewPort.getSize().clone());
            gp.rightViewPort.reExtent();
        }
        if (this.leftCenterPoint != null) {
            gp.leftCenterPoint = (Point2D)this.leftCenterPoint.clone();
        }
        if (this.rightCenterPoint != null) {
            gp.rightCenterPoint = (Point2D)this.rightCenterPoint.clone();
        }
        gp.active = this.active;
        gp.zoomLeft = this.zoomLeft;
        gp.zoomRight = this.zoomRight;
        return gp;
    }

    public void show() {
        System.out.println("********GeoPoint**********");
        System.out.println("Pixel: " + this.pixelPoint);
        System.out.println("Map: " + this.mapPoint);
        System.out.println("Left Zoom Center: " + this.leftCenterPoint);
        System.out.println("Right Zoom Center: " + this.rightCenterPoint);
        System.out.println("Active: " + this.active);
        System.out.println("ZoomLeft: " + this.zoomLeft);
        System.out.println("ZoomRight: " + this.zoomRight);
        System.out.println("******End GeoPoint********");
    }
}

