/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.datastruct.legend;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.datastruct.ColorItem;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.raster.impl.datastruct.ColorItemImpl;
import org.gvsig.raster.impl.datastruct.legend.RasterLegendIO;
import org.gvsig.raster.impl.store.properties.DataStoreColorTable;

public class GimpGradients
extends RasterLegendIO {
    private ColorItem parseColorItem(String[] strings, int pos) {
        ColorItemImpl item = new ColorItemImpl();
        double pos1 = Double.valueOf(strings[0]);
        double pos2 = Double.valueOf(strings[1]);
        double pos3 = Double.valueOf(strings[2]);
        if (pos == 0) {
            item.setValue(pos1 * 255.0);
        } else {
            item.setValue(pos3 * 255.0);
        }
        if (pos == 0) {
            item.setInterpolated(100.0 * (pos2 - pos1) / (pos3 - pos1));
        }
        if (pos == 0) {
            item.setColor(new Color((int)(Double.valueOf(strings[3]) * 255.0), (int)(Double.valueOf(strings[4]) * 255.0), (int)(Double.valueOf(strings[5]) * 255.0), (int)(Double.valueOf(strings[6]) * 255.0)));
        } else {
            item.setColor(new Color((int)(Double.valueOf(strings[7]) * 255.0), (int)(Double.valueOf(strings[8]) * 255.0), (int)(Double.valueOf(strings[9]) * 255.0), (int)(Double.valueOf(strings[10]) * 255.0)));
        }
        return item;
    }

    @Override
    public ColorTable read(File input) throws IOException {
        ArrayList<ColorItem> colorItems = new ArrayList<ColorItem>();
        DataStoreColorTable colorTable = new DataStoreColorTable();
        try {
            String currentLine;
            BufferedReader reader = new BufferedReader(new FileReader(input));
            int cont = 0;
            while ((currentLine = reader.readLine()) != null) {
                if (cont == 1) {
                    colorTable.setName(currentLine.substring(6));
                }
                if (cont > 1) {
                    String[] strings = currentLine.split("\\s+");
                    if (strings.length < 13) continue;
                    colorItems.add(this.parseColorItem(strings, 0));
                    colorItems.add(this.parseColorItem(strings, 1));
                }
                ++cont;
            }
            reader.close();
        }
        catch (IOException ex) {
            throw new IOException();
        }
        colorTable.createPaletteFromColorItems(colorItems, true);
        return colorTable;
    }

    @Override
    public void write(ColorTable colorTable, File output) throws IOException {
        List colorItems = colorTable.getColorItems();
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(output));
            writer.write("GIMP Gradient\n");
            writer.write("Name: " + colorTable.getName() + "\n");
            writer.write(colorItems.size() - 1 + "\n");
            for (int i = 1; i < colorItems.size(); ++i) {
                double min = ((ColorItem)colorItems.get(0)).getValue();
                double max = ((ColorItem)colorItems.get(colorItems.size() - 1)).getValue();
                String line = "";
                ColorItem item1 = (ColorItem)colorItems.get(i - 1);
                ColorItem item2 = (ColorItem)colorItems.get(i);
                double pos1 = (item1.getValue() - min) / (max - min);
                double pos2 = (item2.getValue() - min) / (max - min);
                NumberFormat format = NumberFormat.getNumberInstance();
                format.setMaximumFractionDigits(6);
                format.setMinimumFractionDigits(6);
                line = line + format.format(pos1).replaceAll(",", ".") + " ";
                double interp = pos1 + (pos2 - pos1) * item1.getInterpolated() / 100.0;
                line = line + format.format(interp).replaceAll(",", ".") + " ";
                line = line + format.format(pos2).replaceAll(",", ".") + " ";
                Color color = item1.getColor();
                line = line + format.format((double)color.getRed() / 255.0).replaceAll(",", ".") + " ";
                line = line + format.format((double)color.getGreen() / 255.0).replaceAll(",", ".") + " ";
                line = line + format.format((double)color.getBlue() / 255.0).replaceAll(",", ".") + " ";
                line = line + format.format((double)color.getAlpha() / 255.0).replaceAll(",", ".") + " ";
                color = item2.getColor();
                line = line + format.format((double)color.getRed() / 255.0).replaceAll(",", ".") + " ";
                line = line + format.format((double)color.getGreen() / 255.0).replaceAll(",", ".") + " ";
                line = line + format.format((double)color.getBlue() / 255.0).replaceAll(",", ".") + " ";
                line = line + format.format((double)color.getAlpha() / 255.0).replaceAll(",", ".") + " ";
                line = line + "0 0\n";
                writer.write(line);
            }
            writer.close();
        }
        catch (IOException ex) {
            throw new IOException();
        }
    }

    @Override
    public String getDescription() {
        return "Gimp Gradients";
    }
}

