/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid;

import java.awt.geom.Point2D;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.GridExtent;
import org.gvsig.raster.impl.datastruct.ExtentImpl;
import org.gvsig.raster.impl.grid.GridCellImpl;

public class GridExtentImpl
extends ExtentImpl
implements GridExtent {
    double cellSizeX = 1.0;
    double cellSizeY = -1.0;
    int m_iNX;
    int m_iNY;

    public GridExtentImpl() {
    }

    public GridExtentImpl(double minX, double minY, double maxX, double maxY, double dCellSize) {
        super(minX, minY, maxX, maxY);
        this.cellSizeX = dCellSize;
        this.cellSizeY = -dCellSize;
        this.recalculateNXAndNY();
    }

    public GridExtentImpl(Extent extent, double dCellSize) {
        super(extent);
        this.cellSizeX = dCellSize;
        this.cellSizeY = -dCellSize;
        this.recalculateNXAndNY();
    }

    public GridExtentImpl(double minX, double minY, double maxX, double maxY, double dCellSizeX, double dCellSizeY) {
        super(minX, minY, maxX, maxY);
        this.cellSizeX = dCellSizeX;
        this.cellSizeY = dCellSizeY;
        this.recalculateNXAndNY();
    }

    public GridExtentImpl(Extent extent, double dCellSizeX, double dCellSizeY) {
        super(extent);
        this.cellSizeX = dCellSizeX;
        this.cellSizeY = dCellSizeY;
        this.recalculateNXAndNY();
    }

    public void setXRange(double dXMin, double dXMax) {
        this.getMin().setLocation(Math.min(dXMin, dXMax), this.minY());
        this.getMax().setLocation(Math.max(dXMin, dXMax), this.maxY());
        this.recalculateNXAndNY();
    }

    public void setYRange(double dYMin, double dYMax) {
        this.getMin().setLocation(this.minX(), Math.min(dYMin, dYMax));
        this.getMax().setLocation(this.maxX(), Math.max(dYMin, dYMax));
        this.recalculateNXAndNY();
    }

    public double getCellSize() {
        return this.cellSizeX;
    }

    public void setCellSize(double cellSize) {
        this.cellSizeX = cellSize;
        this.cellSizeY = -cellSize;
        this.recalculateNXAndNY();
    }

    public int getNX() {
        return this.m_iNX;
    }

    public int getNY() {
        return this.m_iNY;
    }

    private void recalculateNXAndNY() {
        this.m_iNY = (int)Math.abs(Math.floor((this.minY() - this.maxY()) / this.cellSizeY));
        this.m_iNX = (int)Math.abs(Math.floor((this.maxX() - this.minX()) / this.cellSizeX));
    }

    public boolean contains(double x, double y) {
        return x >= this.minX() && x <= this.maxX() && y >= this.minY() && y <= this.maxY();
    }

    public boolean fitsIn(GridExtent extent) {
        if (extent.getCellSizeX() != this.getCellSizeX() || extent.getCellSizeY() != this.getCellSizeY()) {
            return false;
        }
        double dOffset = Math.abs(extent.minX() - this.minX());
        double dOffsetCols = dOffset / this.getCellSizeX();
        boolean bFitsX = dOffsetCols == Math.floor(dOffsetCols);
        dOffset = Math.abs(extent.maxY() - this.maxY());
        double dOffsetRows = dOffset / this.getCellSizeY();
        boolean bFitsY = dOffsetRows == Math.floor(dOffsetRows);
        return bFitsX && bFitsY;
    }

    public boolean equals(GridExtent extent) {
        return this.minX() == extent.minX() && this.maxX() == extent.maxX() && this.minY() == extent.minY() && this.maxY() == extent.maxY() && this.cellSizeX == extent.getCellSizeX() && this.cellSizeY == extent.getCellSizeY();
    }

    public GridCellImpl getGridCoordsFromWorldCoords(Point2D pt) {
        int x = (int)Math.floor((pt.getX() - this.minX()) / this.cellSizeX);
        int y = (int)Math.ceil((this.maxY() - pt.getY()) / this.cellSizeY);
        GridCellImpl cell = new GridCellImpl(x, y, 0.0);
        return cell;
    }

    public Point2D getWorldCoordsFromGridCoords(GridCellImpl cell) {
        double x = this.minX() + ((double)cell.getX() + 0.5) * this.cellSizeX;
        double y = this.maxY() - ((double)cell.getY() + 0.5) * this.cellSizeY;
        Point2D.Double pt = new Point2D.Double(x, y);
        return pt;
    }

    public double getCellSizeX() {
        return this.cellSizeX;
    }

    public void setCellSizeX(double cellSizeX) {
        this.cellSizeX = cellSizeX;
        this.recalculateNXAndNY();
    }

    public double getCellSizeY() {
        return this.cellSizeY;
    }

    public void setCellSizeY(double cellSizeY) {
        this.cellSizeY = cellSizeY;
        this.recalculateNXAndNY();
    }
}

