/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid;

import java.awt.Rectangle;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.GridExtent;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.exception.RasterBufferInvalidAccessException;
import org.gvsig.fmap.dal.coverage.exception.RasterBufferInvalidException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.raster.impl.DefaultRasterManager;
import org.gvsig.raster.impl.grid.GridReader;

public class GridInterpolated
extends GridReader {
    public static final int INTERPOLATION_NearestNeighbour = 1;
    public static final int INTERPOLATION_Bilinear = 2;
    public static final int INTERPOLATION_InverseDistance = 3;
    public static final int INTERPOLATION_BicubicSpline = 4;
    public static final int INTERPOLATION_BSpline = 5;
    double m_dXMin;
    double m_dYMax;
    double m_dCellSizeX;
    double m_dCellSizeY;
    int m_iInterpolationMethod = 5;

    public GridInterpolated(Buffer rb, GridExtent layerExtent, GridExtent windowExtent, int[] bands) {
        super(rb, layerExtent, windowExtent, bands);
        this.m_dXMin = layerExtent.minX();
        this.m_dYMax = layerExtent.maxY();
        this.m_dCellSizeX = layerExtent.getCellSizeX();
        this.m_dCellSizeY = layerExtent.getCellSizeY();
    }

    public GridInterpolated(RasterDataStore ds, GridExtent layerExtent, GridExtent windowExtent, int[] bands) {
        super(ds, layerExtent, windowExtent, bands);
        this.init();
    }

    private void init() {
        this.m_dXMin = this.dataStore.getExtent().minX();
        this.m_dYMax = this.dataStore.getExtent().maxY();
        this.m_dCellSizeX = this.dataStore.getAffineTransform().getScaleX();
        this.m_dCellSizeY = this.dataStore.getAffineTransform().getScaleY();
    }

    public void setInterpolationMethod(int iMethod) {
        this.m_iInterpolationMethod = iMethod;
    }

    @Override
    public byte getCellValueAsByte(int x, int y) throws RasterBufferInvalidAccessException, RasterBufferInvalidException {
        return (byte)this._getValueAt(x, y);
    }

    @Override
    public short getCellValueAsShort(int x, int y) throws RasterBufferInvalidAccessException, RasterBufferInvalidException {
        return (short)this._getValueAt(x, y);
    }

    @Override
    public int getCellValueAsInt(int x, int y) throws RasterBufferInvalidAccessException, RasterBufferInvalidException {
        return (int)this._getValueAt(x, y);
    }

    @Override
    public float getCellValueAsFloat(int x, int y) throws RasterBufferInvalidAccessException, RasterBufferInvalidException {
        return (float)this._getValueAt(x, y);
    }

    @Override
    public double getCellValueAsDouble(int x, int y) throws RasterBufferInvalidAccessException, RasterBufferInvalidException {
        return this._getValueAt(x, y);
    }

    @Override
    public double getCellValue(int x, int y) throws RasterBufferInvalidAccessException, RasterBufferInvalidException {
        return this._getValueAt(x, y);
    }

    private double _getValueAt(int x, int y) throws RasterBufferInvalidAccessException, RasterBufferInvalidException {
        double dX = this.windowExtent.minX() + this.windowExtent.getCellSize() * ((double)x + 0.5);
        double dY = this.windowExtent.maxY() - this.windowExtent.getCellSize() * ((double)y + 0.5);
        return this.getValueAt(dX, dY);
    }

    public double _getValueAt(double x, double y) throws RasterBufferInvalidAccessException, RasterBufferInvalidException {
        int x_int = (int)Math.floor(x);
        int y_int = (int)Math.floor(y);
        double dX = this.windowExtent.minX() + this.windowExtent.getCellSize() * ((double)x_int + (x - (double)x_int));
        double dY = this.windowExtent.maxY() - this.windowExtent.getCellSize() * ((double)y_int + (y - (double)y_int));
        return this.getValueAt(dX, dY);
    }

    private double getValueAt(double xPosition, double yPosition) throws RasterBufferInvalidAccessException, RasterBufferInvalidException {
        int y;
        int x = (int)Math.floor(xPosition = (xPosition - this.m_dXMin) / this.m_dCellSizeX);
        double dValue = this._getCellValueInLayerCoords(x, y = (int)Math.floor(yPosition = (yPosition - this.m_dYMax) / this.m_dCellSizeY));
        if (!this.isNoDataValue(dValue)) {
            double dx = xPosition - (double)x;
            double dy = yPosition - (double)y;
            switch (this.m_iInterpolationMethod) {
                case 1: {
                    dValue = this._getValueNearestNeighbour(x, y, dx, dy);
                    break;
                }
                case 2: {
                    dValue = this._getValueBiLinear(x, y, dx, dy);
                    break;
                }
                case 3: {
                    dValue = this._getValueInverseDistance(x, y, dx, dy);
                    break;
                }
                case 4: {
                    dValue = this._getValueBiCubicSpline(x, y, dx, dy);
                    break;
                }
                case 5: {
                    dValue = this._getValueBSpline(x, y, dx, dy);
                }
            }
        } else {
            dValue = this.getNoDataValue();
        }
        return dValue;
    }

    private double _getValueNearestNeighbour(int x, int y, double dx, double dy) throws RasterBufferInvalidAccessException, RasterBufferInvalidException {
        return this._getCellValueInLayerCoords(x += (int)(0.5 + dx), y += (int)(0.5 + dy));
    }

    private double _getValueBiLinear(int x, int y, double dx, double dy) throws RasterBufferInvalidAccessException, RasterBufferInvalidException {
        double d;
        double z = 0.0;
        double n = 0.0;
        double dValue = this._getCellValueInLayerCoords(x, y);
        if (!this.isNoDataValue(dValue)) {
            d = (1.0 - dx) * (1.0 - dy);
            z += d * dValue;
            n += d;
        }
        if (!this.isNoDataValue(dValue = this._getCellValueInLayerCoords(x + 1, y))) {
            d = dx * (1.0 - dy);
            z += d * dValue;
            n += d;
        }
        if (!this.isNoDataValue(dValue = this._getCellValueInLayerCoords(x, y + 1))) {
            d = (1.0 - dx) * dy;
            z += d * dValue;
            n += d;
        }
        if (!this.isNoDataValue(dValue = this._getCellValueInLayerCoords(x + 1, y + 1))) {
            d = dx * dy;
            z += d * dValue;
            n += d;
        }
        if (n > 0.0) {
            return z / n;
        }
        return this.getNoDataValue();
    }

    private double _getValueInverseDistance(int x, int y, double dx, double dy) throws RasterBufferInvalidAccessException, RasterBufferInvalidException {
        double z = 0.0;
        double n = 0.0;
        if (dx > 0.0 || dy > 0.0) {
            double d;
            double dValue = this._getCellValueInLayerCoords(x, y);
            if (!this.isNoDataValue(dValue)) {
                d = 1.0 / Math.sqrt(dx * dx + dy * dy);
                z += d * dValue;
                n += d;
            }
            if (!this.isNoDataValue(dValue = this._getCellValueInLayerCoords(x + 1, y))) {
                d = 1.0 / Math.sqrt((1.0 - dx) * (1.0 - dx) + dy * dy);
                z += d * dValue;
                n += d;
            }
            if (!this.isNoDataValue(dValue = this._getCellValueInLayerCoords(x, y + 1))) {
                d = 1.0 / Math.sqrt(dx * dx + (1.0 - dy) * (1.0 - dy));
                z += d * dValue;
                n += d;
            }
            if (!this.isNoDataValue(dValue = this._getCellValueInLayerCoords(x + 1, y + 1))) {
                d = 1.0 / Math.sqrt((1.0 - dx) * (1.0 - dx) + (1.0 - dy) * (1.0 - dy));
                z += d * dValue;
                n += d;
            }
            if (n > 0.0) {
                return z / n;
            }
        } else {
            return this._getCellValueInLayerCoords(x, y);
        }
        return this.getNoDataValue();
    }

    private double _getValueBiCubicSpline(int x, int y, double dx, double dy) throws RasterBufferInvalidAccessException, RasterBufferInvalidException {
        double[] c = new double[4];
        double[][] z_xy = new double[4][4];
        if (this._get4x4Submatrix(x, y, z_xy)) {
            double b3;
            double b2;
            double b1;
            double a3;
            double a2;
            double a0;
            for (int i = 0; i < 4; ++i) {
                a0 = z_xy[0][i] - z_xy[1][i];
                a2 = z_xy[2][i] - z_xy[1][i];
                a3 = z_xy[3][i] - z_xy[1][i];
                b1 = -a0 / 3.0 + a2 - a3 / 6.0;
                b2 = a0 / 2.0 + a2 / 2.0;
                b3 = -a0 / 6.0 - a2 / 2.0 + a3 / 6.0;
                c[i] = z_xy[1][i] + b1 * dx + b2 * dx * dx + b3 * dx * dx * dx;
            }
            a0 = c[0] - c[1];
            a2 = c[2] - c[1];
            a3 = c[3] - c[1];
            b1 = -a0 / 3.0 + a2 - a3 / 6.0;
            b2 = a0 / 2.0 + a2 / 2.0;
            b3 = -a0 / 6.0 - a2 / 2.0 + a3 / 6.0;
            return c[1] + b1 * dy + b2 * dy * dy + b3 * dy * dy * dy;
        }
        return this._getValueBiLinear(x, y, dx, dy);
    }

    private double _getValueBSpline(int x, int y, double dx, double dy) throws RasterBufferInvalidAccessException, RasterBufferInvalidException {
        double[] Rx = new double[4];
        double[] Ry = new double[4];
        double[][] z_xy = new double[4][4];
        if (this._get4x4Submatrix(x, y, z_xy)) {
            double z;
            int i = 0;
            double px = -1.0 - dx;
            double py = -1.0 - dy;
            while (i < 4) {
                double d;
                double d2;
                double d3;
                double d4;
                double d5;
                double d6;
                double d7;
                double d8;
                Rx[i] = 0.0;
                Ry[i] = 0.0;
                z = px + 2.0;
                if (d8 > 0.0) {
                    int n = i;
                    Rx[n] = Rx[n] + z * z * z;
                }
                z = px + 1.0;
                if (d7 > 0.0) {
                    int n = i;
                    Rx[n] = Rx[n] + -4.0 * z * z * z;
                }
                z = px + 0.0;
                if (d6 > 0.0) {
                    int n = i;
                    Rx[n] = Rx[n] + 6.0 * z * z * z;
                }
                z = px - 1.0;
                if (d5 > 0.0) {
                    int n = i;
                    Rx[n] = Rx[n] + -4.0 * z * z * z;
                }
                z = py + 2.0;
                if (d4 > 0.0) {
                    int n = i;
                    Ry[n] = Ry[n] + z * z * z;
                }
                z = py + 1.0;
                if (d3 > 0.0) {
                    int n = i;
                    Ry[n] = Ry[n] + -4.0 * z * z * z;
                }
                z = py + 0.0;
                if (d2 > 0.0) {
                    int n = i;
                    Ry[n] = Ry[n] + 6.0 * z * z * z;
                }
                z = py - 1.0;
                if (d > 0.0) {
                    int n = i;
                    Ry[n] = Ry[n] + -4.0 * z * z * z;
                }
                int n = i;
                Rx[n] = Rx[n] / 6.0;
                int n2 = i++;
                Ry[n2] = Ry[n2] / 6.0;
                px += 1.0;
                py += 1.0;
            }
            z = 0.0;
            for (int iy = 0; iy < 4; ++iy) {
                for (int ix = 0; ix < 4; ++ix) {
                    z += z_xy[ix][iy] * Rx[ix] * Ry[iy];
                }
            }
            return z;
        }
        return this._getValueBiLinear(x, y, dx, dy);
    }

    private boolean _get4x4Submatrix(int x, int y, double[][] z_xy) throws RasterBufferInvalidAccessException, RasterBufferInvalidException {
        int iy = 0;
        int py = y - 1;
        while (iy < 4) {
            int ix = 0;
            int px = x - 1;
            while (ix < 4) {
                double dValue = this._getCellValueInLayerCoords(px, py);
                if (this.isNoDataValue(dValue)) {
                    return false;
                }
                z_xy[ix][iy] = dValue;
                ++ix;
                ++px;
            }
            ++iy;
            ++py;
        }
        return true;
    }

    private double _getCellValueInLayerCoords(int x, int y) throws RasterBufferInvalidAccessException, RasterBufferInvalidException {
        int h;
        int w;
        int pX = 0;
        int pY = 0;
        RasterQuery query = DefaultRasterManager.getInstance().createQuery();
        query.setDrawableBands(this.bands);
        query.storeLastBuffer(true);
        if (this.dataStore != null) {
            w = (int)this.dataStore.getWidth();
            h = (int)this.dataStore.getHeight();
            try {
                if (y >= h || x >= w || x < 0 || y < 0) {
                    return this.getNoDataValue();
                }
                query.setAreaOfInterest(new Rectangle(x, y, 1, 1));
                this.rasterBuf = this.dataStore.query(query);
            }
            catch (QueryException e) {
                throw new RasterBufferInvalidAccessException("");
            }
            catch (ProcessInterruptedException processInterruptedException) {}
        } else {
            w = this.rasterBuf.getWidth();
            h = this.rasterBuf.getHeight();
            pX = x;
            pY = y;
        }
        if (x >= 0 && y >= 0 && x < w && y < h) {
            switch (this.dataType) {
                case 5: {
                    return this.rasterBuf.getElemDouble(pY, pX, this.bandToOperate);
                }
                case 3: {
                    return this.rasterBuf.getElemInt(pY, pX, this.bandToOperate);
                }
                case 4: {
                    return this.rasterBuf.getElemFloat(pY, pX, this.bandToOperate);
                }
                case 0: {
                    return this.rasterBuf.getElemByte(pY, pX, this.bandToOperate) & 0xFF;
                }
                case 1: 
                case 2: {
                    return this.rasterBuf.getElemShort(pY, pX, this.bandToOperate);
                }
            }
        }
        return this.getNoDataValue();
    }

    @Override
    public byte[] getBandsValuesAsByte(int x, int y) {
        return null;
    }

    @Override
    public short[] getBandsValuesAsShort(int x, int y) {
        return null;
    }

    @Override
    public int[] getBandsValuesAsInt(int x, int y) {
        return null;
    }

    @Override
    public float[] getBandsValuesAsFloat(int x, int y) {
        return null;
    }

    @Override
    public double[] getBandsValuesAsDouble(int x, int y) {
        return null;
    }
}

