/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.band;

import org.gvsig.raster.impl.grid.filter.band.ColorBalanceCMYFilter;

public class ColorBalanceCMYByteFilter
extends ColorBalanceCMYFilter {
    @Override
    public void process(int col, int line) {
        byte[] value = new byte[]{this.raster.getElemByte(line, col, this.redBandNumber), this.raster.getElemByte(line, col, this.greenBandNumber), this.raster.getElemByte(line, col, this.blueBandNumber), -1};
        double[] cmyk = this.colorConversion.RGBtoCMYK(value[0] & 0xFF, value[1] & 0xFF, value[2] & 0xFF, 1.0);
        double lum = this.colorConversion.getLuminosity(value[0] & 0xFF, value[1] & 0xFF, value[2] & 0xFF);
        cmyk[0] = Math.min(cmyk[0] + this.cyan / 300.0, 1.0);
        cmyk[1] = Math.min(cmyk[1] + this.magenta / 300.0, 1.0);
        cmyk[2] = Math.min(cmyk[2] + this.yellow / 300.0, 1.0);
        double[] rgb = this.colorConversion.CMYKtoRGB(cmyk[0], cmyk[1], cmyk[2], cmyk[3]);
        for (int band = 0; band < 3; ++band) {
            value[band] = (byte)(rgb[band] * 255.0);
        }
        if (this.luminosity) {
            double[] hsl = this.colorConversion.RGBtoHSL(value[0] & 0xFF, value[1] & 0xFF, value[2] & 0xFF);
            hsl[0] = (int)(255.0 * hsl[0] / 360.0 + 0.5);
            hsl[1] = (int)(hsl[1] * 255.0 + 0.5);
            hsl[2] = (int)(lum * 255.0 + 0.5);
            int[] v1 = this.colorConversion.HSLtoRGB((int)hsl[0] & 0xFFFFFFFF, (int)hsl[1] & 0xFFFFFFFF, (int)hsl[2] & 0xFFFFFFFF);
            byte[] v = new byte[4];
            for (int band = 0; band < 3; ++band) {
                v[band] = (byte)v1[band];
            }
            v[3] = value[3];
            this.getOutputBuffer().setElemByte(line, col, v);
        } else {
            this.getOutputBuffer().setElemByte(line, col, value);
        }
        this.writeAlphaBand(line, col);
    }
}

