/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.band;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.grid.AbstractRasterFilterManager;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.raster.impl.grid.filter.RasterFilterListManagerImpl;
import org.gvsig.raster.impl.grid.filter.band.ColorTableByteFilter;
import org.gvsig.raster.impl.grid.filter.band.ColorTableFilter;
import org.gvsig.raster.impl.store.ParamImpl;

public class ColorTableListManager
extends AbstractRasterFilterManager {
    private static String ID = "ColorTable";

    public ColorTableListManager(RasterFilterList filterList) {
        super(filterList);
    }

    public String getManagerID() {
        return ID;
    }

    public static void register() {
        AbstractRasterFilterManager.register((String)ID, ColorTableListManager.class);
    }

    public boolean isDataTypeSupported(int dataType) {
        return true;
    }

    public Class<?> getFilterClassByID(String id) {
        if (id.compareTo("colortable") == 0) {
            return ColorTableFilter.class;
        }
        return null;
    }

    public ColorTableListManager(RasterFilterListManagerImpl filterListManager) {
        super(filterListManager.getFilterList());
    }

    public void addColorTableFilter(ColorTable palette) throws FilterTypeException {
        ColorTableByteFilter filter = new ColorTableByteFilter();
        if (filter != null) {
            filter.addParam("colorTable", palette);
            this.getFilterList().add((RasterFilter)filter);
        }
    }

    public List<Class<?>> getRasterFilterList() {
        ArrayList filters = new ArrayList();
        filters.add(ColorTableFilter.class);
        return filters;
    }

    public void addFilter(Class<?> classFilter, Params params) throws FilterTypeException {
        if (ColorTableFilter.class.isAssignableFrom(classFilter)) {
            ColorTable colorTable = null;
            for (int i = 0; i < params.getNumParams(); ++i) {
                if (!((ParamImpl)params.getParam(i)).getId().equals("colorTable")) continue;
                colorTable = (ColorTable)((ParamImpl)params.getParam(i)).getDefaultValue();
            }
            this.addColorTableFilter(colorTable);
        }
    }

    public void addFilter(Params params) throws FilterTypeException {
        this.addFilter(ColorTableFilter.class, params);
    }

    public RasterFilter createFilter(Params params) {
        ColorTable colorTable = (ColorTable)params.getParamById("colorTable").getDefaultValue();
        ColorTableByteFilter filter = new ColorTableByteFilter();
        filter.addParam("colorTable", colorTable);
        return filter;
    }
}

