/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.band;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.grid.AbstractRasterFilterManager;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.raster.impl.grid.filter.RasterFilterListManagerImpl;
import org.gvsig.raster.impl.grid.filter.band.HSLToRGBByteFilter;
import org.gvsig.raster.impl.grid.filter.band.HSLToRGBFilter;
import org.gvsig.raster.impl.store.ParamImpl;

public class HSLToRGBManager
extends AbstractRasterFilterManager {
    private static String ID = "HSLToRGB";

    public HSLToRGBManager(RasterFilterList filterList) {
        super(filterList);
    }

    public String getManagerID() {
        return ID;
    }

    public static void register() {
        AbstractRasterFilterManager.register((String)ID, HSLToRGBManager.class);
    }

    public boolean isDataTypeSupported(int dataType) {
        return dataType == 0;
    }

    public Class<?> getFilterClassByID(String id) {
        if (id.compareTo("hsltorgb") == 0) {
            return HSLToRGBFilter.class;
        }
        return null;
    }

    public HSLToRGBManager(RasterFilterListManagerImpl filterListManager) {
        super(filterListManager.getFilterList());
    }

    public void addHSLToRGBFilter(int[] renderBands) throws FilterTypeException {
        HSLToRGBByteFilter filter = new HSLToRGBByteFilter();
        if (filter != null) {
            this.getFilterList().add((RasterFilter)filter);
            filter.addParam("renderBands", renderBands);
        }
    }

    public List<Class<?>> getRasterFilterList() {
        ArrayList filters = new ArrayList();
        filters.add(HSLToRGBFilter.class);
        return filters;
    }

    public void addFilter(Class<?> classFilter, Params params) throws FilterTypeException {
        if (HSLToRGBFilter.class.isAssignableFrom(classFilter)) {
            int[] renderBands = new int[]{0, 1, 2, 3};
            for (int i = 0; i < params.getNumParams(); ++i) {
                if (((ParamImpl)params.getParam(i)).getId().equals("RenderBands") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof String) {
                    String[] bands = new String((String)((ParamImpl)params.getParam(i)).getDefaultValue()).split(" ");
                    renderBands[0] = new Integer(bands[0]);
                    renderBands[1] = new Integer(bands[1]);
                    renderBands[2] = new Integer(bands[2]);
                    continue;
                }
                if (!((ParamImpl)params.getParam(i)).getId().equals("alphaBand") || !(((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Integer)) continue;
                renderBands[3] = (Integer)((ParamImpl)params.getParam(i)).getDefaultValue();
            }
            this.addHSLToRGBFilter(renderBands);
        }
    }

    public void addFilter(Params params) throws FilterTypeException {
        this.addFilter(HSLToRGBFilter.class, params);
    }

    public RasterFilter createFilter(Params params) {
        int[] renderBands = new int[]{0, 1, 2};
        String b = (String)params.getParamById("RenderBands").getDefaultValue();
        String[] bands = b.split(" ");
        renderBands[0] = new Integer(bands[0]);
        renderBands[1] = new Integer(bands[1]);
        renderBands[2] = new Integer(bands[2]);
        HSLToRGBByteFilter filter = new HSLToRGBByteFilter();
        filter.addParam("renderBands", renderBands);
        return filter;
    }
}

