/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.band;

import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.fmap.dal.coverage.grid.filter.BaseRasterFilter;
import org.gvsig.raster.impl.store.ParamsImpl;
import org.gvsig.raster.util.DefaultColorConversion;

public class RGBToCMYKFilter
extends BaseRasterFilter {
    public static String[] names = new String[]{"rgbtocmyk"};
    protected DefaultColorConversion colorConversion = null;
    protected int out = 0;
    protected int redBandNumber = -1;
    protected int greenBandNumber = -1;
    protected int blueBandNumber = -1;

    public RGBToCMYKFilter() {
        this.setName(names[0]);
    }

    public void pre() throws FilterAddException {
        super.pre();
        this.out = (Integer)this.params.get("outputType");
        this.redBandNumber = 0;
        this.greenBandNumber = 1;
        this.blueBandNumber = 2;
        if (this.out == 0) {
            this.createARGBBufferResult();
        } else {
            this.createBufferResult(this.out, 4);
        }
        if (this.colorConversion == null) {
            this.colorConversion = new DefaultColorConversion();
        }
    }

    public String getGroup() {
        return "colores";
    }

    public String[] getNames() {
        return names;
    }

    public Params getUIParams(String nameFilter) {
        ParamsImpl params = new ParamsImpl();
        params.setParam("outputType", new Integer(0), 2, new String[]{"Byte", "Double"});
        return params;
    }

    public void post() {
    }

    public void process(int x, int y) {
    }

    public int getOutRasterDataType() {
        return 0;
    }

    public boolean isVisible() {
        return true;
    }

    public int getInRasterDataType() {
        return 0;
    }
}

