/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.band;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.grid.AbstractRasterFilterManager;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.raster.impl.grid.filter.RasterFilterListManagerImpl;
import org.gvsig.raster.impl.grid.filter.band.RGBToCMYKByteFilter;
import org.gvsig.raster.impl.grid.filter.band.RGBToCMYKFilter;
import org.gvsig.raster.impl.store.ParamImpl;

public class RGBToCMYKManager
extends AbstractRasterFilterManager {
    private static String ID = "RGBToCMYK";

    public RGBToCMYKManager(RasterFilterList filterList) {
        super(filterList);
    }

    public String getManagerID() {
        return ID;
    }

    public static void register() {
        AbstractRasterFilterManager.register((String)ID, RGBToCMYKManager.class);
    }

    public boolean isDataTypeSupported(int dataType) {
        return dataType == 0;
    }

    public Class<?> getFilterClassByID(String id) {
        if (id.compareTo("rgbtocmyk") == 0) {
            return RGBToCMYKFilter.class;
        }
        return null;
    }

    public RGBToCMYKManager(RasterFilterListManagerImpl filterListManager) {
        super(filterListManager.getFilterList());
    }

    public void addRGBToCMYKFilter(int outputType, int[] renderBands) throws FilterTypeException {
        RGBToCMYKByteFilter filter = new RGBToCMYKByteFilter();
        if (filter != null) {
            filter.addParam("outputType", new Integer(outputType));
            filter.addParam("renderBands", renderBands);
            this.getFilterList().add((RasterFilter)filter);
        }
    }

    public List<Class<?>> getRasterFilterList() {
        ArrayList filters = new ArrayList();
        filters.add(RGBToCMYKFilter.class);
        return filters;
    }

    public void addFilter(Class<?> classFilter, Params params) throws FilterTypeException {
        int[] renderBands = new int[]{0, 1, 2, 3};
        if (RGBToCMYKFilter.class.isAssignableFrom(classFilter)) {
            int out = 0;
            for (int i = 0; i < params.getNumParams(); ++i) {
                if (((ParamImpl)params.getParam(i)).getId().equals("RenderBands") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof String) {
                    String[] bands = new String((String)((ParamImpl)params.getParam(i)).getDefaultValue()).split(" ");
                    renderBands[0] = new Integer(bands[0]);
                    renderBands[1] = new Integer(bands[1]);
                    renderBands[2] = new Integer(bands[2]);
                    continue;
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("alphaBand") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Integer) {
                    renderBands[3] = (Integer)((ParamImpl)params.getParam(i)).getDefaultValue();
                    continue;
                }
                if (!((ParamImpl)params.getParam(i)).getId().equals("outputType")) continue;
                int value = (Integer)((ParamImpl)params.getParam(i)).getDefaultValue();
                if (value == 0) {
                    out = 0;
                }
                if (value != 1) continue;
                out = 5;
            }
            this.addRGBToCMYKFilter(out, renderBands);
        }
    }

    public RasterFilter createFilter(Params params) {
        int[] renderBands = new int[]{0, 1, 2};
        String b = (String)params.getParamById("RenderBands").getDefaultValue();
        String[] bands = b.split(" ");
        renderBands[0] = new Integer(bands[0]);
        renderBands[1] = new Integer(bands[1]);
        renderBands[2] = new Integer(bands[2]);
        Integer outputType = (Integer)params.getParamById("outputType").getDefaultValue();
        RGBToCMYKByteFilter filter = new RGBToCMYKByteFilter();
        filter.addParam("outputType", outputType);
        filter.addParam("renderBands", renderBands);
        return filter;
    }

    public void addFilter(Params params) throws FilterTypeException {
        this.addFilter(RGBToCMYKFilter.class, params);
    }
}

