/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.band;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.grid.AbstractRasterFilterManager;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.raster.impl.grid.filter.RasterFilterListManagerImpl;
import org.gvsig.raster.impl.grid.filter.band.RGBToHSLByteFilter;
import org.gvsig.raster.impl.grid.filter.band.RGBToHSLFilter;
import org.gvsig.raster.impl.store.ParamImpl;

public class RGBToHSLManager
extends AbstractRasterFilterManager {
    private static String ID = "RGBToHSL";

    public RGBToHSLManager(RasterFilterList filterList) {
        super(filterList);
    }

    public String getManagerID() {
        return ID;
    }

    public static void register() {
        AbstractRasterFilterManager.register((String)ID, RGBToHSLManager.class);
    }

    public boolean isDataTypeSupported(int dataType) {
        return dataType == 0;
    }

    public Class<?> getFilterClassByID(String id) {
        if (id.compareTo("rgbtohsl") == 0) {
            return RGBToHSLFilter.class;
        }
        return null;
    }

    public RGBToHSLManager(RasterFilterListManagerImpl filterListManager) {
        super(filterListManager.getFilterList());
    }

    public void addRGBToHSLFilter(int outputType, int[] renderBands) throws FilterTypeException {
        RGBToHSLByteFilter filter = new RGBToHSLByteFilter();
        if (filter != null) {
            filter.addParam("outputType", new Integer(outputType));
            filter.addParam("renderBands", renderBands);
            this.getFilterList().add((RasterFilter)filter);
        }
    }

    public List<Class<?>> getRasterFilterList() {
        ArrayList filters = new ArrayList();
        filters.add(RGBToHSLFilter.class);
        return filters;
    }

    public void addFilter(Class<?> classFilter, Params params) throws FilterTypeException {
        if (RGBToHSLFilter.class.isAssignableFrom(classFilter)) {
            int[] renderBands = new int[]{0, 1, 2, 3};
            int out = 0;
            for (int i = 0; i < params.getNumParams(); ++i) {
                if (((ParamImpl)params.getParam(i)).getId().equals("RenderBands") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof String) {
                    String[] bands = new String((String)((ParamImpl)params.getParam(i)).getDefaultValue()).split(" ");
                    renderBands[0] = new Integer(bands[0]);
                    renderBands[1] = new Integer(bands[1]);
                    renderBands[2] = new Integer(bands[2]);
                    continue;
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("alphaBand") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Integer) {
                    renderBands[3] = (Integer)((ParamImpl)params.getParam(i)).getDefaultValue();
                    continue;
                }
                if (!((ParamImpl)params.getParam(i)).getId().equals("outputType")) continue;
                int value = (Integer)((ParamImpl)params.getParam(i)).getDefaultValue();
                if (value == 0) {
                    out = 0;
                }
                if (value != 1) continue;
                out = 5;
            }
            this.addRGBToHSLFilter(out, renderBands);
        }
    }

    public RasterFilter createFilter(Params params) {
        int[] renderBands = new int[]{0, 1, 2};
        String b = (String)params.getParamById("RenderBands").getDefaultValue();
        String[] bands = b.split(" ");
        renderBands[0] = new Integer(bands[0]);
        renderBands[1] = new Integer(bands[1]);
        renderBands[2] = new Integer(bands[2]);
        Integer outputType = (Integer)params.getParamById("outputType").getDefaultValue();
        RGBToHSLByteFilter filter = new RGBToHSLByteFilter();
        filter.addParam("outputType", outputType);
        filter.addParam("renderBands", renderBands);
        return filter;
    }

    public void addFilter(Params params) throws FilterTypeException {
        this.addFilter(RGBToHSLFilter.class, params);
    }
}

