/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.band;

import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.fmap.dal.coverage.grid.filter.BaseRasterFilter;
import org.gvsig.raster.impl.store.ParamsImpl;
import org.gvsig.raster.util.DefaultColorConversion;

public class ToLumSaFilter
extends BaseRasterFilter {
    public static String[] names = new String[]{"tolumsa"};
    protected DefaultColorConversion colorConversion = null;
    protected int out = 0;
    protected double hue = 0.0;
    protected double luminosity = 0.0;
    protected double saturation = 0.0;
    protected int redBandNumber = -1;
    protected int greenBandNumber = -1;
    protected int blueBandNumber = -1;

    public ToLumSaFilter() {
        this.setName(names[0]);
    }

    public void pre() throws FilterAddException {
        super.pre();
        this.redBandNumber = 0;
        this.greenBandNumber = 1;
        this.blueBandNumber = 2;
        if (this.raster.getDataType() != 0) {
            this.exec = false;
            this.raster = this.rasterResult;
            return;
        }
        if (this.params.get("hue") != null) {
            this.hue = (Double)this.params.get("hue");
        }
        if (this.params.get("luminosity") != null) {
            this.luminosity = (Double)this.params.get("luminosity");
        }
        if (this.params.get("saturation") != null) {
            this.saturation = (Double)this.params.get("saturation");
        }
        this.createARGBBufferResult();
        if (this.colorConversion == null) {
            this.colorConversion = new DefaultColorConversion();
        }
    }

    public String getGroup() {
        return "colores";
    }

    public String[] getNames() {
        return names;
    }

    public Params getUIParams(String nameFilter) {
        ParamsImpl params = new ParamsImpl();
        params.setParam("hue", new Double(this.hue), 3, new String[]{"-180", "180", "0", "10", "50"});
        params.setParam("luminosity", new Double(this.luminosity), 3, new String[]{"-100", "100", "0", "10", "50"});
        params.setParam("saturation", new Double(this.saturation), 3, new String[]{"-100", "100", "0", "10", "50"});
        return params;
    }

    public void post() {
    }

    public void process(int x, int y) {
    }

    public int getOutRasterDataType() {
        return 0;
    }

    public boolean isVisible() {
        return true;
    }

    public int getInRasterDataType() {
        return 0;
    }
}

