/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.convolution;

import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.fmap.dal.coverage.grid.filter.BaseRasterFilter;
import org.gvsig.raster.impl.datastruct.Kernel;
import org.gvsig.raster.impl.grid.filter.convolution.ConvolutionUI;
import org.gvsig.raster.impl.store.ParamsImpl;

public class ConvolutionFilter
extends BaseRasterFilter {
    public static String[] names = new String[]{"media", "pasobajo", "sharpen", "gauss", "personalizado"};
    public int ladoVentana = 0;
    protected Kernel kernel = null;
    public static final int TYPE_MEDIA = 0;
    public static final int TYPE_LOWPASS = 1;
    public static final int TYPE_HIGHPASS = 2;
    public static final int TYPE_GAUSS = 3;
    public static final int TYPE_OTHER = 4;
    static final double[][] gauss3x3 = new double[][]{{1.0, 4.0, 1.0}, {4.0, 12.0, 4.0}, {1.0, 4.0, 1.0}};
    static final double[][] gauss5x5 = new double[][]{{1.0, 2.0, 3.0, 2.0, 1.0}, {2.0, 7.0, 11.0, 7.0, 2.0}, {3.0, 11.0, 17.0, 11.0, 3.0}, {2.0, 7.0, 11.0, 7.0, 2.0}, {1.0, 2.0, 3.0, 2.0, 1.0}};
    static final double[][] gauss7x7 = new double[][]{{1.0, 1.0, 2.0, 2.0, 2.0, 1.0, 1.0}, {1.0, 2.0, 2.0, 4.0, 2.0, 2.0, 1.0}, {2.0, 2.0, 4.0, 8.0, 4.0, 2.0, 2.0}, {2.0, 4.0, 8.0, 16.0, 8.0, 4.0, 2.0}, {2.0, 2.0, 4.0, 8.0, 4.0, 2.0, 2.0}, {1.0, 2.0, 2.0, 4.0, 2.0, 2.0, 1.0}, {1.0, 1.0, 2.0, 2.0, 2.0, 1.0, 1.0}};
    static final double[][] gauss7x7aux = new double[][]{{0.0, 0.0, 3.0E-4, 6.0E-4, 3.0E-4, 0.0, 0.0}, {0.0, 0.0011, 0.0079, 0.0153, 0.0079, 0.0011, 0.0}, {3.0E-4, 0.0079, 0.0563, 0.1082, 0.0563, 0.0079, 3.0E-4}, {6.0E-4, 0.0153, 0.1082, 0.2079, 0.1082, 0.0153, 6.0E-4}, {3.0E-4, 0.0079, 0.0563, 0.1082, 0.0563, 0.0079, 3.0E-4}, {0.0, 0.0011, 0.0079, 0.0153, 0.0079, 0.0011, 0.0}, {0.0, 0.0, 3.0E-4, 6.0E-4, 3.0E-4, 0.0, 0.0}};
    static final double[][] lowpass3x3 = new double[][]{{0.0, 1.0, 0.0}, {1.0, 6.0, 1.0}, {0.0, 1.0, 0.0}};
    static final double[][] lowpass5x5 = new double[][]{{1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 4.0, 4.0, 4.0, 1.0}, {1.0, 4.0, 12.0, 4.0, 1.0}, {1.0, 4.0, 4.0, 4.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0}};
    static final double[][] media3x3 = new double[][]{{1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}};
    static final double[][] media5x5 = new double[][]{{1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0}};
    static final double[][] media7x7 = new double[][]{{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}};
    static final double[][] highpass3x3 = new double[][]{{-1.0, -1.0, -1.0}, {-1.0, 9.0, -1.0}, {-1.0, -1.0, -1.0}};
    static final Kernel kGauss3x3 = new Kernel(gauss3x3, 34.0);
    static final Kernel kGauss5x5 = new Kernel(gauss5x5, 121.0);
    static final Kernel kGauss7x7 = new Kernel(gauss7x7aux);
    static final Kernel kLowpass3x3 = new Kernel(lowpass3x3, 10.0);
    static final Kernel kLowpass5x5 = new Kernel(lowpass5x5);
    static final Kernel kMedia3x3 = new Kernel(media3x3, 9.0);
    static final Kernel kMedia5x5 = new Kernel(media5x5, 25.0);
    static final Kernel kMedia7x7 = new Kernel(media7x7, 49.0);
    static final Kernel kHighpass3x3 = new Kernel(highpass3x3);
    private int operator = 0;
    private double agudeza = 1.0;

    public ConvolutionFilter() {
        this.setName(names[0]);
    }

    public String getGroup() {
        return "espaciales";
    }

    public int getInRasterDataType() {
        return 0;
    }

    public String[] getNames() {
        return names;
    }

    public int getOutRasterDataType() {
        return 0;
    }

    public void post() {
        this.raster = null;
    }

    public void pre() throws FilterAddException {
        super.pre();
        this.ladoVentana = (Integer)this.params.get("ladoVentana");
        if (this.params.get("Agudeza") != null) {
            this.agudeza = (Double)this.params.get("Agudeza");
        }
        Kernel userKernel = (Kernel)this.params.get("kernel");
        String name = (String)this.params.get("filterName");
        this.operator = 0;
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(name)) continue;
            this.operator = i;
            this.setName(names[i]);
            break;
        }
        block0 : switch (this.operator) {
            case 0: {
                this.setName(names[0]);
                switch (this.ladoVentana) {
                    case 2: {
                        this.kernel = kMedia7x7;
                        break block0;
                    }
                    case 1: {
                        this.kernel = kMedia5x5;
                        break block0;
                    }
                }
                this.kernel = kMedia3x3;
                break;
            }
            case 1: {
                this.setName(names[1]);
                switch (this.ladoVentana) {
                    case 1: {
                        this.kernel = kLowpass5x5;
                        break block0;
                    }
                }
                this.kernel = kLowpass3x3;
                break;
            }
            case 2: {
                this.setName(names[2]);
                double[][] h = new double[3][3];
                for (int i = 0; i < h.length; ++i) {
                    for (int j = 0; j < h[i].length; ++j) {
                        h[i][j] = highpass3x3[i][j];
                    }
                }
                h[1][1] = 29.0 - this.agudeza * 20.9 / 100.0;
                this.kernel = new Kernel(h);
                break;
            }
            case 3: {
                this.setName(names[3]);
                switch (this.ladoVentana) {
                    case 2: {
                        this.kernel = kGauss7x7;
                        break block0;
                    }
                    case 1: {
                        this.kernel = kGauss5x5;
                        break block0;
                    }
                }
                this.kernel = kGauss3x3;
                break;
            }
            case 4: {
                this.setName(names[4]);
                this.kernel = userKernel;
            }
        }
        if (this.kernel == null) {
            this.kernel = kMedia3x3;
        }
    }

    public void process(int x, int y) {
    }

    public Params getUIParams(String nameFilter) {
        ParamsImpl params = new ParamsImpl();
        if (nameFilter == "personalizado") {
            params.setParam("Panel", new ConvolutionUI(this.kernel), -1, null);
        } else if (nameFilter != "pasobajo" && nameFilter != "sharpen") {
            params.setParam("LadoVentana", new Integer(this.ladoVentana), 2, new String[]{"3", "5", "7"});
        } else if (nameFilter == "sharpen") {
            params.setParam("Agudeza", new Double(this.agudeza), 3, new String[]{"0", "100", "0", "1", "25"});
        } else {
            params.setParam("LadoVentana", new Integer(this.ladoVentana), 2, new String[]{"3", "5"});
        }
        params.setParam("FilterName", nameFilter, -1, null);
        return params;
    }
}

