/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.convolution;

import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.raster.impl.DefaultRasterManager;
import org.gvsig.raster.impl.datastruct.Kernel;
import org.gvsig.raster.impl.grid.filter.convolution.ConvolutionFilter;

public class ConvolutionFloatFilter
extends ConvolutionFilter {
    public ConvolutionFloatFilter() {
    }

    public ConvolutionFloatFilter(Kernel k) {
        this.kernel = k;
    }

    @Override
    public void pre() throws FilterAddException {
        super.pre();
        this.rasterResult = DefaultRasterManager.getInstance().createBuffer(4, this.raster.getWidth(), this.raster.getHeight(), this.raster.getBandCount(), true);
    }

    @Override
    public void process(int col, int line) {
        int lado = this.kernel.getLado();
        int semiLado = lado - 1 >> 1;
        double[][] ventana = new double[lado][lado];
        double resultConvolution = 0.0;
        for (int band = 0; band < this.numberOfBandsToProcess(); ++band) {
            if (col - semiLado >= 0 && line - semiLado >= 0 && col + semiLado < this.width && line + semiLado < this.height) {
                for (int j = -semiLado; j <= semiLado; ++j) {
                    for (int i = -semiLado; i <= semiLado; ++i) {
                        ventana[i + semiLado][j + semiLado] = this.raster.getElemFloat(line + j, col + i, band);
                    }
                }
                Kernel Kventana = new Kernel(ventana);
                resultConvolution = this.kernel.convolution(Kventana);
                if (resultConvolution > 3.4028234663852886E38) {
                    resultConvolution = 3.4028234663852886E38;
                } else if (resultConvolution < 0.0) {
                    resultConvolution = 0.0;
                }
                this.rasterResult.setElem(line, col, band, (float)resultConvolution);
                continue;
            }
            this.rasterResult.setElem(line, col, band, this.raster.getElemFloat(line, col, band));
        }
    }

    @Override
    public int getInRasterDataType() {
        return 4;
    }

    @Override
    public int getOutRasterDataType() {
        return 4;
    }
}

