/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.convolution;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.grid.FilterUIListener;
import org.gvsig.fmap.dal.coverage.grid.RegistrableFilterListener;
import org.gvsig.raster.impl.datastruct.Kernel;
import org.gvsig.raster.impl.grid.filter.DefaultRegistrableFilterListener;
import org.gvsig.raster.impl.store.ParamsImpl;

public class ConvolutionUI
extends JPanel
implements RegistrableFilterListener,
ActionListener,
FocusListener {
    private static final long serialVersionUID = 7102390746959243164L;
    private JTextField[][] matrix = new JTextField[5][5];
    private JPanel panelMatrixSelector = null;
    private JPanel panelMatrix = null;
    private JPanel panelSelector = null;
    private JPanel panelTest = null;
    private JComboBox selector = null;
    private JButton buttonTest = null;
    private JFormattedTextField divisor = null;
    private double lastValue = 0.0;
    private DefaultRegistrableFilterListener defaultRegistrableListener = null;
    private Kernel kernel = null;
    private Params loadedParams = null;

    public ConvolutionUI(Kernel k) {
        this.init(k);
    }

    public void init(Object obj) {
        if (!(obj instanceof Kernel) && obj != null) {
            return;
        }
        this.kernel = (Kernel)obj;
        this.defaultRegistrableListener = new DefaultRegistrableFilterListener();
        this.getPanelMatrixSelector().setLayout(new BorderLayout());
        this.getPanelTest().setLayout(new BorderLayout());
        GridLayout gridLayout = new GridLayout(5, 5);
        this.getPanelMatrix().setLayout(gridLayout);
        gridLayout.setVgap(2);
        gridLayout.setHgap(2);
        for (int i = 0; i < this.matrix.length; ++i) {
            for (int j = 0; j < this.matrix[0].length; ++j) {
                String value;
                if (this.kernel == null) {
                    this.matrix[i][j] = new JTextField("0");
                    if ((double)i == Math.ceil(this.matrix.length / 2) && (double)j == Math.ceil(this.matrix[0].length / 2)) {
                        this.matrix[i][j].setText("1");
                    }
                } else if (this.kernel.kernel.length == 5) {
                    value = this.kernel.kernel[i][j] == (double)((int)this.kernel.kernel[i][j]) ? (int)this.kernel.kernel[i][j] + "" : this.kernel.kernel[i][j] + "";
                    this.matrix[i][j] = new JTextField(value + "");
                } else if (this.kernel.kernel.length == 3) {
                    if (i > 0 && j > 0 && i < 4 && j < 4) {
                        value = this.kernel.kernel[i - 1][j - 1] == (double)((int)this.kernel.kernel[i - 1][j - 1]) ? (int)this.kernel.kernel[i - 1][j - 1] + "" : this.kernel.kernel[i - 1][j - 1] + "";
                        this.matrix[i][j] = new JTextField(value + "");
                    } else {
                        this.matrix[i][j] = new JTextField("0");
                        this.matrix[i][j].setVisible(false);
                    }
                }
                this.matrix[i][j].addFocusListener(this);
                this.getPanelMatrix().add(this.matrix[i][j]);
            }
        }
        this.getPanelSelector().add(new JLabel("Kernel: "));
        this.getPanelSelector().add(this.getSelector());
        this.getPanelSelector().add(new JLabel("Divisor: "));
        this.getPanelSelector().add(this.getDivisor());
        this.getPanelMatrixSelector().add((Component)this.getPanelMatrix(), "North");
        this.getPanelMatrixSelector().add((Component)this.getPanelSelector(), "South");
        if (this.kernel != null && this.kernel.kernel.length == 3) {
            this.getSelector().setSelectedIndex(0);
        } else if (this.kernel != null && this.kernel.kernel.length == 5) {
            this.getSelector().setSelectedIndex(1);
        }
        this.getPanelTest().add((Component)this.getButtonTest(), "South");
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPanelMatrixSelector(), "Center");
        this.add((Component)this.getPanelTest(), "South");
    }

    private JButton getButtonTest() {
        if (this.buttonTest == null) {
            this.buttonTest = new JButton("Test");
            this.buttonTest.addActionListener(this);
        }
        return this.buttonTest;
    }

    private JPanel getPanelTest() {
        if (this.panelTest == null) {
            this.panelTest = new JPanel();
        }
        return this.panelTest;
    }

    private JPanel getPanelMatrixSelector() {
        if (this.panelMatrixSelector == null) {
            this.panelMatrixSelector = new JPanel();
        }
        return this.panelMatrixSelector;
    }

    private JPanel getPanelMatrix() {
        if (this.panelMatrix == null) {
            this.panelMatrix = new JPanel();
        }
        return this.panelMatrix;
    }

    private JPanel getPanelSelector() {
        if (this.panelSelector == null) {
            this.panelSelector = new JPanel();
        }
        return this.panelSelector;
    }

    private JComboBox getSelector() {
        if (this.selector == null) {
            this.selector = new JComboBox<String>(new String[]{"3", "5"});
            this.selector.setSelectedIndex(1);
            this.selector.addActionListener(this);
        }
        return this.selector;
    }

    private JFormattedTextField getDivisor() {
        if (this.divisor == null) {
            NumberFormat doubleDisplayFormat = NumberFormat.getNumberInstance();
            doubleDisplayFormat.setMinimumFractionDigits(0);
            NumberFormat doubleEditFormat = NumberFormat.getNumberInstance();
            this.divisor = new JFormattedTextField(new DefaultFormatterFactory(new NumberFormatter(doubleDisplayFormat), new NumberFormatter(doubleDisplayFormat), new NumberFormatter(doubleEditFormat)));
            this.divisor.setBackground(Color.white);
            this.divisor.setValue(new Double(0.0));
            this.divisor.setColumns(3);
        }
        return this.divisor;
    }

    public Kernel getKernel() {
        double value;
        int j;
        int i;
        double[][] values = null;
        if (((String)this.selector.getSelectedItem()).equals("3")) {
            values = new double[this.matrix.length - 2][this.matrix[0].length - 2];
            for (i = 1; i < this.matrix.length - 1; ++i) {
                for (j = 1; j < this.matrix[0].length - 1; ++j) {
                    values[i - 1][j - 1] = new Double(this.matrix[i][j].getText());
                }
            }
        }
        if (((String)this.selector.getSelectedItem()).equals("5")) {
            values = new double[this.matrix.length][this.matrix[0].length];
            for (i = 0; i < this.matrix.length; ++i) {
                for (j = 0; j < this.matrix[0].length; ++j) {
                    values[i][j] = new Double(this.matrix[i][j].getText());
                }
            }
        }
        this.kernel = (value = ((Number)this.divisor.getValue()).doubleValue()) != 0.0 ? new Kernel(values, value) : new Kernel(values);
        return this.kernel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.getSelector())) {
            int j;
            int i;
            if (((String)this.selector.getSelectedItem()).equals("3")) {
                for (i = 0; i < this.matrix.length; ++i) {
                    for (j = 0; j < this.matrix[0].length; ++j) {
                        if (i == 0 || i == this.matrix.length - 1 || j == 0 || j == this.matrix[0].length - 1) {
                            this.matrix[i][j].setVisible(false);
                            continue;
                        }
                        this.matrix[i][j].setVisible(true);
                    }
                }
            }
            if (((String)this.selector.getSelectedItem()).equals("5")) {
                for (i = 0; i < this.matrix.length; ++i) {
                    for (j = 0; j < this.matrix[0].length; ++j) {
                        this.matrix[i][j].setVisible(true);
                    }
                }
            }
        }
        if (e.getSource().equals(this.getButtonTest())) {
            this.callStateChanged();
        }
    }

    public Params getParams() {
        Params params = null;
        if (this.loadedParams != null) {
            params = this.loadedParams;
            this.loadedParams = null;
            return params;
        }
        params = new ParamsImpl();
        this.defaultRegistrableListener.setParams(params);
        int lado = 0;
        if (((String)this.selector.getSelectedItem()).equals("5")) {
            lado = 1;
        }
        params.setParam("LadoVentana", (Object)new Integer(lado), 2, new String[]{"3", "5", "7"});
        params.setParam("Kernel", (Object)this.getKernel(), 2, null);
        params.setParam("FilterName", (Object)"personalizado", -1, null);
        return params;
    }

    public void setParams(Params params) {
        this.loadedParams = params;
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getSource() instanceof JTextField) {
            try {
                this.lastValue = Double.parseDouble(((JTextField)e.getSource()).getText());
            }
            catch (NumberFormatException ex) {
                this.lastValue = 0.0;
                ((JTextField)e.getSource()).setText("0");
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() instanceof JTextField) {
            try {
                Double.parseDouble(((JTextField)e.getSource()).getText());
            }
            catch (NumberFormatException ex) {
                if (this.lastValue == (double)((int)this.lastValue)) {
                    ((JTextField)e.getSource()).setText((int)this.lastValue + "");
                }
                ((JTextField)e.getSource()).setText(this.lastValue + "");
            }
        }
    }

    public void addFilterUIListener(FilterUIListener listener) {
        this.defaultRegistrableListener.addFilterUIListener(listener);
    }

    public void callStateChanged() {
        this.defaultRegistrableListener.callStateChanged();
    }

    public void removeStateChangedListener(FilterUIListener listener) {
        this.defaultRegistrableListener.removeStateChangedListener(listener);
    }
}

