/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.correction;

import java.util.Arrays;
import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.raster.impl.DefaultRasterManager;
import org.gvsig.raster.impl.grid.filter.correction.MedianFilter;

public class MedianFloatFilter
extends MedianFilter {
    @Override
    public void pre() throws FilterAddException {
        super.pre();
        this.rasterResult = DefaultRasterManager.getInstance().createBuffer(4, this.raster.getWidth(), this.raster.getHeight(), this.raster.getBandCount(), true);
    }

    @Override
    public void process(int col, int line) {
        float[] ventana = new float[this.sizeWindow];
        for (int band = 0; band < this.numberOfBandsToProcess(); ++band) {
            int k = 0;
            for (int i = -this.halfSide; i <= this.halfSide; ++i) {
                for (int j = -this.halfSide; j <= this.halfSide; ++j) {
                    if (col + i < 0 || line + j < 0 || col + i >= this.width || line + j >= this.height) continue;
                    ventana[k] = this.raster.getElemFloat(line + j, col + i, band);
                    ++k;
                }
            }
            Arrays.sort(ventana, 0, k);
            this.rasterResult.setElem(line, col, band, ventana[k >> 1]);
        }
    }

    @Override
    public int getInRasterDataType() {
        return 4;
    }

    @Override
    public int getOutRasterDataType() {
        return 4;
    }
}

