/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.enhancement;

import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.fmap.dal.coverage.grid.filter.BaseRasterFilter;
import org.gvsig.raster.impl.store.ParamsImpl;

public class ContrastFilter
extends BaseRasterFilter {
    public static String[] names = new String[]{"contrast"};
    int incrContraste = 0;

    public ContrastFilter() {
        this.setName(names[0]);
    }

    public void pre() throws FilterAddException {
        super.pre();
        this.incrContraste = (Integer)this.params.get("incrContraste");
        this.createBufferResult(0, this.raster.getBandCount());
    }

    public void post() {
        this.raster = null;
    }

    public int getContrastIncrease() {
        return this.incrContraste;
    }

    public String getGroup() {
        return "realces";
    }

    public Params getUIParams(String nameFilter) {
        ParamsImpl params = new ParamsImpl();
        params.setParam("Contrast", new Integer(this.incrContraste), 3, new String[]{"-255", "255", "50", "1", "25"});
        return params;
    }

    public int getInRasterDataType() {
        return 0;
    }

    public int getOutRasterDataType() {
        return 0;
    }

    public void process(int x, int y) {
    }

    protected int calcContrast(int px) {
        int result;
        int diferencia = 127 - px;
        if (this.incrContraste >= 0) {
            result = (int)((double)px - 0.02 * (double)diferencia * (double)this.incrContraste);
        } else {
            result = (int)((double)px - 0.004 * (double)diferencia * (double)this.incrContraste);
            if (px < 127) {
                if (result > 127) {
                    result = 127;
                }
            } else if (result < 127) {
                result = 127;
            }
        }
        if (result < 0) {
            result = 0;
        } else if (result > 255) {
            result = 255;
        }
        return result;
    }

    public String[] getNames() {
        return names;
    }
}

