/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.enhancement;

import org.gvsig.raster.impl.grid.filter.enhancement.EqualizationFilter;

public class EqualizationByteFilter
extends EqualizationFilter {
    @Override
    public void process(int col, int line) {
        for (int iBand = 0; iBand < this.numberOfBandsToProcess(); ++iBand) {
            int p = this.raster.getElemByte(line, col, iBand) & 0xFF;
            if (!this.equalizationActive(iBand)) {
                this.rasterResult.setElem(line, col, iBand, (byte)p);
                continue;
            }
            int ecualizationPositive = (int)this.lahe[iBand][p % this.histogram.getNumValues()];
            int ecualizationNegative = (int)this.laheNegative[iBand][this.nElements - p % this.histogram.getNumValues()];
            int value = (this.nElements - ecualizationNegative + ecualizationPositive) / 2;
            this.rasterResult.setElem(line, col, iBand, (byte)(value & 0xFF));
        }
        this.writeAlphaBand(line, col);
    }

    @Override
    public int getInRasterDataType() {
        return 0;
    }
}

