/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.enhancement;

import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.datastruct.BufferHistogram;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.fmap.dal.coverage.exception.HistogramException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.grid.filter.BaseRasterFilter;
import org.gvsig.fmap.dal.coverage.store.props.HistogramComputer;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.raster.impl.datastruct.BufferHistogramImpl;
import org.gvsig.raster.impl.store.ParamsImpl;

public class EqualizationFilter
extends BaseRasterFilter {
    protected Statistics stats = null;
    protected double[] minBandValue = null;
    protected double[] maxBandValue = null;
    protected int nbands = 3;
    protected int[] k = null;
    public static String[] names = new String[]{"equalization"};
    protected BufferHistogram histogram = null;
    protected long nPixels = 0L;
    protected int[][] resValues = null;
    protected int nElements = 0;
    protected int[] ecualizedBands = null;
    protected double[][] aproximationNeg = null;
    protected int nClasses = RasterLibrary.defaultNumberOfClasses;
    protected long[][] lahe = null;
    protected long[][] laheNegative = null;

    public EqualizationFilter() {
        this.setName(names[0]);
    }

    public void pre() throws FilterAddException {
        HistogramComputer hist;
        block19: {
            super.pre();
            this.stats = (Statistics)this.getEnv().get("SrcStatistics");
            hist = (HistogramComputer)this.getEnv().get("SrcHistogram");
            try {
                if (this.stats.isCalculated()) break block19;
                try {
                    this.stats.calculate(RasterLibrary.statisticsScale);
                }
                catch (FileNotOpenException e) {
                    return;
                }
                catch (RasterDriverException e) {
                    return;
                }
            }
            catch (ProcessInterruptedException e) {
                // empty catch block
            }
        }
        try {
            this.histogram = hist.getBufferHistogram();
        }
        catch (ProcessInterruptedException e) {
            this.exec = false;
        }
        catch (HistogramException e) {
            this.exec = false;
        }
        this.ecualizedBands = (int[])this.params.get("ecualizedBands");
        if (this.ecualizedBands == null) {
            this.ecualizedBands = this.getColorInterpretation().buildRenderBands();
        }
        this.height = this.raster.getHeight();
        this.width = this.raster.getWidth();
        this.nPixels = this.height * this.width;
        try {
            this.stats.calculate(RasterLibrary.statisticsScale);
        }
        catch (FileNotOpenException e) {
            this.exec = false;
        }
        catch (RasterDriverException e) {
            this.exec = false;
        }
        catch (ProcessInterruptedException e) {
            this.exec = false;
        }
        if (this.raster.getDataType() == 0) {
            this.minBandValue = this.stats.getMinByteUnsigned();
            this.maxBandValue = this.stats.getMaxByteUnsigned();
        }
        if (this.minBandValue == null || this.maxBandValue == null || this.minBandValue[0] == 0.0 && this.maxBandValue[0] == 0.0) {
            this.minBandValue = new double[this.raster.getBandCount()];
            this.maxBandValue = new double[this.raster.getBandCount()];
            if (this.raster.getDataType() == 0) {
                for (int i = 0; i < this.minBandValue.length; ++i) {
                    this.minBandValue[i] = 0.0;
                    this.maxBandValue[i] = 255.0;
                }
            } else {
                this.minBandValue = this.stats.getMin();
                this.maxBandValue = this.stats.getMax();
            }
        }
        BufferHistogram rgbHistogram = null;
        rgbHistogram = this.raster.getDataType() == 0 ? BufferHistogramImpl.convertHistogramToRGB(this.histogram) : this.histogram;
        double[][] accumNormalize = BufferHistogramImpl.convertTableToNormalizeAccumulate(rgbHistogram.getTable());
        double[][] accumNormalizeNeg = BufferHistogramImpl.convertTableToNormalizeAccumulate(rgbHistogram.getNegativeTable());
        int value = 255;
        if (this.raster.getDataType() != 0) {
            value = this.nClasses;
        }
        this.lahe = this.lahe(accumNormalize, value);
        this.laheNegative = this.lahe(accumNormalizeNeg, value);
        this.nElements = this.laheNegative[0].length - 1;
        this.nbands = this.stats.getBandCount();
        this.createBufferResult(this.raster.getDataType(), this.raster.getBandCount());
    }

    private long[][] lahe(double[][] accumNorm, int value) {
        long[][] res = new long[accumNorm.length][accumNorm[0].length];
        for (int i = 0; i < res.length; ++i) {
            for (int j = 0; j < res[i].length; ++j) {
                res[i][j] = Math.round(accumNorm[i][j] * (double)value);
            }
        }
        return res;
    }

    protected boolean equalizationActive(int band) {
        for (int i = 0; i < this.ecualizedBands.length; ++i) {
            if (band != this.ecualizedBands[i]) continue;
            return true;
        }
        return false;
    }

    public int getOutRasterDataType() {
        return 0;
    }

    public String getGroup() {
        return "realces";
    }

    public Params getUIParams(String nameFilter) {
        return new ParamsImpl();
    }

    public void post() {
        this.raster = null;
    }

    public int getInRasterDataType() {
        return 0;
    }

    public void process(int x, int y) {
    }

    public String[] getNames() {
        return names;
    }

    public boolean isVisible() {
        return true;
    }
}

