/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.enhancement;

import org.gvsig.raster.impl.datastruct.DefaultStretch;
import org.gvsig.raster.impl.grid.filter.enhancement.LinearStretchEnhancementFilter;

public class LinearStretchEnhancementIntegerFilter
extends LinearStretchEnhancementFilter {
    @Override
    public void process(int col, int line) {
        for (int destinationBand = 0; destinationBand < this.renderBands.length; ++destinationBand) {
            if (this.renderBands[destinationBand] < 0) continue;
            int p = this.raster.getElemInt(line, col, destinationBand);
            if (destinationBand < this.scaleOffsetList.length) {
                this.processValue(p, this.scaleOffsetList[destinationBand], col, line, destinationBand);
                continue;
            }
            this.rasterResult.setElem(line, col, destinationBand, (byte)p);
        }
    }

    private void processValue(int p, DefaultStretch data, int col, int line, int iBand) {
        if (data.scale != null) {
            if ((double)p > data.maxValue) {
                p = (int)data.maxValue;
            } else if ((double)p < data.minValue) {
                p = (int)data.minValue;
            }
            for (int i = 0; i < data.scale.length; ++i) {
                if (!((double)p > data.stretchIn[i] && (double)p <= data.stretchIn[i + 1]) && (i != 0 || (double)p != data.stretchIn[i])) continue;
                p = (int)(((double)p - data.stretchIn[i]) * data.scale[i] + data.offset[i]);
                break;
            }
            this.rasterResult.setElem(line, col, iBand, (byte)((byte)p & 0xFF));
        }
    }

    @Override
    public int getInRasterDataType() {
        return 3;
    }
}

