/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.segmentation;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.grid.AbstractRasterFilterManager;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.raster.impl.grid.filter.RasterFilterListManagerImpl;
import org.gvsig.raster.impl.grid.filter.segmentation.FirstDerivativeByteFilter;
import org.gvsig.raster.impl.grid.filter.segmentation.FirstDerivativeFilter;
import org.gvsig.raster.impl.store.ParamImpl;

public class FirstDerivativeListManager
extends AbstractRasterFilterManager {
    private static String ID = "FirstDerivative";

    public FirstDerivativeListManager(RasterFilterList filterList) {
        super(filterList);
    }

    public String getManagerID() {
        return ID;
    }

    public static void register() {
        AbstractRasterFilterManager.register((String)ID, FirstDerivativeListManager.class);
    }

    public FirstDerivativeListManager(RasterFilterListManagerImpl filterListManager) {
        super(filterListManager.getFilterList());
    }

    public boolean isDataTypeSupported(int dataType) {
        return true;
    }

    public Class<?> getFilterClassByID(String id) {
        if (id.compareTo("sobel") == 0 || id.compareTo("roberts") == 0 || id.compareTo("prewitt") == 0 || id.compareTo("freichen") == 0) {
            return FirstDerivativeFilter.class;
        }
        return null;
    }

    public void addFirstDerivativeFilter(int umbral, boolean compare, String Name) throws FilterTypeException {
        FirstDerivativeByteFilter filter = new FirstDerivativeByteFilter();
        if (filter != null) {
            filter.addParam("umbral", new Integer(umbral));
            filter.addParam("compare", new Boolean(compare));
            filter.addParam("filterName", new String(Name));
            filter.setName(Name);
            this.getFilterList().add((RasterFilter)filter);
        }
    }

    public List<Class<?>> getRasterFilterList() {
        ArrayList filters = new ArrayList();
        filters.add(FirstDerivativeFilter.class);
        return filters;
    }

    public void addFilter(Class<?> classFilter, Params params) throws FilterTypeException {
        if (FirstDerivativeFilter.class.isAssignableFrom(classFilter)) {
            int umbral = 0;
            boolean compare = false;
            String name = "";
            for (int i = 0; i < params.getNumParams(); ++i) {
                if (((ParamImpl)params.getParam(i)).getId().equals("Umbral") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Integer) {
                    umbral = (Integer)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("Compare") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Boolean) {
                    compare = (Boolean)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (!((ParamImpl)params.getParam(i)).getId().equals("FilterName") || !(((ParamImpl)params.getParam(i)).getDefaultValue() instanceof String)) continue;
                name = (String)((ParamImpl)params.getParam(i)).getDefaultValue();
            }
            this.addFirstDerivativeFilter(umbral, compare, name);
        }
    }

    public void addFilter(Params params) throws FilterTypeException {
        this.addFilter(FirstDerivativeFilter.class, params);
    }

    public RasterFilter createFilter(Params params) {
        if (params.getParamById("Umbral") != null) {
            Integer umbral = (Integer)params.getParamById("Umbral").getDefaultValue();
            Boolean compare = (Boolean)params.getParamById("Compare").getDefaultValue();
            String name = (String)params.getParamById("FilterName").getDefaultValue();
            FirstDerivativeByteFilter filter = new FirstDerivativeByteFilter();
            filter.addParam("umbral", new Integer(umbral));
            filter.addParam("compare", new Boolean(compare));
            filter.addParam("filterName", new String(name));
            return filter;
        }
        return null;
    }
}

