/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.statistics;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.datastruct.Param;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.grid.AbstractRasterFilterManager;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.raster.impl.grid.filter.RasterFilterListManagerImpl;
import org.gvsig.raster.impl.grid.filter.statistics.TailTrimFilter;
import org.gvsig.raster.impl.grid.filter.statistics.TailTrimFloatFilter;

public class StatisticsListManager
extends AbstractRasterFilterManager {
    private static String ID = "Statistics";

    public String getManagerID() {
        return ID;
    }

    public static void register() {
        AbstractRasterFilterManager.register((String)ID, StatisticsListManager.class);
    }

    public StatisticsListManager(RasterFilterList filterList) {
        super(filterList);
    }

    public StatisticsListManager(RasterFilterListManagerImpl filterListManager) {
        super(filterListManager.getFilterList());
    }

    public boolean isDataTypeSupported(int dataType) {
        return true;
    }

    public Class<?> getFilterClassByID(String id) {
        if (id.compareTo("tailTrim") == 0) {
            return TailTrimFilter.class;
        }
        return null;
    }

    public void addTailFilter(double tail, double samples, boolean removeMaxValue, Statistics stats) throws FilterTypeException {
        RasterFilter filter = StatisticsListManager.createTailFilter(tail, samples, removeMaxValue, stats);
        if (filter != null) {
            this.getFilterList().add(filter);
        }
    }

    public void addTailFilter(double[] tailList, double samples, boolean removeMaxValue, Statistics stats) throws FilterTypeException {
        RasterFilter filter = StatisticsListManager.createTailFilter(tailList, samples, removeMaxValue, stats);
        if (filter != null) {
            this.getFilterList().add(filter);
        }
    }

    public static RasterFilter createTailFilter(double tail, double samples, boolean removeMaxValue, Statistics stats) {
        TailTrimFloatFilter filter = new TailTrimFloatFilter();
        if (filter != null) {
            filter.addParam("stats", stats);
            filter.addParam("tail", new Double(tail));
            filter.addParam("samples", new Double(samples));
            filter.addParam("remove", new Boolean(removeMaxValue));
        }
        return filter;
    }

    public static RasterFilter createTailFilter(double[] tailList, double samples, boolean removeMaxValue, Statistics stats) {
        TailTrimFloatFilter filter = new TailTrimFloatFilter();
        if (filter != null) {
            filter.addParam("stats", stats);
            filter.addParam("tailList", tailList);
            filter.addParam("samples", new Double(samples));
            filter.addParam("remove", new Boolean(removeMaxValue));
        }
        return filter;
    }

    public List<Class<?>> getRasterFilterList() {
        ArrayList filters = new ArrayList();
        filters.add(TailTrimFilter.class);
        return filters;
    }

    public void addFilter(Class<?> classFilter, Params params) {
        if (TailTrimFilter.class.isAssignableFrom(classFilter)) {
            try {
                this.addFilter(params);
            }
            catch (FilterTypeException filterTypeException) {
                // empty catch block
            }
        }
    }

    public void addFilter(Params params) throws FilterTypeException {
        if (params.getParamById("tail") != null && params.getParamById("samples") != null && params.getParamById("remove") != null) {
            Statistics stats;
            Param p = params.getParamById("stats");
            Statistics statistics = stats = p != null ? (Statistics)p.getDefaultValue() : null;
            if (stats == null) {
                stats = (Statistics)this.getFilterList().getEnvParam("SrcStatistics");
            }
            this.addTailFilter((Double)params.getParamById("tail").getDefaultValue(), (double)((Double)params.getParamById("samples").getDefaultValue()), (boolean)((Boolean)params.getParamById("remove").getDefaultValue()), stats);
        }
    }

    public RasterFilter createFilter(Params params) {
        if (params.getParamById("tail") != null && params.getParamById("samples") != null && params.getParamById("remove") != null) {
            Statistics stats;
            Param p = params.getParamById("stats");
            Statistics statistics = stats = p != null ? (Statistics)p.getDefaultValue() : null;
            if (stats == null) {
                stats = (Statistics)this.getFilterList().getEnvParam("SrcStatistics");
            }
            TailTrimFloatFilter filter = new TailTrimFloatFilter();
            filter.addParam("stats", stats);
            filter.addParam("tail", params.getParamById("tail").getDefaultValue());
            filter.addParam("samples", params.getParamById("samples").getDefaultValue());
            filter.addParam("remove", params.getParamById("remove").getDefaultValue());
            if (params.getParamById("tailList") != null) {
                filter.addParam("tailList", params.getParamById("tailList").getDefaultValue());
            }
            return filter;
        }
        return null;
    }
}

