/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.statistics;

import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.raster.impl.grid.filter.statistics.TailTrimFilter;

public class TailTrimByteFilter
extends TailTrimFilter {
    private double[][] result = null;

    @Override
    public void pre() throws FilterAddException {
        super.pre();
        this.sample = new int[this.raster.getBandCount()][this.nSamples];
        this.result = new double[this.raster.getBandCount()][2];
    }

    @Override
    public void process(int col, int line) {
        for (int iBand = 0; iBand < this.raster.getBandCount(); ++iBand) {
            this.sample[iBand][this.count] = this.raster.getElemByte(line, col, iBand) & 0xFF;
        }
        ++this.count;
    }

    @Override
    public int getInRasterDataType() {
        return 0;
    }

    @Override
    public int getOutRasterDataType() {
        return 0;
    }

    @Override
    public void post() {
        super.post();
        for (int i = 0; i < this.raster.getBandCount(); ++i) {
            this.result[i][0] = this.sample[i][this.posInit + this.tailSize];
            this.result[i][1] = this.sample[i][this.posInit + this.nSamples - this.tailSize];
        }
        this.stats.setTailTrimValue(this.tailPercent, (Object)this.result);
        for (int iValue = 0; iValue < this.tailSizeList.length; ++iValue) {
            double[][] res = new double[this.raster.getBandCount()][2];
            for (int i = 0; i < this.raster.getBandCount(); ++i) {
                res[i][0] = this.sample[i][this.posInit + this.tailSizeList[iValue]];
                res[i][1] = this.sample[i][this.posInit + this.nSamples - this.tailSizeList[iValue]];
            }
            this.stats.setTailTrimValue(this.tailPercentList[iValue], (Object)res);
        }
    }
}

